/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.schedule;

import com.dangdang.ddframe.job.lite.api.strategy.JobInstance;
import com.dangdang.ddframe.job.lite.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class JobRegistry {
    private static volatile JobRegistry instance;
    private Map<String, JobScheduleController> schedulerMap = new ConcurrentHashMap<String, JobScheduleController>();
    private Map<String, CoordinatorRegistryCenter> regCenterMap = new ConcurrentHashMap<String, CoordinatorRegistryCenter>();
    private Map<String, JobInstance> jobInstanceMap = new ConcurrentHashMap<String, JobInstance>();
    private Map<String, Boolean> jobRunningMap = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Integer> currentShardingTotalCountMap = new ConcurrentHashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobRegistry getInstance() {
        if (null != instance) return instance;
        Class<JobRegistry> clazz = JobRegistry.class;
        synchronized (JobRegistry.class) {
            if (null != instance) return instance;
            instance = new JobRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerJob(String jobName, JobScheduleController jobScheduleController, CoordinatorRegistryCenter regCenter) {
        this.schedulerMap.put(jobName, jobScheduleController);
        this.regCenterMap.put(jobName, regCenter);
        regCenter.addCacheData("/" + jobName);
    }

    public JobScheduleController getJobScheduleController(String jobName) {
        return this.schedulerMap.get(jobName);
    }

    public CoordinatorRegistryCenter getRegCenter(String jobName) {
        return this.regCenterMap.get(jobName);
    }

    public void addJobInstance(String jobName, JobInstance jobInstance) {
        this.jobInstanceMap.put(jobName, jobInstance);
    }

    public JobInstance getJobInstance(String jobName) {
        return this.jobInstanceMap.get(jobName);
    }

    public boolean isJobRunning(String jobName) {
        Boolean result = this.jobRunningMap.get(jobName);
        return null == result ? false : result;
    }

    public void setJobRunning(String jobName, boolean isRunning) {
        this.jobRunningMap.put(jobName, isRunning);
    }

    public int getCurrentShardingTotalCount(String jobName) {
        Integer result = this.currentShardingTotalCountMap.get(jobName);
        return null == result ? 0 : result;
    }

    public void setCurrentShardingTotalCount(String jobName, int currentShardingTotalCount) {
        this.currentShardingTotalCountMap.put(jobName, currentShardingTotalCount);
    }

    public void shutdown(String jobName) {
        CoordinatorRegistryCenter regCenter;
        JobScheduleController scheduleController = this.schedulerMap.remove(jobName);
        if (null != scheduleController) {
            scheduleController.shutdown();
        }
        if (null != (regCenter = this.regCenterMap.remove(jobName))) {
            regCenter.evictCacheData("/" + jobName);
        }
        this.jobInstanceMap.remove(jobName);
        this.jobRunningMap.remove(jobName);
        this.currentShardingTotalCountMap.remove(jobName);
    }

    public boolean isShutdown(String jobName) {
        return !this.schedulerMap.containsKey(jobName) || !this.jobInstanceMap.containsKey(jobName);
    }

    private JobRegistry() {
    }
}

