/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.listener;

import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.internal.config.RescheduleListenerManager;
import com.dangdang.ddframe.job.lite.internal.election.ElectionListenerManager;
import com.dangdang.ddframe.job.lite.internal.failover.FailoverListenerManager;
import com.dangdang.ddframe.job.lite.internal.guarantee.GuaranteeListenerManager;
import com.dangdang.ddframe.job.lite.internal.instance.ShutdownListenerManager;
import com.dangdang.ddframe.job.lite.internal.instance.TriggerListenerManager;
import com.dangdang.ddframe.job.lite.internal.listener.RegistryCenterConnectionStateListener;
import com.dangdang.ddframe.job.lite.internal.sharding.MonitorExecutionListenerManager;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingListenerManager;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.List;

public final class ListenerManager {
    private final JobNodeStorage jobNodeStorage;
    private final ElectionListenerManager electionListenerManager;
    private final ShardingListenerManager shardingListenerManager;
    private final FailoverListenerManager failoverListenerManager;
    private final MonitorExecutionListenerManager monitorExecutionListenerManager;
    private final ShutdownListenerManager shutdownListenerManager;
    private final TriggerListenerManager triggerListenerManager;
    private final RescheduleListenerManager rescheduleListenerManager;
    private final GuaranteeListenerManager guaranteeListenerManager;
    private final RegistryCenterConnectionStateListener regCenterConnectionStateListener;

    public ListenerManager(CoordinatorRegistryCenter regCenter, String jobName, List<ElasticJobListener> elasticJobListeners) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.electionListenerManager = new ElectionListenerManager(regCenter, jobName);
        this.shardingListenerManager = new ShardingListenerManager(regCenter, jobName);
        this.failoverListenerManager = new FailoverListenerManager(regCenter, jobName);
        this.monitorExecutionListenerManager = new MonitorExecutionListenerManager(regCenter, jobName);
        this.shutdownListenerManager = new ShutdownListenerManager(regCenter, jobName);
        this.triggerListenerManager = new TriggerListenerManager(regCenter, jobName);
        this.rescheduleListenerManager = new RescheduleListenerManager(regCenter, jobName);
        this.guaranteeListenerManager = new GuaranteeListenerManager(regCenter, jobName, elasticJobListeners);
        this.regCenterConnectionStateListener = new RegistryCenterConnectionStateListener(regCenter, jobName);
    }

    public void startAllListeners() {
        this.electionListenerManager.start();
        this.shardingListenerManager.start();
        this.failoverListenerManager.start();
        this.monitorExecutionListenerManager.start();
        this.shutdownListenerManager.start();
        this.triggerListenerManager.start();
        this.rescheduleListenerManager.start();
        this.guaranteeListenerManager.start();
        this.jobNodeStorage.addConnectionStateListener(this.regCenterConnectionStateListener);
    }
}

