/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.api.strategy;

import com.dangdang.ddframe.job.exception.JobConfigurationException;
import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategy;
import com.dangdang.ddframe.job.lite.api.strategy.impl.AverageAllocationJobShardingStrategy;
import com.google.common.base.Strings;

public final class JobShardingStrategyFactory {
    public static JobShardingStrategy getStrategy(String jobShardingStrategyClassName) {
        if (Strings.isNullOrEmpty((String)jobShardingStrategyClassName)) {
            return new AverageAllocationJobShardingStrategy();
        }
        try {
            Class<?> jobShardingStrategyClass = Class.forName(jobShardingStrategyClassName);
            if (!JobShardingStrategy.class.isAssignableFrom(jobShardingStrategyClass)) {
                throw new JobConfigurationException("Class '%s' is not job strategy class", new Object[]{jobShardingStrategyClassName});
            }
            return (JobShardingStrategy)jobShardingStrategyClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new JobConfigurationException("Sharding strategy class '%s' config error, message details are '%s'", new Object[]{jobShardingStrategyClassName, ex.getMessage()});
        }
    }

    private JobShardingStrategyFactory() {
    }
}

