/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.modelbuild;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.ExcelColumnProperty;
import com.alibaba.excel.metadata.ExcelHeadProperty;
import com.alibaba.excel.util.TypeUtil;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public class ModelBuildEventListener
extends AnalysisEventListener {
    public void invoke(Object object, AnalysisContext context) {
        if (context.getExcelHeadProperty() != null && context.getExcelHeadProperty().getHeadClazz() != null) {
            Object resultModel = this.buildUserModel(context, (List)object);
            context.setCurrentRowAnalysisResult(resultModel);
        }
    }

    private Object buildUserModel(AnalysisContext context, List<String> stringList) {
        Object resultModel;
        ExcelHeadProperty excelHeadProperty = context.getExcelHeadProperty();
        try {
            resultModel = excelHeadProperty.getHeadClazz().newInstance();
        }
        catch (Exception e) {
            throw new ExcelGenerateException(e);
        }
        if (excelHeadProperty != null) {
            for (int i = 0; i < stringList.size(); ++i) {
                Object value;
                ExcelColumnProperty columnProperty = excelHeadProperty.getExcelColumnProperty(i);
                if (columnProperty == null || (value = TypeUtil.convert(stringList.get(i), columnProperty.getField(), columnProperty.getFormat(), context.use1904WindowDate())) == null) continue;
                try {
                    BeanUtils.setProperty(resultModel, (String)columnProperty.getField().getName(), (Object)value);
                    continue;
                }
                catch (Exception e) {
                    throw new ExcelGenerateException(columnProperty.getField().getName() + " can not set value " + value, e);
                }
            }
        }
        return resultModel;
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
    }
}

