/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidConnectionHolder;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidPooledResultSet;
import com.alibaba.druid.pool.PoolableWrapper;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DruidPooledStatement
extends PoolableWrapper
implements Statement {
    private static final Log LOG = LogFactory.getLog(DruidPooledStatement.class);
    private final Statement stmt;
    protected DruidPooledConnection conn;
    protected List<ResultSet> resultSetTrace;
    protected boolean closed = false;
    protected int fetchRowPeak = -1;

    public DruidPooledStatement(DruidPooledConnection conn, Statement stmt) {
        super(stmt);
        this.conn = conn;
        this.stmt = stmt;
    }

    protected void addResultSetTrace(ResultSet resultSet) {
        if (this.resultSetTrace == null) {
            this.resultSetTrace = new ArrayList<ResultSet>(1);
        }
        this.resultSetTrace.add(resultSet);
    }

    protected void recordFetchRowCount(int fetchRowCount) {
        if (this.fetchRowPeak < fetchRowCount) {
            this.fetchRowPeak = fetchRowCount;
        }
    }

    public int getFetchRowPeak() {
        return this.fetchRowPeak;
    }

    protected SQLException checkException(Throwable error) throws SQLException {
        return this.conn.handleException(error);
    }

    public DruidPooledConnection getPoolableConnection() {
        return this.conn;
    }

    public Statement getStatement() {
        return this.stmt;
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            Throwable disableError = null;
            if (this.conn != null) {
                disableError = this.conn.getDisableError();
            }
            if (disableError != null) {
                throw new SQLException("statement is closed", disableError);
            }
            throw new SQLException("statement is closed");
        }
    }

    protected void clearResultSet() {
        if (this.resultSetTrace == null) {
            return;
        }
        for (ResultSet rs : this.resultSetTrace) {
            try {
                if (rs.isClosed()) continue;
                rs.close();
            }
            catch (SQLException ex) {
                LOG.error("clearResultSet error", ex);
            }
        }
        this.resultSetTrace.clear();
    }

    public void incrementExecuteCount() {
        DruidPooledConnection conn = this.getPoolableConnection();
        if (conn == null) {
            return;
        }
        DruidConnectionHolder holder = conn.getConnectionHolder();
        if (holder == null) {
            return;
        }
        if (holder.getDataSource() == null) {
            return;
        }
        holder.getDataSource().incrementExecuteCount();
    }

    protected void transactionRecord(String sql) throws SQLException {
        this.conn.transactionRecord(sql);
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(sql);
        this.conn.beforeExecute();
        try {
            ResultSet rs = this.stmt.executeQuery(sql);
            if (rs == null) {
                ResultSet resultSet = rs;
                return resultSet;
            }
            DruidPooledResultSet poolableResultSet = new DruidPooledResultSet(this, rs);
            this.addResultSetTrace(poolableResultSet);
            DruidPooledResultSet druidPooledResultSet = poolableResultSet;
            return druidPooledResultSet;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(sql);
        this.conn.beforeExecute();
        try {
            int n = this.stmt.executeUpdate(sql);
            return n;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(sql);
        this.conn.beforeExecute();
        try {
            int n = this.stmt.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(sql);
        this.conn.beforeExecute();
        try {
            int n = this.stmt.executeUpdate(sql, columnIndexes);
            return n;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(sql);
        this.conn.beforeExecute();
        try {
            int n = this.stmt.executeUpdate(sql, columnNames);
            return n;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(sql);
        this.conn.beforeExecute();
        try {
            boolean bl = this.stmt.execute(sql, autoGeneratedKeys);
            return bl;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(sql);
        this.conn.beforeExecute();
        try {
            boolean bl = this.stmt.execute(sql, columnIndexes);
            return bl;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(sql);
        this.conn.beforeExecute();
        try {
            boolean bl = this.stmt.execute(sql, columnNames);
            return bl;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getMaxFieldSize();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.clearResultSet();
            this.stmt.close();
            this.closed = true;
            if (this.conn.getConnectionHolder() != null) {
                this.conn.getConnectionHolder().removeTrace(this);
            }
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setMaxFieldSize(max);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final int getMaxRows() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getMaxRows();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setMaxRows(max);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setEscapeProcessing(enable);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getQueryTimeout();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setQueryTimeout(seconds);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final void cancel() throws SQLException {
        this.checkOpen();
        try {
            this.stmt.cancel();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this.stmt.clearWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final void setCursorName(String name) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setCursorName(name);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(sql);
        try {
            return this.stmt.execute(sql);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        try {
            ResultSet rs = this.stmt.getResultSet();
            if (rs == null) {
                return null;
            }
            DruidPooledResultSet poolableResultSet = new DruidPooledResultSet(this, rs);
            this.addResultSetTrace(poolableResultSet);
            return poolableResultSet;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getUpdateCount();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        this.checkOpen();
        try {
            ResultSet lastResultSet;
            boolean moreResults = this.stmt.getMoreResults();
            if (this.resultSetTrace != null && this.resultSetTrace.size() > 0 && (lastResultSet = this.resultSetTrace.get(this.resultSetTrace.size() - 1)) instanceof DruidPooledResultSet) {
                DruidPooledResultSet pooledResultSet = (DruidPooledResultSet)lastResultSet;
                pooledResultSet.closed = true;
            }
            return moreResults;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setFetchDirection(direction);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getFetchDirection();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setFetchSize(rows);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final int getFetchSize() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getFetchSize();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getResultSetConcurrency();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final int getResultSetType() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getResultSetType();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        this.checkOpen();
        this.transactionRecord(sql);
        try {
            this.stmt.addBatch(sql);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final void clearBatch() throws SQLException {
        if (this.closed) {
            return;
        }
        try {
            this.stmt.clearBatch();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.conn.beforeExecute();
        try {
            int[] nArray = this.stmt.executeBatch();
            return nArray;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.conn;
    }

    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        try {
            ResultSet lastResultSet;
            boolean results = this.stmt.getMoreResults(current);
            if (this.resultSetTrace != null && this.resultSetTrace.size() > 0 && (lastResultSet = this.resultSetTrace.get(this.resultSetTrace.size() - 1)) instanceof DruidPooledResultSet) {
                DruidPooledResultSet pooledResultSet = (DruidPooledResultSet)lastResultSet;
                pooledResultSet.closed = true;
            }
            return results;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        try {
            ResultSet rs = this.stmt.getGeneratedKeys();
            DruidPooledResultSet poolableResultSet = new DruidPooledResultSet(this, rs);
            this.addResultSetTrace(poolableResultSet);
            return poolableResultSet;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getResultSetHoldability();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        if (poolable) {
            return;
        }
        throw new SQLException("not support");
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        return false;
    }

    public String toString() {
        return this.stmt.toString();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

