/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.extra.template.engine.beetl.BeetlEngine;
import cn.hutool.extra.template.engine.enjoy.EnjoyEngine;
import cn.hutool.extra.template.engine.freemarker.FreemarkerEngine;
import cn.hutool.extra.template.engine.rythm.RythmEngine;
import cn.hutool.extra.template.engine.thymeleaf.ThymeleafEngine;
import cn.hutool.extra.template.engine.velocity.VelocityEngine;
import cn.hutool.log.StaticLog;

public class TemplateFactory {
    public static TemplateEngine create(TemplateConfig config) {
        TemplateEngine engine = TemplateFactory.doCreate(config);
        StaticLog.debug("Use [{}] Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static TemplateEngine doCreate(TemplateConfig config) {
        try {
            return new BeetlEngine(config);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            try {
                return new FreemarkerEngine(config);
            }
            catch (NoClassDefFoundError noClassDefFoundError2) {
                try {
                    return new VelocityEngine(config);
                }
                catch (NoClassDefFoundError noClassDefFoundError3) {
                    try {
                        return new RythmEngine(config);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError4) {
                        try {
                            return new EnjoyEngine(config);
                        }
                        catch (NoClassDefFoundError noClassDefFoundError5) {
                            try {
                                return new ThymeleafEngine(config);
                            }
                            catch (NoClassDefFoundError noClassDefFoundError6) {
                                throw new TemplateException("No template found ! Please add one of template jar to your project !");
                            }
                        }
                    }
                }
            }
        }
    }
}

