/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class SymmetricCrypto {
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private Lock lock = new ReentrantLock();

    public SymmetricCrypto(SymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, SecretKey key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(String algorithm, byte[] key) {
        this(algorithm, KeyUtil.generateKey(algorithm, key));
    }

    public SymmetricCrypto(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        if (null != paramsSpec) {
            this.setParams(paramsSpec);
        }
    }

    public SymmetricCrypto init(String algorithm, SecretKey key) {
        this.secretKey = key;
        if (algorithm.startsWith("PBE")) {
            this.params = new PBEParameterSpec(RandomUtil.randomBytes(8), 100);
        }
        this.cipher = SecureUtil.createCipher(algorithm);
        return this;
    }

    public SymmetricCrypto setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.cipher.init(1, this.secretKey);
            } else {
                this.cipher.init(1, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.cipher.doFinal(data);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String encryptHex(byte[] data) {
        return HexUtil.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(byte[] data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] encrypt(String data, String charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, charset));
    }

    public String encryptHex(String data, String charset) {
        return HexUtil.encodeHexStr(this.encrypt(data, charset));
    }

    public String encryptBase64(String data, String charset) {
        return Base64.encode(this.encrypt(data, charset));
    }

    public byte[] encrypt(String data) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, CharsetUtil.CHARSET_UTF_8));
    }

    public String encryptHex(String data) {
        return HexUtil.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(String data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] encrypt(InputStream data) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes(data));
    }

    public String encryptHex(InputStream data) {
        return HexUtil.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(InputStream data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] decrypt(byte[] bytes) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.cipher.init(2, this.secretKey);
            } else {
                this.cipher.init(2, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.cipher.doFinal(bytes);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String decryptStr(byte[] bytes, Charset charset) {
        return StrUtil.str(this.decrypt(bytes), charset);
    }

    public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decrypt(String data) {
        return this.decrypt(SecureUtil.decode(data));
    }

    public String decryptStr(String data, Charset charset) {
        return StrUtil.str(this.decrypt(data), charset);
    }

    public String decryptStr(String data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decrypt(InputStream data) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes(data));
    }

    public String decryptStr(InputStream data, Charset charset) {
        return StrUtil.str(this.decrypt(data), charset);
    }

    public String decryptStr(InputStream data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getClipher() {
        return this.cipher;
    }
}

