/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.img.ImgUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class GraphicsUtil {
    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g = image.createGraphics();
        g.setColor(color);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        return g;
    }

    public static int getMinY(Graphics g) {
        FontMetrics metrics = null;
        try {
            metrics = g.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int minY = null != metrics ? metrics.getAscent() - metrics.getLeading() - metrics.getDescent() : -1;
        return minY;
    }

    public static Graphics drawStringColourful(Graphics g, String str, Font font, int width, int height) {
        return GraphicsUtil.drawString(g, str, font, null, width, height);
    }

    public static Graphics drawString(Graphics g, String str, Font font, Color color, int width, int height) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(font);
        int minY = GraphicsUtil.getMinY(g);
        if (minY < 0) {
            minY = height - 4;
        }
        if (null != color) {
            g.setColor(color);
        }
        int len = str.length();
        int charWidth = width / len;
        for (int i = 0; i < len; ++i) {
            if (null == color) {
                g.setColor(ImgUtil.randomColor());
            }
            g.drawString(String.valueOf(str.charAt(i)), i * charWidth, minY);
        }
        return g;
    }
}

