/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.JschUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Vector;

public class Sftp
implements Closeable {
    private Session session;
    private ChannelSftp channel;

    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this.session = JschUtil.getSession(sshHost, sshPort, sshUser, sshPass);
        this.channel = JschUtil.openSftp(this.session);
    }

    public Sftp(Session session) {
        this.session = session;
        this.channel = JschUtil.openSftp(session);
    }

    public Sftp(ChannelSftp channel) {
        this.channel = channel;
    }

    public ChannelSftp getChannel() {
        return this.channel;
    }

    public String pwd() {
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    public boolean cd(String directory) {
        if (StrUtil.isBlank(directory)) {
            return false;
        }
        try {
            this.channel.cd(directory.replaceAll("\\\\", "/"));
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    public void mkDirs(String dir) {
        String[] dirs = dir.split("[\\\\/]");
        try {
            String now = this.channel.pwd();
            this.channel.cd("/");
            for (int i = 0; i < dirs.length; ++i) {
                boolean dirExists;
                if (!StrUtil.isNotEmpty(dirs[i]) || (dirExists = this.cd(dirs[i]))) continue;
                this.channel.mkdir(dirs[i]);
                this.channel.cd(dirs[i]);
            }
            this.channel.cd(now);
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    public Sftp delFile(String filePath) {
        try {
            this.channel.rm(filePath);
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return this;
    }

    public boolean delDir(String dirPath) {
        if (!this.cd(dirPath)) {
            return false;
        }
        Vector list = null;
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        for (ChannelSftp.LsEntry entry : list) {
            String fileName = entry.getFilename();
            if (fileName.equals(".") || fileName.equals("..")) continue;
            if (entry.getAttrs().isDir()) {
                this.delDir(fileName);
                continue;
            }
            this.delFile(fileName);
        }
        if (!this.cd("..")) {
            return false;
        }
        try {
            this.channel.rmdir(dirPath);
            return true;
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    public Sftp put(String srcFilePath, String destPath) {
        return this.put(srcFilePath, destPath, Mode.OVERWRITE);
    }

    public Sftp put(String srcFilePath, String destPath, Mode mode) {
        try {
            this.channel.put(srcFilePath, destPath, mode.ordinal());
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return this;
    }

    public Sftp get(String src, String dest) {
        try {
            this.channel.get(src, dest);
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        JschUtil.close((Channel)this.channel);
        JschUtil.close(this.session);
    }

    public static enum Mode {
        OVERWRITE,
        RESUME,
        APPEND;

    }
}

