/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.ds.GlobalDSFactory;
import cn.hutool.db.ds.c3p0.C3p0DSFactory;
import cn.hutool.db.ds.dbcp.DbcpDSFactory;
import cn.hutool.db.ds.druid.DruidDSFactory;
import cn.hutool.db.ds.hikari.HikariDSFactory;
import cn.hutool.db.ds.pooled.PooledDSFactory;
import cn.hutool.db.ds.tomcat.TomcatDSFactory;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.hutool.setting.Setting;
import javax.sql.DataSource;

public abstract class DSFactory {
    private static final Log log = LogFactory.get();
    protected static final String DEFAULT_DB_SETTING_PATH = "config/db.setting";
    protected static final String DEFAULT_DB_SETTING_PATH2 = "db.setting";
    public static final String[] KEY_ALIAS_URL = new String[]{"url", "jdbcUrl"};
    public static final String[] KEY_ALIAS_USER = new String[]{"user", "username"};
    public static final String[] KEY_ALIAS_PASSWORD = new String[]{"password", "pass"};
    public static final String[] KEY_ALIAS_DRIVER = new String[]{"driver", "driverClassName"};
    protected String dataSourceName;
    protected Setting setting;

    public DSFactory(String dataSourceName, Class<? extends DataSource> dataSourceClass, Setting setting) {
        this.dataSourceName = dataSourceName;
        if (null == setting) {
            try {
                setting = new Setting(DEFAULT_DB_SETTING_PATH, true);
            }
            catch (IORuntimeException e) {
                setting = new Setting(DEFAULT_DB_SETTING_PATH2, true);
            }
        }
        this.setting = setting;
        if (null != this.setting) {
            boolean isShowSql = Convert.toBool(this.setting.remove("showSql"), false);
            boolean isFormatSql = Convert.toBool(this.setting.remove("formatSql"), false);
            boolean isShowParams = Convert.toBool(this.setting.remove("showParams"), false);
            DbUtil.setShowSqlGlobal(isShowSql, isFormatSql, isShowParams);
        }
    }

    public Setting getSetting() {
        return this.setting;
    }

    public DataSource getDataSource() {
        return this.getDataSource("");
    }

    public abstract DataSource getDataSource(String var1);

    public void close() {
        this.close("");
    }

    public abstract void close(String var1);

    public abstract void destroy();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataSourceName == null ? 0 : this.dataSourceName.hashCode());
        result = 31 * result + (this.setting == null ? 0 : this.setting.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DSFactory other = (DSFactory)obj;
        if (this.dataSourceName == null ? other.dataSourceName != null : !this.dataSourceName.equals(other.dataSourceName)) {
            return false;
        }
        return !(this.setting == null ? other.setting != null : !this.setting.equals(other.setting));
    }

    public static DataSource get() {
        return DSFactory.get(null);
    }

    public static DataSource get(String group) {
        return GlobalDSFactory.get().getDataSource(group);
    }

    @Deprecated
    public static DSFactory getCurrentDSFactory(Setting setting) {
        return DSFactory.create(setting);
    }

    public static DSFactory setCurrentDSFactory(DSFactory dsFactory) {
        return GlobalDSFactory.set(dsFactory);
    }

    public static DSFactory create(Setting setting) {
        DSFactory dsFactory;
        try {
            dsFactory = new HikariDSFactory(setting);
        }
        catch (NoClassDefFoundError e1) {
            try {
                dsFactory = new DruidDSFactory(setting);
            }
            catch (NoClassDefFoundError e2) {
                try {
                    dsFactory = new TomcatDSFactory(setting);
                }
                catch (NoClassDefFoundError e3) {
                    try {
                        dsFactory = new DbcpDSFactory(setting);
                    }
                    catch (NoClassDefFoundError e4) {
                        try {
                            dsFactory = new C3p0DSFactory(setting);
                        }
                        catch (NoClassDefFoundError e5) {
                            dsFactory = new PooledDSFactory(setting);
                        }
                    }
                }
            }
        }
        log.debug("Use [{}] DataSource As Default", dsFactory.dataSourceName);
        return dsFactory;
    }
}

