/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class MapConverter
extends AbstractConverter<Map<?, ?>> {
    private final Type mapType;
    private final Type keyType;
    private final Type valueType;

    public MapConverter(Type mapType) {
        this(mapType, TypeUtil.getTypeArgument(mapType, 0), TypeUtil.getTypeArgument(mapType, 1));
    }

    public MapConverter(Type mapType, Type keyType, Type valueType) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Map<?, ?> convertInternal(Object value) {
        Map<Object, Object> map = null;
        if (value instanceof Map) {
            map = MapUtil.createMap(TypeUtil.getClass(this.mapType));
            this.convertMapToMap((Map)value, map);
        } else if (BeanUtil.isBean(value.getClass())) {
            map = BeanUtil.beanToMap(value);
        } else {
            throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport toMap value type: {}", value.getClass().getName()));
        }
        return map;
    }

    private void convertMapToMap(Map<?, ?> srcMap, Map<Object, Object> targetMap) {
        ConverterRegistry convert = ConverterRegistry.getInstance();
        for (Map.Entry<?, ?> entry : srcMap.entrySet()) {
            Object key = null == this.keyType ? entry.getKey() : convert.convert(this.keyType, entry.getKey());
            Object value = null == this.valueType ? entry.getValue() : convert.convert(this.keyType, entry.getValue());
            targetMap.put(key, value);
        }
    }

    @Override
    public Class<Map<?, ?>> getTargetType() {
        return TypeUtil.getClass(this.mapType);
    }
}

