/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.RedisFuture;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

class PipelinedRedisFuture<V>
extends CompletableFuture<V>
implements RedisFuture<V> {
    private CountDownLatch latch = new CountDownLatch(1);

    public PipelinedRedisFuture(Map<?, ? extends RedisFuture<?>> executions, Function<PipelinedRedisFuture<V>, V> converter) {
        ((CompletableFuture)CompletableFuture.allOf(executions.values().toArray(new CompletableFuture[executions.size()])).thenRun(() -> this.complete((V)converter.apply(this)))).exceptionally((T throwable) -> {
            this.completeExceptionally((Throwable)throwable);
            return null;
        });
    }

    @Override
    public boolean complete(V value) {
        boolean result = super.complete(value);
        this.latch.countDown();
        return result;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean value = super.completeExceptionally(ex);
        this.latch.countDown();
        return value;
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }
}

