/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.lambdaworks.redis.api.async.RedisAsyncCommands;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.DynamicNodeSelection;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;

class DynamicAsyncNodeSelection<CMD, K, V>
extends DynamicNodeSelection<RedisAsyncCommands<K, V>, CMD, K, V> {
    public DynamicAsyncNodeSelection(StatefulRedisClusterConnection<K, V> globalConnection, Predicate<RedisClusterNode> selector, ClusterConnectionProvider.Intent intent) {
        super(globalConnection, selector, intent);
    }

    public Iterator<RedisAsyncCommands<K, V>> iterator() {
        ImmutableList list = ImmutableList.copyOf(this.nodes());
        return list.stream().map(node -> this.getConnection((RedisClusterNode)node).async()).iterator();
    }

    @Override
    public RedisAsyncCommands<K, V> commands(int index) {
        return this.statefulMap().get(this.nodes().get(index)).async();
    }

    @Override
    public Map<RedisClusterNode, RedisAsyncCommands<K, V>> asMap() {
        ImmutableList list = ImmutableList.copyOf(this.nodes());
        HashMap map = Maps.newHashMap();
        list.forEach(key -> map.put(key, this.getConnection((RedisClusterNode)key).async()));
        return map;
    }

    @Override
    public CMD commands() {
        return null;
    }
}

