/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.lambdaworks.redis.ConnectionPoint;
import com.lambdaworks.redis.EpollProvider;
import com.lambdaworks.redis.LettuceStrings;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RedisURI
implements Serializable,
ConnectionPoint {
    public static final String URI_SCHEME_REDIS_SENTINEL = "redis-sentinel";
    public static final String URI_SCHEME_REDIS = "redis";
    public static final String URI_SCHEME_REDIS_SECURE = "rediss";
    public static final String URI_SCHEME_REDIS_SOCKET = "redis-socket";
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    public static final int DEFAULT_REDIS_PORT = 6379;
    private String host;
    private String socket;
    private String sentinelMasterId;
    private int port;
    private int database;
    private char[] password;
    private boolean ssl = false;
    private boolean verifyPeer = true;
    private boolean startTls = false;
    private long timeout = 60L;
    private TimeUnit unit = TimeUnit.SECONDS;
    private final List<RedisURI> sentinels = new ArrayList<RedisURI>();
    private transient SocketAddress resolvedAddress;

    public RedisURI() {
    }

    public RedisURI(String host, int port, long timeout, TimeUnit unit) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.unit = unit;
    }

    public static RedisURI create(String uri) {
        return RedisURI.create(URI.create(uri));
    }

    public static RedisURI create(URI uri) {
        String pathSuffix;
        Builder builder = uri.getScheme().equals(URI_SCHEME_REDIS_SENTINEL) ? RedisURI.configureSentinel(uri) : RedisURI.configureStandalone(uri);
        String userInfo = uri.getUserInfo();
        if (LettuceStrings.isEmpty(userInfo) && LettuceStrings.isNotEmpty(uri.getAuthority()) && uri.getAuthority().indexOf(64) > 0) {
            userInfo = uri.getAuthority().substring(0, uri.getAuthority().indexOf(64));
        }
        if (LettuceStrings.isNotEmpty(userInfo)) {
            String password = userInfo;
            if (password.startsWith(":")) {
                password = password.substring(1);
            } else {
                int index = password.indexOf(58);
                if (index > 0) {
                    password = password.substring(index + 1);
                }
            }
            if (password != null && !password.equals("")) {
                builder.withPassword(password);
            }
        }
        if (LettuceStrings.isNotEmpty(uri.getPath()) && builder.redisURI.getSocket() == null && LettuceStrings.isNotEmpty(pathSuffix = uri.getPath().substring(1))) {
            builder.withDatabase(Integer.parseInt(pathSuffix));
        }
        return builder.build();
    }

    private static Builder configureStandalone(URI uri) {
        ImmutableSet allowedSchemes = ImmutableSet.of((Object)URI_SCHEME_REDIS, (Object)URI_SCHEME_REDIS_SECURE, (Object)URI_SCHEME_REDIS_SOCKET);
        if (!allowedSchemes.contains(uri.getScheme())) {
            throw new IllegalArgumentException("Scheme " + uri.getScheme() + " not supported");
        }
        Builder builder = URI_SCHEME_REDIS_SOCKET.equals(uri.getScheme()) ? Builder.socket(uri.getPath()) : (uri.getPort() > 0 ? Builder.redis(uri.getHost(), uri.getPort()) : Builder.redis(uri.getHost()));
        if (URI_SCHEME_REDIS_SECURE.equals(uri.getScheme())) {
            builder.withSsl(true);
        }
        return builder;
    }

    private static Builder configureSentinel(URI uri) {
        Preconditions.checkArgument((boolean)LettuceStrings.isNotEmpty(uri.getFragment()), (Object)"URI Fragment must contain the sentinelMasterId");
        String masterId = uri.getFragment();
        Builder builder = null;
        if (LettuceStrings.isNotEmpty(uri.getHost())) {
            builder = uri.getPort() != -1 ? Builder.sentinel(uri.getHost(), uri.getPort(), masterId) : Builder.sentinel(uri.getHost(), masterId);
        }
        if (builder == null && LettuceStrings.isNotEmpty(uri.getAuthority())) {
            String[] hosts;
            String authority = uri.getAuthority();
            if (authority.indexOf(64) > -1) {
                authority = authority.substring(authority.indexOf(64) + 1);
            }
            for (String host : hosts = authority.split("\\,")) {
                HostAndPort hostAndPort = HostAndPort.fromString((String)host);
                if (builder == null) {
                    if (hostAndPort.hasPort()) {
                        builder = Builder.sentinel(hostAndPort.getHostText(), hostAndPort.getPort(), masterId);
                        continue;
                    }
                    builder = Builder.sentinel(hostAndPort.getHostText(), masterId);
                    continue;
                }
                if (hostAndPort.hasPort()) {
                    builder.withSentinel(hostAndPort.getHostText(), hostAndPort.getPort());
                    continue;
                }
                builder.withSentinel(hostAndPort.getHostText());
            }
        }
        Preconditions.checkArgument((builder != null ? 1 : 0) != 0, (Object)"Invalid URI, cannot get host part");
        return builder;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSentinelMasterId() {
        return this.sentinelMasterId;
    }

    public void setSentinelMasterId(String sentinelMasterId) {
        this.sentinelMasterId = sentinelMasterId;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getSocket() {
        return this.socket;
    }

    public void setSocket(String socket) {
        this.socket = socket;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isVerifyPeer() {
        return this.verifyPeer;
    }

    public void setVerifyPeer(boolean verifyPeer) {
        this.verifyPeer = verifyPeer;
    }

    public boolean isStartTls() {
        return this.startTls;
    }

    public void setStartTls(boolean startTls) {
        this.startTls = startTls;
    }

    public List<RedisURI> getSentinels() {
        return this.sentinels;
    }

    public SocketAddress getResolvedAddress() {
        if (this.resolvedAddress == null) {
            this.resolveAddress();
        }
        return this.resolvedAddress;
    }

    private void resolveAddress() {
        this.resolvedAddress = this.getSocket() != null ? EpollProvider.newSocketAddress(this.getSocket()) : new InetSocketAddress(this.host, this.port);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        if (this.host != null) {
            sb.append("host='").append(this.host).append('\'');
            sb.append(", port=").append(this.port);
        }
        if (this.socket != null) {
            sb.append("socket='").append(this.socket).append('\'');
        }
        if (this.sentinelMasterId != null) {
            sb.append("sentinels=").append(this.getSentinels());
            sb.append(", sentinelMasterId=").append(this.sentinelMasterId);
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisURI)) {
            return false;
        }
        RedisURI redisURI = (RedisURI)o;
        if (this.port != redisURI.port) {
            return false;
        }
        if (this.database != redisURI.database) {
            return false;
        }
        if (this.host != null ? !this.host.equals(redisURI.host) : redisURI.host != null) {
            return false;
        }
        if (this.socket != null ? !this.socket.equals(redisURI.socket) : redisURI.socket != null) {
            return false;
        }
        if (this.sentinelMasterId != null ? !this.sentinelMasterId.equals(redisURI.sentinelMasterId) : redisURI.sentinelMasterId != null) {
            return false;
        }
        return !(this.sentinels == null ? redisURI.sentinels != null : !this.sentinels.equals(redisURI.sentinels));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.socket != null ? this.socket.hashCode() : 0);
        result = 31 * result + (this.sentinelMasterId != null ? this.sentinelMasterId.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + this.database;
        result = 31 * result + (this.sentinels != null ? this.sentinels.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private final RedisURI redisURI = new RedisURI();

        public static Builder socket(String socket) {
            Preconditions.checkNotNull((Object)socket, (Object)"Socket must not be null");
            Builder builder = new Builder();
            builder.redisURI.setSocket(socket);
            return builder;
        }

        public static Builder redis(String host) {
            return Builder.redis(host, 6379);
        }

        public static Builder redis(String host, int port) {
            Preconditions.checkNotNull((Object)host, (Object)"Host must not be null");
            Builder builder = new Builder();
            builder.redisURI.setHost(host);
            builder.redisURI.setPort(port);
            return builder;
        }

        public static Builder sentinel(String host) {
            return Builder.sentinel(host, 26379, null);
        }

        public static Builder sentinel(String host, int port) {
            return Builder.sentinel(host, port, null);
        }

        public static Builder sentinel(String host, String masterId) {
            return Builder.sentinel(host, 26379, masterId);
        }

        public static Builder sentinel(String host, int port, String masterId) {
            Preconditions.checkNotNull((Object)host, (Object)"Host must not be null");
            Builder builder = new Builder();
            builder.redisURI.setSentinelMasterId(masterId);
            builder.redisURI.sentinels.add(new RedisURI(host, port, 1L, TimeUnit.SECONDS));
            return builder;
        }

        public Builder withSentinel(String host) {
            return this.withSentinel(host, 26379);
        }

        public Builder withSentinel(String host, int port) {
            Preconditions.checkState((this.redisURI.host == null ? 1 : 0) != 0, (Object)"Cannot use with Redis mode.");
            Preconditions.checkNotNull((Object)host, (Object)"Host must not be null");
            this.redisURI.sentinels.add(new RedisURI(host, port, 1L, TimeUnit.SECONDS));
            return this;
        }

        public Builder withPort(int port) {
            Preconditions.checkState((this.redisURI.host != null ? 1 : 0) != 0, (Object)"Host is null. Cannot use in Sentinel mode.");
            this.redisURI.setPort(port);
            return this;
        }

        public Builder withSsl(boolean ssl) {
            Preconditions.checkState((this.redisURI.host != null ? 1 : 0) != 0, (Object)"Host is null. Cannot use in Sentinel mode.");
            this.redisURI.setSsl(ssl);
            return this;
        }

        public Builder withStartTls(boolean startTls) {
            Preconditions.checkState((this.redisURI.host != null ? 1 : 0) != 0, (Object)"Host is null. Cannot use in Sentinel mode.");
            this.redisURI.setStartTls(startTls);
            return this;
        }

        public Builder withVerifyPeer(boolean verifyPeer) {
            Preconditions.checkState((this.redisURI.host != null ? 1 : 0) != 0, (Object)"Host is null. Cannot use in Sentinel mode.");
            this.redisURI.setVerifyPeer(verifyPeer);
            return this;
        }

        public Builder withDatabase(int database) {
            this.redisURI.setDatabase(database);
            return this;
        }

        public Builder withPassword(String password) {
            Preconditions.checkNotNull((Object)password, (Object)"Password must not be null");
            this.redisURI.setPassword(password);
            return this;
        }

        public Builder withTimeout(long timeout, TimeUnit unit) {
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"TimeUnit must not be null");
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"Timeout must be greater or equal 0");
            this.redisURI.setTimeout(timeout);
            this.redisURI.setUnit(unit);
            return this;
        }

        public RedisURI build() {
            return this.redisURI;
        }
    }
}

