/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util.threadpool;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.apache.axis2.AxisFault;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPool
implements ThreadFactory {
    private static final Log log = LogFactory.getLog((Class)ThreadPool.class);
    protected static long SLEEP_INTERVAL = 1000L;
    private static boolean shutDown;
    protected ThreadPoolExecutor executor;

    public ThreadPool() {
        this.setExecutor(this.createDefaultExecutor("Axis2 Task", 5, true));
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public void execute(Runnable worker) {
        if (shutDown) {
            throw new RuntimeException(Messages.getMessage("threadpoolshutdown"));
        }
        this.executor.execute(worker);
    }

    public void forceShutDown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"forceShutDown called. Thread workers will be stopped");
        }
        this.executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeShutDown() throws AxisFault {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            shutDown = true;
        }
        this.executor.shutdown();
    }

    protected ThreadPoolExecutor createDefaultExecutor(final String name, final int priority, final boolean daemon) {
        ThreadPoolExecutor rc = new ThreadPoolExecutor(5, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), new edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, name);
                thread.setDaemon(daemon);
                thread.setPriority(priority);
                return thread;
            }
        });
        rc.allowCoreThreadTimeOut(true);
        return rc;
    }
}

