/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.mail.EmailReceiver;

public class EMailSender {
    private String host;
    private String password;
    private String smtpPort;
    private String user;

    public EMailSender(String user, String host, String smtpPort, String password) {
        this.user = user;
        this.host = host;
        this.smtpPort = smtpPort;
        this.password = password;
    }

    public static void main(String[] args) throws Exception {
        String user = "hemapani";
        String host = "127.0.0.1";
        String smtpPort = "25";
        String password = "hemapani";
        EMailSender sender = new EMailSender(user, host, smtpPort, password);
        sender.send("Testing mail sending", "hemapani@127.0.0.1", "Hellp, testing", "us-ascii");
        EmailReceiver receiver = new EmailReceiver(user, host, "110", password);
        receiver.connect();
        Message[] msgs = receiver.receive();
        if (msgs != null) {
            for (int i = 0; i < msgs.length; ++i) {
                MimeMessage msg = (MimeMessage)msgs[i];
                if (msg != null) {
                    // empty if block
                }
                msg.setFlag(Flags.Flag.DELETED, true);
            }
        }
        receiver.disconnect();
    }

    public void send(String subject, String targetEmail, String message, String charSet) throws AxisFault {
        try {
            final PasswordAuthentication authentication = new PasswordAuthentication(this.user, this.password);
            Properties props = new Properties();
            props.put("mail.user", this.user);
            props.put("mail.host", this.host);
            props.put("mail.store.protocol", "pop3");
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.port", this.smtpPort);
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return authentication;
                }
            });
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.user));
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(targetEmail));
            msg.setSubject(subject);
            if (charSet == null) {
                charSet = "us-ascii";
            }
            msg.addHeaderLine("Content-Type: text/xml; charset=" + charSet);
            msg.setText(message);
            msg.setHeader("Content-Transfer-Encoding", "7bit");
            Transport.send((Message)msg);
        }
        catch (AddressException e) {
            throw new AxisFault(e);
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }
}

