/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axis2.transport.http.server.HttpRequestHandler;
import org.apache.axis2.transport.http.server.HttpService;
import org.apache.axis2.transport.http.server.SimpleHttpServerConnection;
import org.apache.axis2.transport.http.server.SimpleRequest;
import org.apache.axis2.transport.http.server.SimpleResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;

public class HttpServiceHandler
implements HttpRequestHandler {
    private HttpService service = null;

    public HttpServiceHandler(HttpService service) {
        if (service == null) {
            throw new IllegalArgumentException("Service may not be null");
        }
        this.service = service;
    }

    public boolean processRequest(SimpleHttpServerConnection conn, SimpleRequest request) throws IOException {
        if (conn == null) {
            throw new IllegalArgumentException("Connection may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("Request may not be null");
        }
        SimpleResponse response = new SimpleResponse();
        this.service.process(request, response);
        request.getBodyBytes();
        if (!response.containsHeader("Content-Type")) {
            response.addHeader(new Header("Content-Type", "text/plain"));
        }
        if (!response.containsHeader("Content-Length") && !response.containsHeader("Transfer-Encoding")) {
            InputStream content = response.getBody();
            if (content != null) {
                long len = response.getContentLength();
                if (len < 0L) {
                    if (response.getHttpVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                        throw new IOException("Chunked encoding not supported for HTTP version " + response.getHttpVersion());
                    }
                    Header header = new Header("Transfer-Encoding", "chunked");
                    response.addHeader(header);
                } else {
                    Header header = new Header("Content-Length", Long.toString(len));
                    response.setHeader(header);
                }
            } else {
                Header header = new Header("Content-Length", "0");
                response.addHeader(header);
            }
        }
        if (!response.containsHeader("Connection")) {
            Header connheader = request.getFirstHeader("Connection");
            if (connheader != null) {
                if (connheader.getValue().equalsIgnoreCase("keep-alive")) {
                    Header header = new Header("Connection", "keep-alive");
                    response.addHeader(header);
                    conn.setKeepAlive(true);
                }
                if (connheader.getValue().equalsIgnoreCase("close")) {
                    Header header = new Header("Connection", "close");
                    response.addHeader(header);
                    conn.setKeepAlive(false);
                }
            } else if (response.getHttpVersion().greaterEquals(HttpVersion.HTTP_1_1)) {
                conn.setKeepAlive(true);
            } else {
                conn.setKeepAlive(false);
            }
        }
        if ("HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            response.setBody(null);
        }
        conn.writeResponse(response);
        return true;
    }
}

