/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.AbstractAgent;
import org.apache.ws.commons.schema.XmlSchema;

public class ListingAgent
extends AbstractAgent {
    private static final String LIST_MULTIPLE_SERVICE_JSP_NAME = "listServices.jsp";
    private static final String LIST_SINGLE_SERVICE_JSP_NAME = "listSingleService.jsp";
    private static final String LIST_FAULTY_SERVICES_JSP_NAME = "listFaultyService.jsp";
    public static final String RUNNING_PORT = "RUNNING_PORT";

    public ListingAgent(ConfigurationContext aConfigContext) {
        super(aConfigContext);
    }

    private void addTransportListner(String scheam, int port) {
        try {
            TransportInDescription trsIn = this.configContext.getAxisConfiguration().getTransportIn(new QName(scheam));
            if (trsIn == null) {
                trsIn = new TransportInDescription(new QName(scheam));
                trsIn.setReceiver(new HTTPSTListener(port, scheam));
                this.configContext.getListenerManager().addListener(trsIn, true);
            }
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String filePart = httpServletRequest.getRequestURL().toString();
        int ipindex = filePart.indexOf("//");
        String ip = null;
        if (ipindex >= 0) {
            ip = filePart.substring(ipindex + 2, filePart.length());
            int seperatorIndex = ip.indexOf(":");
            int slashIndex = ip.indexOf("/");
            String portstr = ip.substring(seperatorIndex + 1, slashIndex);
            try {
                this.addTransportListner(httpServletRequest.getScheme(), Integer.parseInt(portstr));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (httpServletRequest.getParameter("wsdl") != null || httpServletRequest.getParameter("xsd") != null) {
            this.processListService(httpServletRequest, httpServletResponse);
        } else {
            super.handle(httpServletRequest, httpServletResponse);
        }
    }

    protected void processListFaultyServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String serviceName = req.getParameter("serviceName");
        if (serviceName != null) {
            AxisService service = this.configContext.getAxisConfiguration().getService(serviceName);
            req.getSession().setAttribute("singleservice", (Object)service);
        }
        this.renderView(LIST_FAULTY_SERVICES_JSP_NAME, req, res);
    }

    protected void processIndex(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.processListServices(httpServletRequest, httpServletResponse);
    }

    protected void processListService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String filePart = req.getRequestURL().toString();
        String serviceName = filePart.substring(filePart.lastIndexOf("/") + 1, filePart.length());
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        String wsdl = req.getParameter("wsdl");
        String xsd = req.getParameter("xsd");
        if (services != null && !services.isEmpty()) {
            Object serviceObj = services.get(serviceName);
            if (serviceObj != null) {
                if (wsdl != null) {
                    ServletOutputStream out = res.getOutputStream();
                    res.setContentType("text/xml");
                    int ipindex = filePart.indexOf("//");
                    String ip = null;
                    if (ipindex >= 0) {
                        ip = filePart.substring(ipindex + 2, filePart.length());
                        int seperatorIndex = ip.indexOf(":");
                        int slashIndex = ip.indexOf("/");
                        String port = ip.substring(seperatorIndex + 1, slashIndex);
                        if ("http".equals(req.getScheme())) {
                            this.configContext.setProperty(RUNNING_PORT, port);
                        }
                        if (seperatorIndex > 0) {
                            ip = ip.substring(0, seperatorIndex);
                        }
                    }
                    ((AxisService)serviceObj).printWSDL((OutputStream)out, ip);
                    out.flush();
                    out.close();
                    return;
                }
                if (xsd != null) {
                    ServletOutputStream out = res.getOutputStream();
                    res.setContentType("text/xml");
                    AxisService axisService = (AxisService)serviceObj;
                    axisService.populateSchemaMappings();
                    Hashtable schemaMappingtable = axisService.getSchemaMappingTable();
                    ArrayList scheams = axisService.getSchema();
                    if (!"".equals(xsd)) {
                        XmlSchema scheam = (XmlSchema)schemaMappingtable.get(xsd);
                        if (scheam != null) {
                            scheam.write((OutputStream)out);
                            out.flush();
                            out.close();
                        } else {
                            res.sendError(404);
                        }
                    } else if (scheams.size() > 1) {
                        res.sendRedirect("");
                    } else {
                        XmlSchema scheam = axisService.getSchema(0);
                        if (scheam != null) {
                            scheam.write((OutputStream)out);
                            out.flush();
                            out.close();
                        }
                    }
                    return;
                }
                req.getSession().setAttribute("singleservice", serviceObj);
            } else {
                req.getSession().setAttribute("singleservice", null);
            }
        }
        this.renderView(LIST_SINGLE_SERVICE_JSP_NAME, req, res);
    }

    protected void processListServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        req.getSession().setAttribute("servicemap", (Object)services);
        req.getSession().setAttribute("errprservicemap", (Object)this.configContext.getAxisConfiguration().getFaultyServices());
        this.renderView(LIST_MULTIPLE_SERVICE_JSP_NAME, req, res);
    }

    private class HTTPSTListener
    implements TransportListener {
        private int port;
        private String scheam;

        public HTTPSTListener(int port, String scheam) {
            this.port = port;
            this.scheam = scheam;
        }

        public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
        }

        public void start() throws AxisFault {
        }

        public void stop() throws AxisFault {
        }

        public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
            return new EndpointReference(this.scheam + "://" + ip + ":" + this.port + "/axis2/services/" + serviceName);
        }
    }
}

