/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.util.Utils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHTTPSender {
    protected static final String ANONYMOUS = "anonymous";
    protected static final String PROXY_HOST_NAME = "proxy_host";
    protected static final String PROXY_PORT = "proxy_port";
    protected boolean chunked = false;
    protected String httpVersion = "HTTP/1.1";
    private static final Log log = LogFactory.getLog((Class)AbstractHTTPSender.class);
    int soTimeout = 60000;
    protected TransportOutDescription proxyOutSetting = null;
    protected OMOutputFormat format = new OMOutputFormat();
    int connectionTimeout = 60000;

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public void setHttpVersion(String version) throws AxisFault {
        if (version != null) {
            if ("HTTP/1.1".equals(version)) {
                this.httpVersion = "HTTP/1.1";
            } else if ("HTTP/1.0".equals(version)) {
                this.httpVersion = "HTTP/1.0";
                this.chunked = false;
            } else {
                throw new AxisFault("Parameter PROTOCOL Can have values only HTTP/1.0 or HTTP/1.1");
            }
        }
    }

    protected void configProxyAuthentication(HttpClient client, TransportOutDescription proxySetting, HostConfiguration config, MessageContext msgCtx) throws AxisFault {
        HttpTransportProperties.ProxyProperties proxyProperties;
        Parameter proxyParam = proxySetting.getParameter("PROXY");
        Object proxyCred = null;
        String proxyHostName = null;
        int proxyPort = -1;
        if (proxyParam != null) {
            String value = (String)proxyParam.getValue();
            String[] split = value.split(":");
            String usrName = split[0];
            String domain = split[1];
            String passwd = split[2];
            OMElement proxyParamElement = proxyParam.getParameterElement();
            Iterator ite = proxyParamElement.getAllAttributes();
            while (ite.hasNext()) {
                OMAttribute att = (OMAttribute)ite.next();
                if (att.getLocalName().equalsIgnoreCase(PROXY_HOST_NAME)) {
                    proxyHostName = att.getAttributeValue();
                }
                if (!att.getLocalName().equalsIgnoreCase(PROXY_PORT)) continue;
                proxyPort = Integer.parseInt(att.getAttributeValue());
            }
            proxyCred = domain.equals("") || domain.equals(ANONYMOUS) ? (usrName.equals(ANONYMOUS) && passwd.equals(ANONYMOUS) ? new UsernamePasswordCredentials("", "") : new UsernamePasswordCredentials(usrName, passwd)) : new NTCredentials(usrName, passwd, proxyHostName, domain);
        }
        if ((proxyProperties = (HttpTransportProperties.ProxyProperties)msgCtx.getProperty("PROXY")) != null) {
            if (proxyProperties.getProxyPort() != -1) {
                proxyPort = proxyProperties.getProxyPort();
            }
            if ((proxyHostName = proxyProperties.getProxyHostName()) == null || proxyHostName.length() == 0) {
                throw new AxisFault("Proxy Name is not valid");
            }
            if (proxyProperties.getUserName().equals(ANONYMOUS) || proxyProperties.getPassWord().equals(ANONYMOUS)) {
                proxyCred = new UsernamePasswordCredentials("", "");
            }
            if (!proxyProperties.getUserName().equals(ANONYMOUS) && !proxyProperties.getPassWord().equals(ANONYMOUS)) {
                proxyCred = new UsernamePasswordCredentials(proxyProperties.getUserName().trim(), proxyProperties.getPassWord().trim());
            }
            if (!(proxyProperties.getDomain().equals(ANONYMOUS) || proxyProperties.getUserName().equals(ANONYMOUS) || proxyProperties.getPassWord().equals(ANONYMOUS) || proxyProperties.getDomain().equals(ANONYMOUS) || proxyHostName == null)) {
                proxyCred = new NTCredentials(proxyProperties.getUserName().trim(), proxyProperties.getPassWord().trim(), proxyHostName, proxyProperties.getDomain().trim());
            }
        }
        client.getState().setProxyCredentials(AuthScope.ANY, proxyCred);
        config.setProxy(proxyHostName, proxyPort);
    }

    protected void obtainHTTPHeaderInformation(HttpMethodBase method, MessageContext msgContext) {
        Header cookieHeader;
        Header header = method.getResponseHeader("Content-Type");
        if (header != null) {
            HeaderElement[] headers = header.getElements();
            for (int i = 0; i < headers.length; ++i) {
                NameValuePair charsetEnc = headers[i].getParameterByName(HTTPConstants.CHAR_SET_ENCODING);
                OperationContext opContext = msgContext.getOperationContext();
                String name = headers[i].getName();
                if (name.equalsIgnoreCase("multipart/related")) {
                    if (opContext == null) continue;
                    opContext.setProperty("MTOM_RECEIVED", header.getValue());
                    continue;
                }
                if (charsetEnc == null || opContext == null) continue;
                opContext.setProperty("CHARACTER_SET_ENCODING", charsetEnc.getValue());
            }
        }
        if ((cookieHeader = method.getResponseHeader("Set-Cookie")) == null) {
            cookieHeader = method.getResponseHeader("Set-Cookie2");
        }
        if (cookieHeader != null) {
            msgContext.getServiceContext().setProperty("Cookie", cookieHeader.getValue());
        }
    }

    protected void processResponse(HttpMethodBase httpMethod, MessageContext msgContext) throws IOException {
        this.obtainHTTPHeaderInformation(httpMethod, msgContext);
        InputStream in = httpMethod.getResponseBodyAsStream();
        Header contentEncoding = httpMethod.getResponseHeader("Content-Encoding");
        if (contentEncoding != null) {
            if (contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                in = new GZIPInputStream(in);
            } else {
                throw new AxisFault("HTTP :unsupported content-encoding of '" + contentEncoding.getValue() + "' found");
            }
        }
        if (in == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "InputStream"));
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("TRANSPORT_IN", in);
        }
    }

    public abstract void send(MessageContext var1, OMElement var2, URL var3, String var4) throws MalformedURLException, AxisFault, IOException;

    protected HostConfiguration getHostConfiguration(HttpClient client, MessageContext msgCtx, URL targetURL) throws AxisFault {
        boolean isHostProxy = this.isProxyListed(msgCtx);
        int port = targetURL.getPort();
        if (port == -1) {
            port = 80;
        }
        HostConfiguration config = new HostConfiguration();
        if (!isHostProxy) {
            config.setHost(targetURL.getHost(), port, targetURL.getProtocol());
        } else {
            this.configProxyAuthentication(client, this.proxyOutSetting, config, msgCtx);
        }
        return config;
    }

    protected void getTimeoutValues(MessageContext msgContext) {
        try {
            Integer tempSoTimeoutProperty = (Integer)msgContext.getProperty("SO_TIMEOUT");
            Integer tempConnTimeoutProperty = (Integer)msgContext.getProperty("CONNECTION_TIMEOUT");
            if (tempSoTimeoutProperty != null) {
                this.soTimeout = tempSoTimeoutProperty;
            }
            if (tempConnTimeoutProperty != null) {
                this.connectionTimeout = tempConnTimeoutProperty;
            }
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"Invalid timeout value format: not a number", (Throwable)nfe);
        }
    }

    private boolean isProxyListed(MessageContext msgCtx) throws AxisFault {
        HttpTransportProperties.ProxyProperties proxyProperties;
        boolean returnValue = false;
        Parameter par = null;
        this.proxyOutSetting = msgCtx.getConfigurationContext().getAxisConfiguration().getTransportOut(new QName("http"));
        if (this.proxyOutSetting != null) {
            par = this.proxyOutSetting.getParameter("PROXY");
        }
        OMElement hostElement = null;
        if (par != null) {
            hostElement = par.getParameterElement();
        }
        if (hostElement != null) {
            Iterator ite = hostElement.getAllAttributes();
            while (ite.hasNext()) {
                OMAttribute attribute = (OMAttribute)ite.next();
                if (!attribute.getLocalName().equalsIgnoreCase(PROXY_HOST_NAME)) continue;
                returnValue = true;
            }
        }
        if ((proxyProperties = (HttpTransportProperties.ProxyProperties)msgCtx.getProperty("PROXY")) != null && proxyProperties.getProxyHostName() != null) {
            returnValue = true;
        }
        return returnValue;
    }

    public void setFormat(OMOutputFormat format) {
        this.format = format;
    }

    protected HttpClient getHttpClient(MessageContext msgContext) {
        HttpClient httpClient = null;
        Boolean reuse = (Boolean)msgContext.getOptions().getProperty("REUSE_HTTP_CLIENT");
        if (reuse != null && reuse.booleanValue()) {
            httpClient = (HttpClient)msgContext.getConfigurationContext().getProperty("CACHED_HTTP_CLIENT");
            if (httpClient == null) {
                MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                httpClient = new HttpClient((HttpConnectionManager)connectionManager);
                msgContext.getConfigurationContext().setProperty("CACHED_HTTP_CLIENT", httpClient);
            }
        } else {
            httpClient = new HttpClient();
        }
        this.getTimeoutValues(msgContext);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.soTimeout);
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout);
        return httpClient;
    }

    protected void executeMethod(HttpClient httpClient, MessageContext msgContext, URL url, HttpMethod method) throws IOException {
        HostConfiguration config = this.getHostConfiguration(httpClient, msgContext, url);
        msgContext.setProperty("HTTP_METHOD", method);
        if (Utils.isExplicitlyTrue(msgContext, "transport.http.acceptGzip")) {
            method.addRequestHeader("Accept-Encoding", "gzip");
        }
        if (Utils.isExplicitlyTrue(msgContext, "transport.http.gzipRequest")) {
            method.addRequestHeader("Content-Encoding", "gzip");
        }
        httpClient.executeMethod(config, method);
    }

    public class AxisRequestEntity
    implements RequestEntity {
        private boolean doingMTOM = false;
        private byte[] bytes;
        private String charSetEnc;
        private boolean chunked;
        private OMElement element;
        private MessageContext msgCtxt;
        private String soapActionString;

        public AxisRequestEntity(OMElement element, boolean chunked, MessageContext msgCtxt, String charSetEncoding, String soapActionString) {
            this.element = element;
            this.chunked = chunked;
            this.msgCtxt = msgCtxt;
            this.doingMTOM = msgCtxt.isDoingMTOM();
            this.charSetEnc = charSetEncoding;
            this.soapActionString = soapActionString;
        }

        private void handleOMOutput(OutputStream out, boolean doingMTOM) throws XMLStreamException {
            AbstractHTTPSender.this.format.setDoOptimize(doingMTOM);
            this.element.serializeAndConsume(out, AbstractHTTPSender.this.format);
        }

        public byte[] writeBytes() throws AxisFault {
            try {
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                if (!this.doingMTOM) {
                    OMOutputFormat format2 = new OMOutputFormat();
                    format2.setCharSetEncoding(this.charSetEnc);
                    this.element.serializeAndConsume((OutputStream)bytesOut, format2);
                    return bytesOut.toByteArray();
                }
                AbstractHTTPSender.this.format.setCharSetEncoding(this.charSetEnc);
                AbstractHTTPSender.this.format.setDoOptimize(true);
                this.element.serializeAndConsume((OutputStream)bytesOut, AbstractHTTPSender.this.format);
                return bytesOut.toByteArray();
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
            catch (FactoryConfigurationError e) {
                throw new AxisFault(e);
            }
        }

        public void writeRequest(OutputStream out) throws IOException {
            try {
                if (this.chunked) {
                    this.handleOMOutput(out, this.doingMTOM);
                } else {
                    if (this.bytes == null) {
                        this.bytes = this.writeBytes();
                    }
                    out.write(this.bytes);
                }
                out.flush();
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
            catch (FactoryConfigurationError e) {
                throw new AxisFault(e);
            }
            catch (IOException e) {
                throw new AxisFault(e);
            }
        }

        public long getContentLength() {
            try {
                if (this.chunked) {
                    return -1L;
                }
                if (this.bytes == null) {
                    this.bytes = this.writeBytes();
                }
                return this.bytes.length;
            }
            catch (AxisFault e) {
                return -1L;
            }
        }

        public String getContentType() {
            String encoding = AbstractHTTPSender.this.format.getCharSetEncoding();
            String contentType = AbstractHTTPSender.this.format.getContentType();
            if (encoding != null) {
                contentType = contentType + "; charset=" + encoding;
            }
            if (!this.msgCtxt.isSOAP11() && this.soapActionString != null && !"".equals(this.soapActionString.trim())) {
                contentType = contentType + ";action=\"" + this.soapActionString + "\";";
            }
            return contentType;
        }

        public boolean isRepeatable() {
            return true;
        }
    }
}

