/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisEngine {
    private static final Log log = LogFactory.getLog((Class)AxisEngine.class);
    private ConfigurationContext engineContext;

    public AxisEngine(ConfigurationContext engineContext) {
        this.engineContext = engineContext;
    }

    private void checkMustUnderstand(MessageContext msgContext) throws AxisFault {
        if (!msgContext.isHeaderPresent()) {
            return;
        }
        SOAPEnvelope se = msgContext.getEnvelope();
        if (se.getHeader() == null) {
            return;
        }
        Iterator hbs = se.getHeader().examineAllHeaderBlocks();
        while (hbs.hasNext()) {
            SOAPHeaderBlock hb = (SOAPHeaderBlock)hbs.next();
            if (hb.isProcessed() || !hb.getMustUnderstand()) continue;
            String role = hb.getRole();
            String prefix = se.getNamespace().getPrefix();
            if (!msgContext.isSOAP11()) {
                if (prefix == null || "".equals(prefix)) {
                    prefix = "soapenv";
                }
                if (role != null) {
                    if ("http://www.w3.org/2003/05/soap-envelope/role/next".equals(role)) continue;
                    throw new AxisFault(Messages.getMessage("mustunderstandfaild", prefix, "MustUnderstand"));
                }
                throw new AxisFault(Messages.getMessage("mustunderstandfaild", prefix, "MustUnderstand"));
            }
            if (role == null || "http://schemas.xmlsoap.org/soap/actor/next".equals(role)) continue;
            throw new AxisFault(Messages.getMessage("mustunderstandfaild", prefix, "MustUnderstand"));
        }
    }

    public MessageContext createFaultMessageContext(MessageContext processingContext, Throwable e) throws AxisFault {
        EndpointReference faultTo;
        ServiceContext serviceContext;
        if (processingContext.isProcessingFault()) {
            throw new AxisFault(Messages.getMessage("errorwhileProcessingFault"));
        }
        MessageContext faultContext = new MessageContext();
        faultContext.setConfigurationContext(this.engineContext);
        faultContext.setSessionContext(processingContext.getSessionContext());
        faultContext.setTransportIn(processingContext.getTransportIn());
        faultContext.setTransportOut(processingContext.getTransportOut());
        faultContext.setMessageID(UUIDGenerator.getUUID());
        faultContext.addRelatesTo(new RelatesTo(processingContext.getOptions().getMessageId(), "http://www.w3.org/2005/08/addressing/reply"));
        faultContext.setProperty("CHARACTER_SET_ENCODING", processingContext.getProperty("CHARACTER_SET_ENCODING"));
        if (processingContext.getAxisOperation() != null && processingContext.getOperationContext() != null) {
            processingContext.getAxisOperation().addFaultMessageContext(faultContext, processingContext.getOperationContext());
        }
        if ((serviceContext = processingContext.getServiceContext()) != null) {
            faultContext.setServiceContext(serviceContext);
        }
        faultContext.setProcessingFault(true);
        Object faultInfoForHeaders = processingContext.getProperty("FaultHeaders");
        if (faultInfoForHeaders != null) {
            faultContext.setProperty("FaultHeaders", faultInfoForHeaders);
        }
        boolean doNotSendFaultUsingFaultTo = false;
        if (faultInfoForHeaders != null) {
            String problemHeaderName = (String)((Map)faultInfoForHeaders).get("ProblemHeaderQName");
            boolean bl = doNotSendFaultUsingFaultTo = problemHeaderName != null && "wsa:FaultTo".equals(problemHeaderName);
        }
        if ((faultTo = processingContext.getFaultTo()) != null && !doNotSendFaultUsingFaultTo) {
            faultContext.setTo(processingContext.getFaultTo());
        } else if (!doNotSendFaultUsingFaultTo && processingContext.getEnvelope().getHeader() != null && processingContext.getEnvelope().getHeader().getFirstChildWithName(new QName("FaultTo")) != null) {
            OMElement faultToElement = processingContext.getEnvelope().getHeader().getFirstChildWithName(new QName("FaultTo"));
            faultTo = new EndpointReference("");
            faultTo.fromOM(faultToElement);
            faultContext.setTo(faultTo);
        } else if (processingContext.getReplyTo() != null) {
            faultContext.setTo(processingContext.getReplyTo());
        }
        if (faultTo == null || "http://www.w3.org/2005/08/addressing/anonymous".equals(faultTo.getAddress()) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(faultTo.getAddress()) || "http://www.w3.org/2005/08/addressing/none".equals(faultTo.getAddress())) {
            Object writer = processingContext.getProperty("TRANSPORT_OUT");
            if (writer != null) {
                faultContext.setProperty("TRANSPORT_OUT", writer);
            } else {
                throw new AxisFault(Messages.getMessage("nowhereToSendError"));
            }
        }
        faultContext.setOperationContext(processingContext.getOperationContext());
        faultContext.setProcessingFault(true);
        faultContext.setServerSide(true);
        faultContext.setProperty("OutTransportInfo", processingContext.getProperty("OutTransportInfo"));
        SOAPEnvelope envelope = processingContext.isSOAP11() ? OMAbstractFactory.getSOAP11Factory().getDefaultFaultEnvelope() : OMAbstractFactory.getSOAP12Factory().getDefaultFaultEnvelope();
        this.extractFaultInformationFromMessageContext(processingContext, envelope.getBody().getFault(), e);
        faultContext.setEnvelope(envelope);
        faultContext.setProperty("OutTransportInfo", processingContext.getProperty("OutTransportInfo"));
        return faultContext;
    }

    private void extractFaultInformationFromMessageContext(MessageContext context, SOAPFault fault, Throwable e) {
        Map faultElementsMap;
        Map faultElementsMap2;
        Object faultRole;
        SOAPProcessingException soapException = null;
        AxisFault axisFault = null;
        if (e != null) {
            if (e instanceof AxisFault) {
                axisFault = (AxisFault)e;
            } else if (e.getCause() instanceof AxisFault) {
                axisFault = (AxisFault)e.getCause();
            }
        }
        if (e instanceof SOAPProcessingException) {
            soapException = (SOAPProcessingException)e;
        } else if (axisFault != null && axisFault.getCause() instanceof SOAPProcessingException) {
            soapException = (SOAPProcessingException)axisFault.getCause();
        }
        Object faultCode = context.getProperty("Code");
        String soapFaultCode = "";
        if (faultCode != null) {
            fault.setCode((SOAPFaultCode)faultCode);
        } else if (soapException != null) {
            soapFaultCode = soapException.getFaultCode();
        } else if (axisFault != null) {
            Map faultElementsMap3 = axisFault.getFaultElements();
            if (faultElementsMap3 != null && faultElementsMap3.get("Code") != null) {
                fault.setCode((SOAPFaultCode)faultElementsMap3.get("Code"));
            } else {
                QName faultCodeQName = axisFault.getFaultCode();
                if (faultCodeQName != null) {
                    if (faultCodeQName.getLocalPart().indexOf(":") == -1) {
                        String prefix = faultCodeQName.getPrefix();
                        String uri = faultCodeQName.getNamespaceURI();
                        prefix = prefix == null || "".equals(prefix) ? "axis2" : prefix;
                        uri = uri == null || "".equals(uri) ? "http://ws.apache.org/namespaces/axis2" : uri;
                        soapFaultCode = prefix + ":" + faultCodeQName.getLocalPart();
                        fault.declareNamespace(uri, prefix);
                    } else {
                        soapFaultCode = faultCodeQName.getLocalPart();
                    }
                }
            }
        }
        if (faultCode == null) {
            soapFaultCode = "".equals(soapFaultCode) || soapFaultCode == null ? this.getSenderFaultCode(context.getEnvelope().getNamespace()) : soapFaultCode;
            fault.getCode().getValue().setText(soapFaultCode);
        }
        Object faultReason = context.getProperty("Reason");
        String message = "";
        if (faultReason != null) {
            fault.setReason((SOAPFaultReason)faultReason);
            message = fault.getReason().getFirstSOAPText().getText();
        } else if (soapException != null) {
            message = soapException.getMessage();
        } else if (axisFault != null) {
            Map faultElementsMap4 = axisFault.getFaultElements();
            if (faultElementsMap4 != null && faultElementsMap4.get("Reason") != null) {
                fault.setReason((SOAPFaultReason)faultElementsMap4.get("Reason"));
            } else {
                message = axisFault.getReason();
                if (message == null || "".equals(message)) {
                    message = this.getFaulReasonFromException(e, context);
                }
            }
        }
        if (faultReason == null) {
            message = "".equals(message) || message == null ? "unknown" : message;
            fault.getReason().getFirstSOAPText().setLang("en-US");
            fault.getReason().getFirstSOAPText().setText(message);
        }
        if ((faultRole = context.getProperty("Role")) != null) {
            fault.getRole().setText((String)faultRole);
        } else if (axisFault != null && (faultElementsMap2 = axisFault.getFaultElements()) != null && faultElementsMap2.get("Role") != null) {
            fault.setRole((SOAPFaultRole)faultElementsMap2.get("Role"));
        }
        Object faultNode = context.getProperty("Node");
        if (faultNode != null) {
            fault.getNode().setText((String)faultNode);
        } else if (axisFault != null && (faultElementsMap = axisFault.getFaultElements()) != null && faultElementsMap.get("Node") != null) {
            fault.setNode((SOAPFaultNode)faultElementsMap.get("Node"));
        }
        Parameter param = context.getParameter("sendStacktraceDetailsWithFaults");
        boolean sendStacktraceDetailsWithFaults = param != null && ((String)param.getValue()).equalsIgnoreCase("true");
        Object faultDetail = context.getProperty("Detail");
        if (faultDetail != null) {
            fault.setDetail((SOAPFaultDetail)faultDetail);
        } else if (axisFault != null) {
            Map faultElementsMap5 = axisFault.getFaultElements();
            if (faultElementsMap5 != null && faultElementsMap5.get("Detail") != null) {
                fault.setDetail((SOAPFaultDetail)faultElementsMap5.get("Detail"));
            } else {
                OMElement detail = axisFault.getDetail();
                if (detail != null) {
                    fault.getDetail().addDetailEntry(detail);
                } else if (sendStacktraceDetailsWithFaults) {
                    fault.setException((Exception)axisFault);
                }
            }
        } else if (fault.getException() == null && sendStacktraceDetailsWithFaults) {
            if (e instanceof Exception) {
                fault.setException((Exception)e);
            } else {
                fault.setException(new Exception(e));
            }
        }
    }

    private String getFaulReasonFromException(Throwable e, MessageContext context) {
        boolean drillDownToRootCauseForFaultReason;
        Throwable throwable = e;
        Parameter param = context.getParameter("DrillDownToRootCauseForFaultReason");
        boolean bl = drillDownToRootCauseForFaultReason = param != null && ((String)param.getValue()).equalsIgnoreCase("true");
        if (drillDownToRootCauseForFaultReason) {
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
        }
        return throwable.getMessage();
    }

    public void receive(MessageContext msgContext) throws AxisFault {
        ConfigurationContext confContext = msgContext.getConfigurationContext();
        ArrayList preCalculatedPhases = confContext.getAxisConfiguration().getGlobalInFlow();
        msgContext.setExecutionChain((ArrayList)preCalculatedPhases.clone());
        msgContext.setFLOW(1);
        this.invoke(msgContext);
        if (msgContext.isServerSide() && !msgContext.isPaused()) {
            this.checkMustUnderstand(msgContext);
            MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
            receiver.receive(msgContext);
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext.getCurrentHandlerIndex() == -1) {
            msgContext.setCurrentHandlerIndex(0);
        }
        while (msgContext.getCurrentHandlerIndex() < msgContext.getExecutionChain().size()) {
            Handler currentHandler = (Handler)msgContext.getExecutionChain().get(msgContext.getCurrentHandlerIndex());
            currentHandler.invoke(msgContext);
            if (msgContext.isPaused()) break;
            msgContext.setCurrentHandlerIndex(msgContext.getCurrentHandlerIndex() + 1);
        }
    }

    public void resumeReceive(MessageContext msgContext) throws AxisFault {
        this.invoke(msgContext);
        if (msgContext.isServerSide() && !msgContext.isPaused()) {
            this.checkMustUnderstand(msgContext);
            MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
            receiver.receive(msgContext);
        }
    }

    public void resumeSend(MessageContext msgContext) throws AxisFault {
        this.invoke(msgContext);
        if (!msgContext.isPaused()) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            TransportSender sender = transportOut.getSender();
            sender.invoke(msgContext);
        }
    }

    public void receiveFault(MessageContext msgContext) throws AxisFault {
        log.info((Object)Messages.getMessage("receivederrormessage", msgContext.getMessageID()));
        ConfigurationContext confContext = msgContext.getConfigurationContext();
        ArrayList preCalculatedPhases = confContext.getAxisConfiguration().getInFaultFlow();
        msgContext.setExecutionChain((ArrayList)preCalculatedPhases.clone());
        msgContext.setFLOW(3);
        this.invoke(msgContext);
    }

    public void resume(MessageContext msgctx) throws AxisFault {
        msgctx.setPaused(false);
        if (msgctx.getFLOW() == 1) {
            this.resumeReceive(msgctx);
        } else {
            this.resumeSend(msgctx);
        }
    }

    public void send(MessageContext msgContext) throws AxisFault {
        OperationContext operationContext = msgContext.getOperationContext();
        ArrayList executionChain = operationContext.getAxisOperation().getPhasesOutFlow();
        ArrayList outPhases = new ArrayList();
        outPhases.addAll((ArrayList)executionChain.clone());
        outPhases.addAll((ArrayList)msgContext.getConfigurationContext().getAxisConfiguration().getGlobalOutPhases().clone());
        msgContext.setExecutionChain(outPhases);
        msgContext.setFLOW(2);
        this.invoke(msgContext);
        if (!msgContext.isPaused()) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            TransportSender sender = transportOut.getSender();
            Object isTransportBlocking = msgContext.getProperty("transportNonBlocking");
            if (isTransportBlocking != null && ((Boolean)isTransportBlocking).booleanValue()) {
                msgContext.getConfigurationContext().getThreadPool().execute(new TransportNonBlockingInvocationWorker(msgContext, sender));
            } else {
                sender.invoke(msgContext);
            }
        }
    }

    public void sendFault(MessageContext msgContext) throws AxisFault {
        OperationContext opContext = msgContext.getOperationContext();
        if (opContext != null) {
            AxisOperation axisOperation = opContext.getAxisOperation();
            ArrayList faultExecutionChain = axisOperation.getPhasesOutFaultFlow();
            msgContext.setExecutionChain((ArrayList)faultExecutionChain.clone());
            msgContext.setFLOW(4);
            this.invoke(msgContext);
        }
        if (!msgContext.isPaused()) {
            msgContext.setExecutionChain((ArrayList)msgContext.getConfigurationContext().getAxisConfiguration().getOutFaultFlow().clone());
            msgContext.setFLOW(2);
            this.invoke(msgContext);
            TransportSender sender = msgContext.getTransportOut().getSender();
            sender.invoke(msgContext);
        }
    }

    private String getSenderFaultCode(OMNamespace soapNamespace) {
        return "http://www.w3.org/2003/05/soap-envelope".equals(soapNamespace.getName()) ? "soapenv:Sender" : "soapenv:Client";
    }

    private class TransportNonBlockingInvocationWorker
    implements Runnable {
        private MessageContext msgctx;
        private TransportSender sender;

        public TransportNonBlockingInvocationWorker(MessageContext msgctx, TransportSender sender) {
            this.msgctx = msgctx;
            this.sender = sender;
        }

        public void run() {
            try {
                this.sender.invoke(this.msgctx);
            }
            catch (Exception e) {
                log.info((Object)e.getMessage());
            }
        }
    }
}

