/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.util;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.ws.java2wsdl.SchemaGenerator;
import org.apache.ws.java2wsdl.utils.TypeTable;
import org.codehaus.jam.JMethod;

public class Utils {
    public static void addFlowHandlers(Flow flow, ClassLoader clsLoader) throws AxisFault {
        int count = flow.getHandlerCount();
        for (int j = 0; j < count; ++j) {
            HandlerDescription handlermd = flow.getHandler(j);
            Class handlerClass = Utils.getHandlerClass(handlermd.getClassName(), clsLoader);
            try {
                Handler handler = (Handler)handlerClass.newInstance();
                handler.init(handlermd);
                handlermd.setHandler(handler);
                continue;
            }
            catch (InstantiationException e) {
                throw new AxisFault(e);
            }
            catch (IllegalAccessException e) {
                throw new AxisFault(e);
            }
        }
    }

    public static void loadHandler(ClassLoader loader1, HandlerDescription desc) throws DeploymentException {
        String handlername = desc.getClassName();
        try {
            Class<?> handlerClass = Class.forName(handlername, true, loader1);
            Handler handler = (Handler)handlerClass.newInstance();
            handler.init(desc);
            desc.setHandler(handler);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(e);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public static URL[] getURLsForAllJars(URL url) {
        try {
            ZipEntry entry;
            ArrayList<URL> array = new ArrayList<URL>();
            array.add(url);
            ZipInputStream zin = new ZipInputStream(url.openStream());
            while ((entry = zin.getNextEntry()) != null) {
                int count;
                String entryName = entry.getName();
                if (entryName == null || !entryName.toLowerCase().startsWith("lib/") || !entryName.toLowerCase().endsWith(".jar")) continue;
                byte[] data = new byte[2048];
                File f = File.createTempFile("axis2", entryName.substring(4));
                f.deleteOnExit();
                FileOutputStream out = new FileOutputStream(f);
                while ((count = zin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                out.close();
                array.add(f.toURL());
            }
            zin.close();
            return array.toArray(new URL[array.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassLoader getClassLoader(ClassLoader parent, String path) throws DeploymentException {
        return Utils.getClassLoader(parent, new File(path));
    }

    public static ClassLoader getClassLoader(ClassLoader parent, File file) throws DeploymentException {
        if (file != null) {
            try {
                File jarfile;
                int i;
                File[] jarfiles;
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(file.toURL());
                File libfiles = new File(file, "lib");
                if (libfiles.exists()) {
                    urls.add(libfiles.toURL());
                    jarfiles = libfiles.listFiles();
                    for (i = 0; i < jarfiles.length; ++i) {
                        jarfile = jarfiles[i];
                        if (!jarfile.getName().endsWith(".jar")) continue;
                        urls.add(jarfile.toURL());
                    }
                }
                if ((libfiles = new File(file, "Lib")).exists()) {
                    urls.add(libfiles.toURL());
                    jarfiles = libfiles.listFiles();
                    for (i = 0; i < jarfiles.length; ++i) {
                        jarfile = jarfiles[i];
                        if (!jarfile.getName().endsWith(".jar")) continue;
                        urls.add(jarfile.toURL());
                    }
                }
                URL[] urllist = new URL[urls.size()];
                for (i = 0; i < urls.size(); ++i) {
                    urllist[i] = (URL)urls.get(i);
                }
                URLClassLoader classLoader = new URLClassLoader(urllist, parent);
                return classLoader;
            }
            catch (MalformedURLException e) {
                throw new DeploymentException(e);
            }
        }
        return null;
    }

    private static Class getHandlerClass(String className, ClassLoader loader1) throws AxisFault {
        Class<?> handlerClass;
        try {
            handlerClass = Class.forName(className, true, loader1);
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault(e.getMessage());
        }
        return handlerClass;
    }

    public static void fillAxisService(AxisService axisService, AxisConfiguration axisConfig, ArrayList excludeOperations) throws Exception {
        Parameter implInfoParam = axisService.getParameter("ServiceClass");
        if (implInfoParam == null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ns1", "http://org.apache.axis2/xsd");
        map.put("xs", "http://www.w3.org/2001/XMLSchema");
        axisService.setNameSpacesMap(map);
        String serviceClass = (String)implInfoParam.getValue();
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        SchemaGenerator schemaGenerator = new SchemaGenerator(serviceClassLoader, serviceClass.trim(), axisService.getSchematargetNamespace(), axisService.getSchematargetNamespacePrefix());
        schemaGenerator.setExcludeMethods(excludeOperations);
        Collection schemas = schemaGenerator.generateSchema();
        axisService.addSchema(schemas);
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            JMethod jmethod = method[i];
            if (!jmethod.isPublic() || jmethod.getSimpleName().equals("init") || "setOperationContext".equals(jmethod.getSimpleName()) || "destroy".equals(jmethod.getSimpleName())) continue;
            String opName = jmethod.getSimpleName();
            AxisOperation operation = axisService.getOperation(new QName(opName));
            if (operation != null) {
                AxisMessage inMessage = operation.getMessage("In");
                if (inMessage != null) {
                    inMessage.setName(opName + "Message");
                    inMessage.setElementQName(table.getComplexSchemaType(jmethod.getSimpleName()));
                }
                if (!jmethod.getReturnType().isVoidType()) {
                    AxisMessage outMessage = operation.getMessage("Out");
                    outMessage.setElementQName(table.getQNamefortheType(jmethod.getSimpleName() + "Response"));
                    outMessage.setName(opName + "Response");
                }
            } else {
                operation = Utils.getAxisOperationforJmethod(jmethod, table);
                MessageReceiver mr = axisService.getMessageReceiver(operation.getMessageExchangePattern());
                if (mr != null) {
                    operation.setMessageReceiver(mr);
                } else {
                    mr = axisConfig.getMessageReceiver(operation.getMessageExchangePattern());
                    operation.setMessageReceiver(mr);
                }
                pinfo.setOperationPhases(operation);
                axisService.addOperation(operation);
            }
            operation.setSoapAction("urn:" + opName);
        }
    }

    public static AxisOperation getAxisOperationforJmethod(JMethod jmethod, TypeTable table) throws AxisFault {
        AxisOperation operation;
        String opName = jmethod.getSimpleName();
        if ("init".equals(opName)) {
            return null;
        }
        if (jmethod.getReturnType().isVoidType()) {
            operation = AxisOperationFactory.getAxisOperation(10);
        } else {
            operation = AxisOperationFactory.getAxisOperation(12);
            AxisMessage outMessage = operation.getMessage("Out");
            outMessage.setElementQName(table.getQNamefortheType(jmethod.getSimpleName() + "Response"));
            outMessage.setName(opName + "Response");
        }
        operation.setName(new QName(opName));
        AxisMessage inMessage = operation.getMessage("In");
        if (inMessage != null) {
            inMessage.setElementQName(table.getComplexSchemaType(jmethod.getSimpleName()));
            inMessage.setName(opName + "Message");
        }
        return operation;
    }

    public static OMElement getParameter(String name, String value, boolean locked) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement parameter = fac.createOMElement("parameter", null);
        parameter.addAttribute("name", name, null);
        parameter.addAttribute("locked", Boolean.toString(locked), null);
        parameter.setText(value);
        return parameter;
    }
}

