/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;

public class WSDLBasedPolicyProcessor {
    private HashMap ns2modules = new HashMap();
    private ConfigurationContext configctx;

    public WSDLBasedPolicyProcessor(ConfigurationContext configctx) {
        this.configctx = configctx;
        AxisConfiguration axisConfiguration = configctx.getAxisConfiguration();
        Iterator iterator = axisConfiguration.getModules().values().iterator();
        while (iterator.hasNext()) {
            AxisModule axisModule = (AxisModule)iterator.next();
            String[] namespaces = axisModule.getSupportedPolicyNamespaces();
            if (namespaces == null) continue;
            for (int i = 0; i < namespaces.length; ++i) {
                ArrayList<AxisModule> moduleList = null;
                Object obj = this.ns2modules.get(namespaces[i]);
                if (obj == null) {
                    moduleList = new ArrayList<AxisModule>(5);
                    this.ns2modules.put(namespaces[i], moduleList);
                } else {
                    moduleList = (ArrayList<AxisModule>)obj;
                }
                moduleList.add(axisModule);
            }
        }
    }

    public void configureServicePolices(AxisService axisService) throws AxisFault {
        Iterator operations = axisService.getOperations();
        while (operations.hasNext()) {
            AxisOperation axisOp = (AxisOperation)operations.next();
            this.configureOperationPolices(axisOp);
        }
    }

    public void configureOperationPolices(AxisOperation op) throws AxisFault {
        Policy policy;
        PolicyInclude policyInclude = op.getPolicyInclude();
        if (policyInclude != null && (policy = policyInclude.getEffectivePolicy()) != null) {
            if (!policy.isNormalized()) {
                policy = (Policy)policy.normalize();
            }
            XorCompositeAssertion XOR = (XorCompositeAssertion)policy.getTerms().get(0);
            AndCompositeAssertion AND = (AndCompositeAssertion)XOR.getTerms().get(0);
            Iterator pAsserations = AND.getTerms().iterator();
            while (pAsserations.hasNext()) {
                PrimitiveAssertion pa = (PrimitiveAssertion)pAsserations.next();
                String namespace = pa.getName().getNamespaceURI();
                ArrayList moduleList = (ArrayList)this.ns2modules.get(namespace);
                if (moduleList == null) {
                    System.err.println("cannot find a module to process " + namespace + "type assertions");
                    continue;
                }
                for (int i = 0; i < moduleList.size(); ++i) {
                    AxisModule axisModule = (AxisModule)moduleList.get(i);
                    Iterator engagedModules = op.getEngagedModules().iterator();
                    boolean found = false;
                    while (engagedModules.hasNext()) {
                        AxisModule module = (AxisModule)engagedModules.next();
                        if (!module.getName().equals(axisModule.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    op.engageModule(axisModule, this.configctx.getAxisConfiguration());
                    axisModule.getModule().engageNotify(op);
                }
            }
        }
    }
}

