/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.lock;

import cn.hutool.core.util.ArrayUtil;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.lock.ObjWithLock;

public class CollectionWithLock<C extends Collection<T>, T>
extends ObjWithLock<C> {
    private static final long serialVersionUID = 7147337808024160684L;
    private static final Logger log = LoggerFactory.getLogger(CollectionWithLock.class);

    public CollectionWithLock(C collection) {
        super(collection);
    }

    public CollectionWithLock(C collection, ReentrantReadWriteLock lock) {
        super(collection, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Collection collection = (Collection)this.getObj();
            boolean bl = collection.add(t);
            return bl;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(C t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Collection collection = (Collection)this.getObj();
            boolean bl = collection.addAll(t);
            return bl;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Collection collection = (Collection)this.getObj();
            collection.clear();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        if (t == null) {
            return false;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Collection collection = (Collection)this.getObj();
            boolean bl = collection.remove(t);
            return bl;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            Collection collection = (Collection)this.getObj();
            int n = collection.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(C items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Collection collection = (Collection)this.getObj();
            collection.removeAll((Collection<?>)items);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(T[] items) {
        if (ArrayUtil.isEmpty((Object[])items)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Collection collection = (Collection)this.getObj();
            for (T item : items) {
                collection.remove(item);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(T[] items) {
        if (ArrayUtil.isEmpty((Object[])items)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Collection collection = (Collection)this.getObj();
            for (T item : items) {
                collection.add(item);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T v) {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            Collection set = (Collection)this.getObj();
            boolean bl = set.contains(v);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }
}

