/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.lock;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.lock.CollectionWithLock;

public class SetWithLock<T>
extends CollectionWithLock<Set<T>, T> {
    private static final long serialVersionUID = -2305909960649321346L;
    private static Logger log = LoggerFactory.getLogger(SetWithLock.class);
    private AtomicInteger randomCount = new AtomicInteger();

    public SetWithLock(Set<T> set) {
        super(set);
    }

    public SetWithLock(Set<T> set, ReentrantReadWriteLock lock) {
        super(set, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T next() {
        Set set = (Set)this.getObj();
        if (set.size() == 0) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                Object t;
                Object e = t = iterator.next();
                return (T)e;
            }
        }
        catch (Throwable e) {
            log.error("", e);
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T random() {
        Set set = (Set)this.getObj();
        if (set.size() == 0) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            int index = this.randomCount.incrementAndGet() % set.size();
            int i = 0;
            for (Object t : set) {
                if (index != i++) continue;
                Object e = t;
                return (T)e;
            }
        }
        catch (Throwable e) {
            log.error("", e);
        }
        finally {
            readLock.unlock();
        }
        return null;
    }
}

