/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.lock;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.lock.CollectionWithLock;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.ObjWithLock;

public abstract class MapCollectionWithLock<K, V, CC extends Collection<V>, C extends CollectionWithLock<CC, V>>
extends ObjWithLock<MapWithLock<K, C>> {
    private static final long serialVersionUID = 3511183015908156445L;
    private static Logger log = LoggerFactory.getLogger(MapCollectionWithLock.class);
    private MapWithLock<K, C> mapWithLock = null;
    private static final String CLASS_NAME = MapCollectionWithLock.class.getName();

    public MapCollectionWithLock(MapWithLock<K, C> map, ReentrantReadWriteLock lock) {
        super(map, lock);
    }

    public MapCollectionWithLock(MapWithLock<K, C> map) {
        super(map);
        this.mapWithLock = map;
    }

    public abstract C newCollection();

    public C putIfAbsent(K key) {
        if (Objects.isNull(key)) {
            return null;
        }
        CollectionWithLock setWithLock = (CollectionWithLock)this.mapWithLock.get(key);
        try {
            if (setWithLock == null) {
                LockUtils.runWriteOrWaitRead(CLASS_NAME + key, this, () -> {
                    if (this.mapWithLock.get(key) == null) {
                        this.mapWithLock.put(key, this.newCollection());
                    }
                });
                setWithLock = (CollectionWithLock)this.mapWithLock.get(key);
            }
        }
        catch (Throwable e) {
            log.error("", e);
        }
        return (C)setWithLock;
    }

    public void put(K key, V value) {
        C setWithLock = this.putIfAbsent(key);
        ((CollectionWithLock)setWithLock).add(value);
    }

    public void putAll(K key, CC values) {
        CC setWithLock = this.putIfAbsent(key);
        ((CollectionWithLock)setWithLock).addAll(values);
    }

    public void remove(K key) {
        if (key == null) {
            return;
        }
        this.mapWithLock.remove(key);
    }

    public void removeItem(K key, V value) {
        this.remove(key, value, null);
    }

    public void removeItems(K key, CC values) {
        this.remove(key, null, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key, V value, CC values) {
        if (key == null) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.mapWithLock.writeLock();
        lock.lock();
        try {
            Map map = (Map)this.mapWithLock.getObj();
            CollectionWithLock setWithLock = (CollectionWithLock)map.get(key);
            if (setWithLock == null) {
                return;
            }
            ReentrantReadWriteLock.WriteLock writeLock = setWithLock.writeLock();
            writeLock.lock();
            try {
                Collection set = (Collection)setWithLock.getObj();
                if (value != null) {
                    set.remove(value);
                }
                if (values != null && !values.isEmpty()) {
                    set.removeAll((Collection<?>)values);
                }
                if (set.isEmpty()) {
                    map.remove(key);
                }
                writeLock.unlock();
            }
            catch (Throwable e) {
                try {
                    log.error(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(V value, CC values) {
        if (this.mapWithLock.size() == 0) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.mapWithLock.writeLock();
        lock.lock();
        try {
            Map map = (Map)this.mapWithLock.getObj();
            Set set1 = map.entrySet();
            HashSet keysForDel = new HashSet();
            for (Map.Entry entry : set1) {
                Object key = entry.getKey();
                CollectionWithLock setWithLock = (CollectionWithLock)entry.getValue();
                if (setWithLock == null) continue;
                ReentrantReadWriteLock.WriteLock writeLock = setWithLock.writeLock();
                writeLock.lock();
                try {
                    Collection set = (Collection)setWithLock.getObj();
                    if (value != null) {
                        set.remove(value);
                    }
                    if (values != null && !values.isEmpty()) {
                        set.removeAll((Collection<?>)values);
                    }
                    if (!set.isEmpty()) continue;
                    keysForDel.add(key);
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
                finally {
                    writeLock.unlock();
                }
            }
            if (keysForDel.size() > 0) {
                for (Map.Entry k : keysForDel) {
                    map.remove(k);
                }
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public void clear() {
        this.mapWithLock.clear();
    }

    public C get(K key) {
        return (C)((CollectionWithLock)this.mapWithLock.get(key));
    }
}

