/*
 * Decompiled with CFR 0.152.
 */
package com.focus.locode.plugin.ca.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.framework.session.CentitSessionRepo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import com.focus.locode.plugin.ca.auth.ObtainAuthData;
import com.focus.locode.plugin.ca.po.AccessTokenUserInfo;
import com.focus.locode.plugin.ca.po.CallbackSsoAuthRequest;
import com.focus.locode.plugin.ca.po.CallbackSsoAuthResponse;
import com.focus.locode.plugin.ca.po.SsoGrantTypeEnum;
import com.focus.locode.plugin.ca.service.LocodeUserUnitService;
import com.focus.locode.plugin.ca.util.FocusSsoUtil;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sso"})
public class Ptl2SsoController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(Ptl2SsoController.class);
    private static final String GRANT_TYPE = "authorization_code";
    private static final String ACCESS_TOKEN_URL = "token/accessToken";
    private static final String ERROR_TYPE = "&error=";
    private static final String PTL_ERROR_TYPE = "&ptl2ErrReason";
    @Value(value="${focus.sso.server}")
    protected String focusSsoServer;
    @Value(value="${focus.sso.client.id}")
    protected String clientId;
    @Value(value="${focus.sso.client.secret}")
    protected String clientSecret;
    @Value(value="${focus.sso.key}")
    protected String ssoKey;
    @Autowired
    protected PlatformEnvironment platformEnvironment;
    @Autowired
    protected ObtainAuthData obtainAuthData;
    @Autowired
    protected LocodeUserUnitService locodeUserUnitService;
    @Autowired
    protected CentitSessionRepo centitSessionRepo;

    @ApiOperation(value="\u8ba4\u8bc1\u56de\u8c03\u63a5\u53e3", notes="\u8ba4\u8bc1\u56de\u8c03\u63a5\u53e3")
    @GetMapping(value={"authorize"})
    @WrapUpResponseBody
    public ResponseData ssoAuthorize(CallbackSsoAuthRequest callbackSsoAuthRequest, HttpServletRequest request) {
        if (!SsoGrantTypeEnum.AUTHORIZATION_CODE.getModeCode().equals(callbackSsoAuthRequest.getMode())) {
            throw new ObjectException(101, "\u8ba4\u8bc1\u6a21\u5f0f\u4e0d\u4e00\u81f4\uff1amode-error--" + callbackSsoAuthRequest.getMode());
        }
        CallbackSsoAuthResponse ssoAuthResponse = null;
        String jsonString = "";
        try {
            HttpExecutorContext context = HttpExecutorContext.create();
            jsonString = HttpExecutor.formPost((HttpExecutorContext)context, (String)(this.focusSsoServer + ACCESS_TOKEN_URL), (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"client_id", this.clientId, "client_secret", this.clientSecret, "grant_type", GRANT_TYPE, "uc", callbackSsoAuthRequest.getUc(), "code", callbackSsoAuthRequest.getCode()}));
            ssoAuthResponse = (CallbackSsoAuthResponse)JSON.parseObject((String)jsonString, CallbackSsoAuthResponse.class);
        }
        catch (Exception e) {
            logger.error("post token/accessToken error", (Throwable)e);
            throw new ObjectException("token/accessToken error");
        }
        if (ssoAuthResponse == null || StringUtils.isNotBlank((CharSequence)ssoAuthResponse.getErrorDescription())) {
            logger.warn("repose token/accessToken error,{}", (Object)jsonString);
            throw new ObjectException(101, "request-token-error--" + jsonString);
        }
        AccessTokenUserInfo ssoUserinfo = ssoAuthResponse.getUserinfo();
        if (ssoUserinfo == null || StringUtils.isBlank((CharSequence)ssoUserinfo.getUsername())) {
            logger.warn("reposeUserInfo  token/accessToken error,ssoAuthResponse:{}", (Object)ssoAuthResponse);
            throw new ObjectException(101, "user not found--" + jsonString);
        }
        CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(ssoUserinfo.getUsername());
        if (ud == null) {
            throw new ObjectException(710, "user not found--" + ssoUserinfo.getUsername());
        }
        ud.setUserRoles(this.obtainAuthData.getRoleByLoginUserNameAndAppSymbols(ud.getUserInfo().getLoginName()));
        SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
        SecurityContextUtils.fetchAndSetLocalParams((CentitUserDetails)ud, (HttpServletRequest)request, (PlatformEnvironment)this.platformEnvironment);
        return SecurityContextUtils.makeLoginSuccessResponse((CentitUserDetails)ud, (HttpServletRequest)request);
    }

    @ApiOperation(value="\u767b\u51fa", notes="\u6ce8\u9500\u767b\u5f55session")
    @GetMapping(value={"/logout"})
    public void logout(HttpSession session) throws IOException {
        session.invalidate();
    }

    @ApiOperation(value="\u767b\u5f55\u9875\u9762", notes="\u8df3\u8f6c\u5230\u767b\u5f55\u9875\u9762\uff0c\u53ef\u80fd\u4e0d\u9700\u8981\u8fd9\u4e2a\u63a5\u53e3")
    @GetMapping(value={"/login"})
    public void loginPage(@RequestParam(value="type") String type, @RequestParam(value="userCode") String userCode, @RequestParam(value="returnUrl") String returnUrl, HttpServletResponse response) throws IOException {
        String url = "&type=" + type + "&returnUrl=" + returnUrl + "&userCode=" + userCode;
        String authorizeUrl = "&response_type=code&scope=snsapi_login&redirect_uri=" + url;
        response.sendRedirect(authorizeUrl);
    }

    @PostMapping(value={"forbidden_account"})
    @ResponseBody
    @WrapUpResponseBody
    public ResponseData forbiddenAccount(@RequestBody String result) throws Exception {
        JSONArray jsonArray;
        String decodeSsoRequest = FocusSsoUtil.decrypt(result, this.ssoKey);
        if (StringUtils.isNotBlank((CharSequence)decodeSsoRequest) && (jsonArray = JSONArray.parse((String)decodeSsoRequest, (JSONReader.Feature[])new JSONReader.Feature[0])) != null) {
            for (Object obj : jsonArray) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject userJson = (JSONObject)obj;
                Integer state = userJson.getInteger("state");
                String userLoginName = userJson.getString("account");
                if (state != null && state != 1) {
                    String message = userJson.getString("message");
                    this.locodeUserUnitService.forbiddenAccount(userLoginName, message);
                }
                this.centitSessionRepo.kickSessionByName(userLoginName);
            }
        }
        return ResponseData.makeErrorMessage((int)100, (String)"");
    }

    @PostMapping(value={"createSession"})
    @ResponseBody
    @WrapUpResponseBody
    public ResponseData createSession(HttpServletRequest request) {
        Map formValue = BaseController.collectRequestParameters((HttpServletRequest)request);
        String username = StringBaseOpt.objectToString(formValue.get("username"));
        CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(username);
        if (ud == null) {
            throw new ObjectException(710, "user not found--" + username);
        }
        ud.setUserRoles(this.obtainAuthData.getRoleByLoginUserNameAndAppSymbols(ud.getUserInfo().getLoginName()));
        SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
        SecurityContextUtils.fetchAndSetLocalParams((CentitUserDetails)ud, (HttpServletRequest)request, (PlatformEnvironment)this.platformEnvironment);
        return SecurityContextUtils.makeLoginSuccessResponse((CentitUserDetails)ud, (HttpServletRequest)request);
    }

    @PostMapping(value={"deleteSession"})
    @ResponseBody
    @WrapUpResponseBody
    public ResponseData deleteSession(HttpServletRequest request) {
        Map formValue = BaseController.collectRequestParameters((HttpServletRequest)request);
        String username = StringBaseOpt.objectToString(formValue.get("username"));
        this.centitSessionRepo.kickSessionByName(username);
        return ResponseData.makeErrorMessage((int)100, (String)"");
    }
}

