/*
 * Decompiled with CFR 0.152.
 */
package com.focus.locode.plugin.ca.config;

import com.centit.framework.model.security.CentitUserDetailsService;
import com.centit.framework.security.AjaxAuthenticationEntryPoint;
import com.centit.framework.security.PretreatmentAuthenticationProcessingFilter;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.focus.locode.plugin.ca.config.SpringSecurityBaseConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.HttpStatusReturningLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.session.security.web.authentication.SpringSessionRememberMeServices;

@EnableWebSecurity
public class SpringSecurityDaoConfig
extends SpringSecurityBaseConfig {
    @Autowired
    protected CentitUserDetailsService centitUserDetailsService;
    @Autowired
    @Qualifier(value="passwordEncoder")
    protected PasswordEncoder passwordEncoder;
    @Autowired(required=false)
    private MessageSource messageSource;

    @Override
    protected String[] getAuthenticatedUrl() {
        if (BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("access.resource.notallowed.anonymous"), (Boolean)false).booleanValue()) {
            return new String[]{"/**"};
        }
        return null;
    }

    @Override
    protected String[] getPermitAllUrl() {
        return new String[]{"/**/login", "/**/logout", "/**/csrf", "/**/doc.html", "/system/exception"};
    }

    @Override
    protected AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return new AjaxAuthenticationEntryPoint("/system/mainframe/login");
    }

    @Override
    protected AbstractAuthenticationProcessingFilter getAuthenticationFilter() {
        PretreatmentAuthenticationProcessingFilter pretreatmentAuthenticationProcessingFilter = new PretreatmentAuthenticationProcessingFilter();
        pretreatmentAuthenticationProcessingFilter.setAuthenticationManager(this.createAuthenticationManager());
        pretreatmentAuthenticationProcessingFilter.setCheckCaptchaTime(NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("login.captcha.checkTime"), (Integer)0).intValue());
        pretreatmentAuthenticationProcessingFilter.setCheckCaptchaType(NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("login.captcha.checkType"), (Integer)0).intValue());
        pretreatmentAuthenticationProcessingFilter.setRetryCheckType(StringBaseOpt.emptyValue((String)this.env.getProperty("login.retry.checkType"), (String)"H"));
        pretreatmentAuthenticationProcessingFilter.setRetryMaxTryTimes(NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("login.retry.maxTryTimes"), (Integer)0).intValue());
        pretreatmentAuthenticationProcessingFilter.setRetryLockMinites(NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("login.retry.lockMinites"), (Integer)10).intValue());
        pretreatmentAuthenticationProcessingFilter.setRetryCheckTimeTnterval(NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("login.retry.checkTimeTnterval"), (Integer)3).intValue());
        pretreatmentAuthenticationProcessingFilter.setContinueChainBeforeSuccessfulAuthentication(BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("http.filter.chain.continueBeforeSuccessfulAuthentication"), (Boolean)false).booleanValue());
        pretreatmentAuthenticationProcessingFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.createAjaxFailureHandler());
        pretreatmentAuthenticationProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.createAjaxSuccessHandler());
        String requiresAuthenticationUrl = this.env.getProperty("login.authentication.url");
        if (StringUtils.isNotBlank((CharSequence)requiresAuthenticationUrl)) {
            pretreatmentAuthenticationProcessingFilter.setRequiresAuthenticationRequestMatcher((RequestMatcher)new AntPathRequestMatcher(requiresAuthenticationUrl, "POST"));
        }
        if (this.sessionRegistry != null) {
            ConcurrentSessionControlAuthenticationStrategy strategy = new ConcurrentSessionControlAuthenticationStrategy(this.sessionRegistry);
            strategy.setMaximumSessions(NumberBaseOpt.parseInteger((String)this.env.getProperty("session.concurrent.maximum"), (Integer)-1).intValue());
            pretreatmentAuthenticationProcessingFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)strategy);
        }
        SpringSessionRememberMeServices rememberMeServices = new SpringSessionRememberMeServices();
        rememberMeServices.setAlwaysRemember(BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("session.always.rememberme"), (Boolean)false).booleanValue());
        pretreatmentAuthenticationProcessingFilter.setRememberMeServices((RememberMeServices)rememberMeServices);
        return pretreatmentAuthenticationProcessingFilter;
    }

    @Override
    protected AuthenticationProvider getAuthenticationProvider() {
        DaoAuthenticationProvider authenticationProvider = new DaoAuthenticationProvider();
        authenticationProvider.setHideUserNotFoundExceptions(false);
        authenticationProvider.setUserDetailsService((UserDetailsService)this.centitUserDetailsService);
        authenticationProvider.setPasswordEncoder(this.passwordEncoder);
        if (this.messageSource != null && !(this.messageSource instanceof DelegatingMessageSource)) {
            authenticationProvider.setMessageSource(this.messageSource);
        }
        return authenticationProvider;
    }

    protected LogoutFilter logoutFilter() {
        HttpStatusReturningLogoutSuccessHandler http = new HttpStatusReturningLogoutSuccessHandler();
        return new LogoutFilter((LogoutSuccessHandler)http, new LogoutHandler[]{new CsrfLogoutHandler(this.csrfTokenRepository), new CookieClearingLogoutHandler(new String[]{"JSESSIONID", "remember-me"}), new SecurityContextLogoutHandler()});
    }
}

