/*
 * Decompiled with CFR 0.152.
 */
package com.focus.locode.plugin.ca.config;

import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.AjaxAccessDeniedHandlerImpl;
import com.centit.framework.security.AjaxAuthenticationFailureHandler;
import com.centit.framework.security.AjaxAuthenticationSuccessHandler;
import com.centit.framework.security.CentitSecurityMetadata;
import com.centit.framework.security.DaoAccessDecisionManager;
import com.centit.framework.security.DaoFilterSecurityInterceptor;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.focus.locode.plugin.ca.auth.FocusSecurityMetadataSource;
import com.focus.locode.plugin.ca.auth.ObtainAuthData;
import java.util.ArrayList;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.util.Assert;

public abstract class SpringSecurityBaseConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    protected Environment env;
    @Autowired
    protected CsrfTokenRepository csrfTokenRepository;
    @Autowired(required=false)
    protected SessionRegistry sessionRegistry;
    @Autowired
    protected PlatformEnvironment platformEnvironment;
    @Autowired
    private ObtainAuthData obtainAuthData;

    public void configure(WebSecurity web) throws Exception {
        String ignoreUrl = StringUtils.deleteWhitespace((String)this.env.getProperty("security.ignore.url"));
        if (StringUtils.isNotBlank((CharSequence)ignoreUrl)) {
            String[] ignoreUrls = ignoreUrl.split(",");
            for (int i = 0; i < ignoreUrls.length; ++i) {
                web.ignoring().antMatchers(new String[]{ignoreUrls[i]});
            }
        }
        web.httpFirewall((HttpFirewall)this.httpFirewall());
    }

    protected void configure(HttpSecurity http) throws Exception {
        int maximumSessions;
        if (BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("http.anonymous.disable"), (Boolean)false).booleanValue()) {
            http.anonymous().disable();
        }
        if (this.getPermitAllUrl() != null && this.getPermitAllUrl().length > 0) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.getPermitAllUrl())).permitAll();
        }
        if (this.getAuthenticatedUrl() != null && this.getAuthenticatedUrl().length > 0) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.getAuthenticatedUrl())).authenticated();
        }
        if (BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("http.csrf.enable"), (Boolean)false).booleanValue()) {
            http.csrf().csrfTokenRepository(this.csrfTokenRepository);
        } else {
            http.csrf().disable();
        }
        AjaxAccessDeniedHandlerImpl ajaxAccessDeniedHandler = new AjaxAccessDeniedHandlerImpl();
        ajaxAccessDeniedHandler.setErrorPage("/system/exception/error/403");
        http.exceptionHandling().accessDeniedHandler((AccessDeniedHandler)ajaxAccessDeniedHandler);
        http.httpBasic().authenticationEntryPoint(this.getAuthenticationEntryPoint());
        switch (this.getFrameOptions()) {
            case "DISABLE": {
                http.headers().frameOptions().disable();
                break;
            }
            case "SAMEORIGIN": {
                http.headers().frameOptions().sameOrigin();
                break;
            }
            default: {
                http.headers().frameOptions().deny();
            }
        }
        String defaultTargetUrl = this.env.getProperty("logout.success.targetUrl");
        http.logout().logoutSuccessUrl(StringBaseOpt.emptyValue((String)defaultTargetUrl, (String)"/"));
        http.addFilterAt((Filter)this.getAuthenticationFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.centitPowerFilter(), FilterSecurityInterceptor.class);
        String loginFailureUrl = this.env.getProperty("login.failure.targetUrl");
        if (StringUtils.isBlank((CharSequence)loginFailureUrl)) {
            loginFailureUrl = "/system/mainframe/login";
        }
        if ((maximumSessions = NumberBaseOpt.parseInteger((String)this.env.getProperty("session.concurrent.maximum"), (Integer)-1).intValue()) > 0 && this.sessionRegistry != null) {
            http.sessionManagement().maximumSessions(maximumSessions).sessionRegistry(this.sessionRegistry).expiredUrl(loginFailureUrl);
        }
    }

    protected abstract String[] getAuthenticatedUrl();

    protected abstract String[] getPermitAllUrl();

    protected abstract AuthenticationEntryPoint getAuthenticationEntryPoint();

    protected String getFrameOptions() {
        String frameOptions = this.env.getProperty("framework.x-frame-options.mode");
        frameOptions = StringBaseOpt.emptyValue((String)frameOptions, (String)"deny").toUpperCase();
        return frameOptions;
    }

    protected abstract AbstractAuthenticationProcessingFilter getAuthenticationFilter();

    protected DaoFilterSecurityInterceptor centitPowerFilter() {
        DaoFilterSecurityInterceptor interceptor = new DaoFilterSecurityInterceptor();
        AuthenticationManager authenticationManager = this.createAuthenticationManager();
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager\u4e0d\u80fd\u4e3a\u7a7a");
        AjaxAuthenticationSuccessHandler successHandler = this.createAjaxSuccessHandler();
        Assert.notNull((Object)successHandler, (String)"successHandler\u4e0d\u80fd\u4e3a\u7a7a");
        AjaxAuthenticationFailureHandler failureHandler = this.createAjaxFailureHandler();
        Assert.notNull((Object)failureHandler, (String)"failureHandler\u4e0d\u80fd\u4e3a\u7a7a");
        interceptor.setAuthenticationManager(authenticationManager);
        interceptor.setAccessDecisionManager((AccessDecisionManager)this.createCentitAccessDecisionManager());
        interceptor.setSecurityMetadataSource(this.createFocusSecurityMetadataSource());
        interceptor.setAlwaysReauthenticate(BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("access.resource.notallowed.anonymous"), (Boolean)false).booleanValue());
        return interceptor;
    }

    protected abstract Filter logoutFilter();

    protected AuthenticationManager createAuthenticationManager() {
        AuthenticationProvider authenticationProvider = this.getAuthenticationProvider();
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<AuthenticationProvider> providerList = new ArrayList<AuthenticationProvider>();
        providerList.add(authenticationProvider);
        return new ProviderManager(providerList);
    }

    protected abstract AuthenticationProvider getAuthenticationProvider();

    protected AjaxAuthenticationFailureHandler createAjaxFailureHandler() {
        AjaxAuthenticationFailureHandler ajaxFailureHandler = new AjaxAuthenticationFailureHandler();
        String defaultTargetUrl = this.env.getProperty("login.failure.targetUrl");
        ajaxFailureHandler.setDefaultFailureUrl(StringBaseOpt.emptyValue((String)defaultTargetUrl, (String)"/system/mainframe/login/error"));
        ajaxFailureHandler.setWriteLog(BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("login.failure.writeLog"), (Boolean)false).booleanValue());
        return ajaxFailureHandler;
    }

    protected AjaxAuthenticationSuccessHandler createAjaxSuccessHandler() {
        AjaxAuthenticationSuccessHandler ajaxSuccessHandler = new AjaxAuthenticationSuccessHandler();
        String defaultTargetUrl = this.env.getProperty("login.success.targetUrl");
        if (BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("login.success.alwaysUserTargetUrl"), (Boolean)false).booleanValue()) {
            ajaxSuccessHandler.setAlwaysUseDefaultTargetUrl(true);
        }
        ajaxSuccessHandler.setDefaultTargetUrl(StringBaseOpt.emptyValue((String)defaultTargetUrl, (String)"/"));
        ajaxSuccessHandler.setWriteLog(BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("login.success.writeLog"), (Boolean)true).booleanValue());
        ajaxSuccessHandler.setPlatformEnvironment(this.platformEnvironment);
        return ajaxSuccessHandler;
    }

    protected DaoAccessDecisionManager createCentitAccessDecisionManager() {
        return new DaoAccessDecisionManager();
    }

    protected FilterInvocationSecurityMetadataSource createFocusSecurityMetadataSource() {
        CentitSecurityMetadata.setIsForbiddenWhenAssigned((boolean)BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("access.resource.must.be.assigned"), (Boolean)false));
        return new FocusSecurityMetadataSource(this.obtainAuthData);
    }

    private StrictHttpFirewall httpFirewall() {
        StrictHttpFirewall firewall = new StrictHttpFirewall();
        firewall.setAllowSemicolon(BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("http.firewall.allowSemicolon"), (Boolean)true).booleanValue());
        return firewall;
    }
}

