/*
 * Decompiled with CFR 0.152.
 */
package com.focus.locode.plugin.ca.auth;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.RolePower;
import com.centit.framework.model.basedata.RolePowerId;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserRoleId;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.CachedObject;
import com.centit.support.common.ObjectException;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import com.focus.locode.plugin.ca.auth.ObtainAuthData;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ObtainAuthDataImpl
implements ObtainAuthData {
    @Value(value="${focus.vemic.api.url}")
    protected String vemicApiUrl;
    @Value(value="${focus.locode.topunit}")
    protected String topUnitId;
    @Autowired
    protected PlatformEnvironment platformEnvironment;
    private CachedObject<String> appSymbols = new CachedObject(this::obtainAppIds, 900L);

    private String obtainAppIds() {
        if (this.platformEnvironment == null) {
            return "testapp001,testapp1";
        }
        List osInfos = this.platformEnvironment.listOsInfos(this.topUnitId);
        if (osInfos == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (OsInfo os : osInfos) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(os.getOsId());
            ++i;
        }
        return stringBuilder.toString();
    }

    @Override
    public List<UserRole> getRoleByLoginUserNameAndAppSymbols(String loginUserName) {
        try {
            HttpExecutorContext context = HttpExecutorContext.create((CloseableHttpClient)HttpExecutor.createKeepSessionHttpsClient());
            String jsonString = HttpExecutor.simpleGet((HttpExecutorContext)context, (String)(this.vemicApiUrl + "getRoleByLoginUserNameAndAppSymbols"), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"loginUserName", loginUserName, "appSymbols", this.appSymbols.getCachedTarget()}));
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            if (!jsonObject.getBoolean("success").booleanValue()) {
                return null;
            }
            ArrayList<UserRole> userRoles = new ArrayList<UserRole>();
            JSONArray data = jsonObject.getJSONArray("data");
            if (data != null) {
                for (Object obj : data) {
                    if (!(obj instanceof JSONObject)) continue;
                    JSONObject roleData = (JSONObject)obj;
                    UserRole userRole = new UserRole(new UserRoleId(loginUserName, roleData.getString("roleSymbol")));
                    userRoles.add(userRole);
                }
            }
            return userRoles;
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new ObjectException(800, "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @Override
    public List<RoleInfo> getRolesByAppSymbols() {
        try {
            HttpExecutorContext context = HttpExecutorContext.create((CloseableHttpClient)HttpExecutor.createKeepSessionHttpsClient());
            String jsonString = HttpExecutor.simpleGet((HttpExecutorContext)context, (String)(this.vemicApiUrl + "getRolesByAppSymbols"), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"appSymbols", this.appSymbols.getCachedTarget()}));
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            if (!jsonObject.getBoolean("success").booleanValue()) {
                return null;
            }
            ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
            JSONArray data = jsonObject.getJSONArray("data");
            if (data != null) {
                for (Object obj : data) {
                    if (!(obj instanceof JSONObject)) continue;
                    JSONObject optData = (JSONObject)obj;
                    RoleInfo roleInfo = new RoleInfo();
                    roleInfo.setRoleCode(optData.getString("roleSymbol"));
                    roleInfo.setRoleName(optData.getString("roleName"));
                    roleInfo.setRoleDesc(optData.getString("roleDesc"));
                    roles.add(roleInfo);
                }
            }
            return roles;
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new ObjectException(800, "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @Override
    public List<OptMethod> getResourcesByAppSymbols() {
        try {
            HttpExecutorContext context = HttpExecutorContext.create((CloseableHttpClient)HttpExecutor.createKeepSessionHttpsClient());
            String jsonString = HttpExecutor.simpleGet((HttpExecutorContext)context, (String)(this.vemicApiUrl + "getResourcesByAppSymbols"), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"appSymbols", this.appSymbols.getCachedTarget()}));
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            if (!jsonObject.getBoolean("success").booleanValue()) {
                return null;
            }
            ArrayList<OptMethod> opts = new ArrayList<OptMethod>();
            JSONArray data = jsonObject.getJSONArray("data");
            if (data != null) {
                for (Object obj : data) {
                    if (!(obj instanceof JSONObject)) continue;
                    JSONObject optData = (JSONObject)obj;
                    OptMethod optInfo = new OptMethod();
                    optInfo.setOptCode(optData.getString("resourceSymbol"));
                    optInfo.setApiId(optData.getString("resourceSymbol"));
                    optInfo.setOptId(optData.getString("appSymbol"));
                    optInfo.setOptName(optData.getString("resourceName"));
                    opts.add(optInfo);
                }
            }
            return opts;
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new ObjectException(800, "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @Override
    public List<RolePower> getRoleResourceByAppSymbols() {
        try {
            HttpExecutorContext context = HttpExecutorContext.create((CloseableHttpClient)HttpExecutor.createKeepSessionHttpsClient());
            String jsonString = HttpExecutor.simpleGet((HttpExecutorContext)context, (String)(this.vemicApiUrl + "getRoleResourceByAppSymbols"), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"appSymbols", this.appSymbols.getCachedTarget()}));
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            if (!jsonObject.getBoolean("success").booleanValue()) {
                return null;
            }
            ArrayList<RolePower> rolePowers = new ArrayList<RolePower>();
            JSONArray data = jsonObject.getJSONArray("data");
            if (data != null) {
                for (Object obj : data) {
                    if (!(obj instanceof JSONObject)) continue;
                    JSONObject roleData = (JSONObject)obj;
                    RolePower rp = new RolePower();
                    rp.setId(new RolePowerId(roleData.getString("roleSymbol"), roleData.getString("resourceSymbol")));
                    rolePowers.add(rp);
                }
            }
            return rolePowers;
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new ObjectException(800, "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public void setVemicApiUrl(String vemicApiUrl) {
        this.vemicApiUrl = vemicApiUrl;
    }

    public void setTopUnitId(String topUnitId) {
        this.topUnitId = topUnitId;
    }
}

