/*
 * Decompiled with CFR 0.152.
 */
package com.focus.locode.plugin.ca.auth;

import com.centit.framework.model.basedata.RolePower;
import com.centit.framework.model.security.CentitSecurityConfig;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.framework.security.SystemSecurityMetadata;
import com.centit.support.common.CachedObject;
import com.focus.locode.plugin.ca.auth.ObtainAuthData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

public class FocusSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private static final String DDE_RUN = "/dde/run/";
    private static final int DDE_RUN_TAG_LENGTH = 9;
    private static final String DDE_RUN_DRAFT = "draft";
    private SystemSecurityMetadata systemSecurityMetadata = new SystemSecurityMetadata();
    private CachedObject<Map<String, List<ConfigAttribute>>> apiSecurityMetadata = new CachedObject(this::loadOptRoleMap, 900L);
    private ObtainAuthData obtainAuthData;

    public FocusSecurityMetadataSource(ObtainAuthData obtainAuthData) {
        this.obtainAuthData = obtainAuthData;
    }

    public Map<String, List<ConfigAttribute>> loadOptRoleMap() {
        List<RolePower> rolePowers = this.obtainAuthData.getRoleResourceByAppSymbols();
        if (rolePowers == null) {
            return null;
        }
        HashMap<String, List<ConfigAttribute>> optRoleMap = new HashMap<String, List<ConfigAttribute>>();
        for (RolePower rolePower : rolePowers) {
            ArrayList<CentitSecurityConfig> roles = (ArrayList<CentitSecurityConfig>)optRoleMap.get(rolePower.getOptCode());
            if (roles == null) {
                roles = new ArrayList<CentitSecurityConfig>();
                roles.add(this.dealRolePower(rolePower));
                optRoleMap.put(rolePower.getOptCode(), roles);
                continue;
            }
            roles.add(this.dealRolePower(rolePower));
        }
        for (Map.Entry entry : optRoleMap.entrySet()) {
            Collections.sort((List)entry.getValue(), Comparator.comparing(ConfigAttribute::getAttribute));
        }
        return optRoleMap;
    }

    private CentitSecurityConfig dealRolePower(RolePower rp) {
        if (SecurityContextUtils.PUBLIC_ROLE_CODE.equalsIgnoreCase(rp.getRoleCode())) {
            return new CentitSecurityConfig("R_" + StringUtils.trim((String)rp.getRoleCode()) + rp.getTopUnit());
        }
        if (SecurityContextUtils.ANONYMOUS_ROLE_CODE.equalsIgnoreCase(rp.getRoleCode())) {
            return new CentitSecurityConfig(SecurityContextUtils.SPRING_ANONYMOUS_ROLE_CODE);
        }
        return new CentitSecurityConfig("R_" + StringUtils.trim((String)rp.getRoleCode()));
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("\u5bf9\u4e0d\u8d77,\u76ee\u6807\u5bf9\u8c61\u4e0d\u662f\u7c7b\u578b");
        }
        FilterInvocation fi = (FilterInvocation)object;
        HttpServletRequest request = fi.getHttpRequest();
        String requestUrl = fi.getRequestUrl();
        String apiId = FocusSecurityMetadataSource.parseUrlToApi(requestUrl);
        if (StringUtils.isBlank((CharSequence)apiId)) {
            return this.systemSecurityMetadata.matchUrlToRole(requestUrl, request);
        }
        return (Collection)((Map)this.apiSecurityMetadata.getCachedTarget()).get(apiId);
    }

    public static String parseUrlToApi(String sUrl) {
        String apiId = "";
        int nPos = sUrl.indexOf(DDE_RUN);
        if (nPos > 0) {
            int beginPos = nPos + 9;
            int endPos = sUrl.indexOf(47, beginPos);
            if (endPos <= 0) {
                endPos = sUrl.indexOf(63, beginPos);
            }
            if (endPos <= 0) {
                endPos = sUrl.length();
            }
            if (DDE_RUN_DRAFT.equals(apiId = sUrl.substring(beginPos, endPos))) {
                return "";
            }
        }
        return apiId;
    }
}

