/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import com.centit.support.file.FileIOOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileType {
    public static final String OFFICE2003_FILE_HEAD = "D0CF11E0";
    public static final String OFFICE_XML_FILE_HEAD = "504B0304";
    protected static final Logger logger = LoggerFactory.getLogger(FileIOOpt.class);
    protected static final HashMap<String, String> mFileTypes = new HashMap<String, String>(50){
        {
            this.put("FFD8FF", "jpg");
            this.put("89504E47", "png");
            this.put("47494638", "gif");
            this.put("49492A00", "tif");
            this.put("424D", "bmp");
            this.put("41433130", "dwg");
            this.put("38425053", "psd");
            this.put("7B5C727466", "rtf");
            this.put("3C3F786D6C", "xml");
            this.put("68746D6C3E", "html");
            this.put("44656C69766572792D646174653A", "eml");
            this.put(FileType.OFFICE2003_FILE_HEAD, "office2003");
            this.put("5374616E64617264204A", "mdb");
            this.put("252150532D41646F6265", "ps");
            this.put("255044462D312E", "pdf");
            this.put(FileType.OFFICE_XML_FILE_HEAD, "officeX");
            this.put("52617221", "rar");
            this.put("57415645", "wav");
            this.put("41564920", "avi");
            this.put("2E524D46", "rm");
            this.put("000001BA", "mpg");
            this.put("000001B3", "mpg");
            this.put("6D6F6F76", "mov");
            this.put("3026B2758E66CF11", "asf");
            this.put("4D546864", "mid");
            this.put("1F8B08", "gz");
            this.put("6D6F7669", "csv");
            this.put("7B226461", "json");
        }
    };
    protected static final HashMap<String, String> extMimeTypeMap = new HashMap<String, String>(1200){
        {
            this.put("123", "application/vnd.lotus-1-2-3");
            this.put("323", "text/h323");
            this.put("3dml", "text/vnd.in3d.3dml");
            this.put("3g2", "video/3gpp2");
            this.put("3gp", "video/3gpp");
            this.put("7z", "application/x-7z-compressed");
            this.put("aab", "application/x-authorware-bin");
            this.put("aac", "audio/x-aac");
            this.put("aam", "application/x-authorware-map");
            this.put("aas", "application/x-authorware-seg");
            this.put("abw", "application/x-abiword");
            this.put("ac", "application/pkix-attr-cert");
            this.put("acc", "application/vnd.americandynamics.acc");
            this.put("ace", "application/x-ace-compressed");
            this.put("acu", "application/vnd.acucobol");
            this.put("acx", "application/internet-property-stream");
            this.put("adp", "audio/adpcm");
            this.put("aep", "application/vnd.audiograph");
            this.put("afp", "application/vnd.ibm.modcap");
            this.put("ahead", "application/vnd.ahead.space");
            this.put("ai", "application/postscript");
            this.put("aif", "audio/x-aiff");
            this.put("aifc", "audio/x-aiff");
            this.put("aiff", "audio/x-aiff");
            this.put("air", "application/vnd.adobe.air-application-installer-package+zip");
            this.put("ait", "application/vnd.dvb.ait");
            this.put("ami", "application/vnd.amiga.ami");
            this.put("apk", "application/vnd.android.package-archive");
            this.put("application", "application/x-ms-application");
            this.put("apr", "application/vnd.lotus-approach");
            this.put("asf", "video/x-ms-asf");
            this.put("aso", "application/vnd.accpac.simply.aso");
            this.put("asr", "video/x-ms-asf");
            this.put("asx", "video/x-ms-asf");
            this.put("atc", "application/vnd.acucorp");
            this.put("atom", "application/atom+xml");
            this.put("atomcat", "application/atomcat+xml");
            this.put("atomsvc", "application/atomsvc+xml");
            this.put("atx", "application/vnd.antix.game-component");
            this.put("au", "audio/basic");
            this.put("avi", "video/x-msvideo");
            this.put("aw", "application/applixware");
            this.put("axs", "application/olescript");
            this.put("azf", "application/vnd.airzip.filesecure.azf");
            this.put("azs", "application/vnd.airzip.filesecure.azs");
            this.put("azw", "application/vnd.amazon.ebook");
            this.put("bas", "text/plain");
            this.put("bcpio", "application/x-bcpio");
            this.put("bdf", "application/x-font-bdf");
            this.put("bdm", "application/vnd.syncml.dm+wbxml");
            this.put("bed", "application/vnd.realvnc.bed");
            this.put("bh2", "application/vnd.fujitsu.oasysprs");
            this.put("bin", "application/octet-stream");
            this.put("bmi", "application/vnd.bmi");
            this.put("bmp", "image/bmp");
            this.put("box", "application/vnd.previewsystems.box");
            this.put("btif", "image/prs.btif");
            this.put("bz", "application/x-bzip");
            this.put("bz2", "application/x-bzip2");
            this.put("c", "text/plain");
            this.put("c11amc", "application/vnd.cluetrust.cartomobile-config");
            this.put("c11amz", "application/vnd.cluetrust.cartomobile-config-pkg");
            this.put("c4g", "application/vnd.clonk.c4group");
            this.put("cab", "application/vnd.ms-cab-compressed");
            this.put("car", "application/vnd.curl.car");
            this.put("cat", "application/vnd.ms-pkiseccat");
            this.put("ccxml", "application/ccxml+xml,");
            this.put("cdbcmsg", "application/vnd.contact.cmsg");
            this.put("cdf", "application/x-cdf");
            this.put("cdkey", "application/vnd.mediastation.cdkey");
            this.put("cdmia", "application/cdmi-capability");
            this.put("cdmic", "application/cdmi-container");
            this.put("cdmid", "application/cdmi-domain");
            this.put("cdmio", "application/cdmi-object");
            this.put("cdmiq", "application/cdmi-queue");
            this.put("cdx", "chemical/x-cdx");
            this.put("cdxml", "application/vnd.chemdraw+xml");
            this.put("cdy", "application/vnd.cinderella");
            this.put("cer", "application/x-x509-ca-cert");
            this.put("cgm", "image/cgm");
            this.put("chat", "application/x-chat");
            this.put("chm", "application/vnd.ms-htmlhelp");
            this.put("chrt", "application/vnd.kde.kchart");
            this.put("cif", "chemical/x-cif");
            this.put("cii", "application/vnd.anser-web-certificate-issue-initiation");
            this.put("cil", "application/vnd.ms-artgalry");
            this.put("cla", "application/vnd.claymore");
            this.put("class", "application/java-vm");
            this.put("clkk", "application/vnd.crick.clicker.keyboard");
            this.put("clkp", "application/vnd.crick.clicker.palette");
            this.put("clkt", "application/vnd.crick.clicker.template");
            this.put("clkw", "application/vnd.crick.clicker.wordbank");
            this.put("clkx", "application/vnd.crick.clicker");
            this.put("clp", "application/x-msclip");
            this.put("cmc", "application/vnd.cosmocaller");
            this.put("cmdf", "chemical/x-cmdf");
            this.put("cml", "chemical/x-cml");
            this.put("cmp", "application/vnd.yellowriver-custom-menu");
            this.put("cmx", "image/x-cmx");
            this.put("cod", "image/cis-cod");
            this.put("cpio", "application/x-cpio");
            this.put("cpt", "application/mac-compactpro");
            this.put("crd", "application/x-mscardfile");
            this.put("crl", "application/pkix-crl");
            this.put("crt", "application/x-x509-ca-cert");
            this.put("cryptonote", "application/vnd.rig.cryptonote");
            this.put("csh", "application/x-csh");
            this.put("csml", "chemical/x-csml");
            this.put("csp", "application/vnd.commonspace");
            this.put("css", "text/css");
            this.put("csv", "text/csv");
            this.put("cu", "application/cu-seeme");
            this.put("curl", "text/vnd.curl");
            this.put("cww", "application/prs.cww");
            this.put("dae", "model/vnd.collada+xml");
            this.put("daf", "application/vnd.mobius.daf");
            this.put("davmount", "application/davmount+xml");
            this.put("dcr", "application/x-director");
            this.put("dcurl", "text/vnd.curl.dcurl");
            this.put("dd2", "application/vnd.oma.dd2+xml");
            this.put("ddd", "application/vnd.fujixerox.ddd");
            this.put("deb", "application/x-debian-package");
            this.put("der", "application/x-x509-ca-cert");
            this.put("dfac", "application/vnd.dreamfactory");
            this.put("dir", "application/x-director");
            this.put("dis", "application/vnd.mobius.dis");
            this.put("djvu", "image/vnd.djvu");
            this.put("dll", "application/x-msdownload");
            this.put("dms", "application/octet-stream");
            this.put("dna", "application/vnd.dna");
            this.put("doc", "application/msword");
            this.put("docm", "application/vnd.ms-word.document.macroenabled.12");
            this.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            this.put("dot", "application/msword");
            this.put("dotm", "application/vnd.ms-word.template.macroenabled.12");
            this.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
            this.put("dp", "application/vnd.osgi.dp");
            this.put("dpg", "application/vnd.dpgraph");
            this.put("dra", "audio/vnd.dra");
            this.put("dsc", "text/prs.lines.tag");
            this.put("dssc", "application/dssc+der");
            this.put("dtb", "application/x-dtbook+xml");
            this.put("dtd", "application/xml-dtd");
            this.put("dts", "audio/vnd.dts");
            this.put("dtshd", "audio/vnd.dts.hd");
            this.put("dvi", "application/x-dvi");
            this.put("dwf", "model/vnd.dwf");
            this.put("dwg", "image/vnd.dwg");
            this.put("dxf", "image/vnd.dxf");
            this.put("dxp", "application/vnd.spotfire.dxp");
            this.put("dxr", "application/x-director");
            this.put("ecelp4800", "audio/vnd.nuera.ecelp4800");
            this.put("ecelp7470", "audio/vnd.nuera.ecelp7470");
            this.put("ecelp9600", "audio/vnd.nuera.ecelp9600");
            this.put("edm", "application/vnd.novadigm.edm");
            this.put("edx", "application/vnd.novadigm.edx");
            this.put("efif", "application/vnd.picsel");
            this.put("ei6", "application/vnd.pg.osasli");
            this.put("eml", "message/rfc822");
            this.put("emma", "application/emma+xml");
            this.put("eol", "audio/vnd.digital-winds");
            this.put("eot", "application/vnd.ms-fontobject");
            this.put("eps", "application/postscript");
            this.put("epub", "application/epub+zip");
            this.put("es", "application/ecmascript");
            this.put("es3", "application/vnd.eszigno3+xml");
            this.put("esf", "application/vnd.epson.esf");
            this.put("etx", "text/x-setext");
            this.put("evy", "application/envoy");
            this.put("exe", "application/x-msdownload");
            this.put("exi", "application/exi");
            this.put("ext", "application/vnd.novadigm.ext");
            this.put("ez2", "application/vnd.ezpix-album");
            this.put("ez3", "application/vnd.ezpix-package");
            this.put("f", "text/x-fortran");
            this.put("f4v", "video/x-f4v");
            this.put("fbs", "image/vnd.fastbidsheet");
            this.put("fcs", "application/vnd.isac.fcs");
            this.put("fdf", "application/vnd.fdf");
            this.put("fe_launch", "application/vnd.denovo.fcselayout-link");
            this.put("fg5", "application/vnd.fujitsu.oasysgp");
            this.put("fh", "image/x-freehand");
            this.put("fif", "application/fractals");
            this.put("fig", "application/x-xfig");
            this.put("fli", "video/x-fli");
            this.put("flo", "application/vnd.micrografx.flo");
            this.put("flr", "x-world/x-vrml");
            this.put("flv", "video/x-flv");
            this.put("flw", "application/vnd.kde.kivio");
            this.put("flx", "text/vnd.fmi.flexstor");
            this.put("fly", "text/vnd.fly");
            this.put("fm", "application/vnd.framemaker");
            this.put("fnc", "application/vnd.frogans.fnc");
            this.put("fpx", "image/vnd.fpx");
            this.put("fsc", "application/vnd.fsc.weblaunch");
            this.put("fst", "image/vnd.fst");
            this.put("ftc", "application/vnd.fluxtime.clip");
            this.put("fti", "application/vnd.anser-web-funds-transfer-initiation");
            this.put("fvt", "video/vnd.fvt");
            this.put("fxp", "application/vnd.adobe.fxp");
            this.put("fzs", "application/vnd.fuzzysheet");
            this.put("g2w", "application/vnd.geoplan");
            this.put("g3", "image/g3fax");
            this.put("g3w", "application/vnd.geospace");
            this.put("gac", "application/vnd.groove-account");
            this.put("gdl", "model/vnd.gdl");
            this.put("geo", "application/vnd.dynageo");
            this.put("gex", "application/vnd.geometry-explorer");
            this.put("ggb", "application/vnd.geogebra.file");
            this.put("ggt", "application/vnd.geogebra.tool");
            this.put("ghf", "application/vnd.groove-help");
            this.put("gif", "image/gif");
            this.put("gim", "application/vnd.groove-identity-message");
            this.put("gmx", "application/vnd.gmx");
            this.put("gnumeric", "application/x-gnumeric");
            this.put("gph", "application/vnd.flographit");
            this.put("gqf", "application/vnd.grafeq");
            this.put("gram", "application/srgs");
            this.put("grv", "application/vnd.groove-injector");
            this.put("grxml", "application/srgs+xml");
            this.put("gsf", "application/x-font-ghostscript");
            this.put("gtar", "application/x-gtar");
            this.put("gtm", "application/vnd.groove-tool-message");
            this.put("gtw", "model/vnd.gtw");
            this.put("gv", "text/vnd.graphviz");
            this.put("gxt", "application/vnd.geonext");
            this.put("gz", "application/x-gzip");
            this.put("h", "text/plain");
            this.put("h261", "video/h261");
            this.put("h263", "video/h263");
            this.put("h264", "video/h264");
            this.put("hal", "application/vnd.hal+xml");
            this.put("hbci", "application/vnd.hbci");
            this.put("hdf", "application/x-hdf");
            this.put("hlp", "application/winhlp");
            this.put("hpgl", "application/vnd.hp-hpgl");
            this.put("hpid", "application/vnd.hp-hpid");
            this.put("hps", "application/vnd.hp-hps");
            this.put("hqx", "application/mac-binhex40");
            this.put("hta", "application/hta");
            this.put("htc", "text/x-component");
            this.put("htke", "application/vnd.kenameaapp");
            this.put("htm", "text/html");
            this.put("html", "text/html");
            this.put("htt", "text/webviewhtml");
            this.put("hvd", "application/vnd.yamaha.hv-dic");
            this.put("hvp", "application/vnd.yamaha.hv-voice");
            this.put("hvs", "application/vnd.yamaha.hv-script");
            this.put("i2g", "application/vnd.intergeo");
            this.put("icc", "application/vnd.iccprofile");
            this.put("ice", "x-conference/x-cooltalk");
            this.put("ico", "image/x-icon");
            this.put("ics", "text/calendar");
            this.put("ief", "image/ief");
            this.put("ifm", "application/vnd.shana.informed.formdata");
            this.put("igl", "application/vnd.igloader");
            this.put("igm", "application/vnd.insors.igm");
            this.put("igs", "model/iges");
            this.put("igx", "application/vnd.micrografx.igx");
            this.put("iif", "application/vnd.shana.informed.interchange");
            this.put("iii", "application/x-iphone");
            this.put("imp", "application/vnd.accpac.simply.imp");
            this.put("ims", "application/vnd.ms-ims");
            this.put("ins", "application/x-internet-signup");
            this.put("ipfix", "application/ipfix");
            this.put("ipk", "application/vnd.shana.informed.package");
            this.put("irm", "application/vnd.ibm.rights-management");
            this.put("irp", "application/vnd.irepository.package+xml");
            this.put("isp", "application/x-internet-signup");
            this.put("itp", "application/vnd.shana.informed.formtemplate");
            this.put("ivp", "application/vnd.immervision-ivp");
            this.put("ivu", "application/vnd.immervision-ivu");
            this.put("jad", "text/vnd.sun.j2me.app-descriptor");
            this.put("jam", "application/vnd.jam");
            this.put("jar", "application/java-archive");
            this.put("java", "text/x-java-source,java");
            this.put("jfif", "image/pipeg");
            this.put("jisp", "application/vnd.jisp");
            this.put("jlt", "application/vnd.hp-jlyt");
            this.put("jnlp", "application/x-java-jnlp-file");
            this.put("joda", "application/vnd.joost.joda-archive");
            this.put("jpe", "image/jpeg");
            this.put("jpeg", "image/jpeg");
            this.put("jpg", "image/jpeg");
            this.put("jpgv", "video/jpeg");
            this.put("jpm", "video/jpm");
            this.put("js", "application/javascript");
            this.put("json", "application/json");
            this.put("karbon", "application/vnd.kde.karbon");
            this.put("kfo", "application/vnd.kde.kformula");
            this.put("kia", "application/vnd.kidspiration");
            this.put("kml", "application/vnd.google-earth.kml+xml");
            this.put("kmz", "application/vnd.google-earth.kmz");
            this.put("kne", "application/vnd.kinar");
            this.put("kon", "application/vnd.kde.kontour");
            this.put("kpr", "application/vnd.kde.kpresenter");
            this.put("ksp", "application/vnd.kde.kspread");
            this.put("ktx", "image/ktx");
            this.put("ktz", "application/vnd.kahootz");
            this.put("kwd", "application/vnd.kde.kword");
            this.put("lasxml", "application/vnd.las.las+xml");
            this.put("latex", "application/x-latex");
            this.put("lbd", "application/vnd.llamagraphics.life-balance.desktop");
            this.put("lbe", "application/vnd.llamagraphics.life-balance.exchange+xml");
            this.put("les", "application/vnd.hhe.lesson-player");
            this.put("lha", "application/octet-stream");
            this.put("link66", "application/vnd.route66.link66+xml");
            this.put("lrm", "application/vnd.ms-lrm");
            this.put("lsf", "video/x-la-asf");
            this.put("lsx", "video/x-la-asf");
            this.put("ltf", "application/vnd.frogans.ltf");
            this.put("lvp", "audio/vnd.lucent.voice");
            this.put("lwp", "application/vnd.lotus-wordpro");
            this.put("lzh", "application/octet-stream");
            this.put("m13", "application/x-msmediaview");
            this.put("m14", "application/x-msmediaview");
            this.put("m21", "application/mp21");
            this.put("m3u", "audio/x-mpegurl");
            this.put("m3u8", "application/vnd.apple.mpegurl");
            this.put("m4v", "video/x-m4v");
            this.put("ma", "application/mathematica");
            this.put("mads", "application/mads+xml");
            this.put("mag", "application/vnd.ecowin.chart");
            this.put("man", "application/x-troff-man");
            this.put("mathml", "application/mathml+xml");
            this.put("mbk", "application/vnd.mobius.mbk");
            this.put("mbox", "application/mbox");
            this.put("mc1", "application/vnd.medcalcdata");
            this.put("mcd", "application/vnd.mcd");
            this.put("mcurl", "text/vnd.curl.mcurl");
            this.put("mdb", "application/x-msaccess");
            this.put("mdi", "image/vnd.ms-modi");
            this.put("me", "application/x-troff-me");
            this.put("meta4", "application/metalink4+xml");
            this.put("mets", "application/mets+xml");
            this.put("mfm", "application/vnd.mfmp");
            this.put("mgp", "application/vnd.osgeo.mapguide.package");
            this.put("mgz", "application/vnd.proteus.magazine");
            this.put("mht", "message/rfc822");
            this.put("mhtml", "message/rfc822");
            this.put("mid", "audio/mid");
            this.put("mif", "application/vnd.mif");
            this.put("mj2", "video/mj2");
            this.put("mlp", "application/vnd.dolby.mlp");
            this.put("mmd", "application/vnd.chipnuts.karaoke-mmd");
            this.put("mmf", "application/vnd.smaf");
            this.put("mmr", "image/vnd.fujixerox.edmics-mmr");
            this.put("mny", "application/x-msmoney");
            this.put("mods", "application/mods+xml");
            this.put("mov", "video/quicktime");
            this.put("movie", "video/x-sgi-movie");
            this.put("mp2", "video/mpeg");
            this.put("mp3", "audio/mpeg");
            this.put("mp4", "video/mp4");
            this.put("mp4a", "audio/mp4");
            this.put("mpa", "video/mpeg");
            this.put("mpc", "application/vnd.mophun.certificate");
            this.put("mpe", "video/mpeg");
            this.put("mpeg", "video/mpeg");
            this.put("mpg", "video/mpeg");
            this.put("mpga", "audio/mpeg");
            this.put("mpkg", "application/vnd.apple.installer+xml");
            this.put("mpm", "application/vnd.blueice.multipass");
            this.put("mpn", "application/vnd.mophun.application");
            this.put("mpp", "application/vnd.ms-project");
            this.put("mpv2", "video/mpeg");
            this.put("mpy", "application/vnd.ibm.minipay");
            this.put("mqy", "application/vnd.mobius.mqy");
            this.put("mrc", "application/marc");
            this.put("mrcx", "application/marcxml+xml");
            this.put("ms", "application/x-troff-ms");
            this.put("mscml", "application/mediaservercontrol+xml");
            this.put("mseq", "application/vnd.mseq");
            this.put("msf", "application/vnd.epson.msf");
            this.put("msh", "model/mesh");
            this.put("msl", "application/vnd.mobius.msl");
            this.put("msty", "application/vnd.muvee.style");
            this.put("mts", "model/vnd.mts");
            this.put("mus", "application/vnd.musician");
            this.put("musicxml", "application/vnd.recordare.musicxml+xml");
            this.put("mvb", "application/x-msmediaview");
            this.put("mwf", "application/vnd.mfer");
            this.put("mxf", "application/mxf");
            this.put("mxl", "application/vnd.recordare.musicxml");
            this.put("mxml", "application/xv+xml");
            this.put("mxs", "application/vnd.triscape.mxs");
            this.put("mxu", "video/vnd.mpegurl");
            this.put("n3", "text/n3");
            this.put("nbp", "application/vnd.wolfram.player");
            this.put("nc", "application/x-netcdf");
            this.put("ncx", "application/x-dtbncx+xml");
            this.put("n-gage", "application/vnd.nokia.n-gage.symbian.install");
            this.put("ngdat", "application/vnd.nokia.n-gage.data");
            this.put("nlu", "application/vnd.neurolanguage.nlu");
            this.put("nml", "application/vnd.enliven");
            this.put("nnd", "application/vnd.noblenet-directory");
            this.put("nns", "application/vnd.noblenet-sealer");
            this.put("nnw", "application/vnd.noblenet-web");
            this.put("npx", "image/vnd.net-fpx");
            this.put("nsf", "application/vnd.lotus-notes");
            this.put("nws", "message/rfc822");
            this.put("oa2", "application/vnd.fujitsu.oasys2");
            this.put("oa3", "application/vnd.fujitsu.oasys3");
            this.put("oas", "application/vnd.fujitsu.oasys");
            this.put("obd", "application/x-msbinder");
            this.put("oda", "application/oda");
            this.put("odb", "application/vnd.oasis.opendocument.database");
            this.put("odc", "application/vnd.oasis.opendocument.chart");
            this.put("odf", "application/vnd.oasis.opendocument.formula");
            this.put("odft", "application/vnd.oasis.opendocument.formula-template");
            this.put("odg", "application/vnd.oasis.opendocument.graphics");
            this.put("odi", "application/vnd.oasis.opendocument.image");
            this.put("odm", "application/vnd.oasis.opendocument.text-master");
            this.put("odp", "application/vnd.oasis.opendocument.presentation");
            this.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
            this.put("odt", "application/vnd.oasis.opendocument.text");
            this.put("oga", "audio/ogg");
            this.put("ogv", "video/ogg");
            this.put("ogx", "application/ogg");
            this.put("onetoc", "application/onenote");
            this.put("opf", "application/oebps-package+xml");
            this.put("org", "application/vnd.lotus-organizer");
            this.put("osf", "application/vnd.yamaha.openscoreformat");
            this.put("osfpvg", "application/vnd.yamaha.openscoreformat.osfpvg+xml");
            this.put("otc", "application/vnd.oasis.opendocument.chart-template");
            this.put("otf", "application/x-font-otf");
            this.put("otg", "application/vnd.oasis.opendocument.graphics-template");
            this.put("oth", "application/vnd.oasis.opendocument.text-web");
            this.put("oti", "application/vnd.oasis.opendocument.image-template");
            this.put("otp", "application/vnd.oasis.opendocument.presentation-template");
            this.put("ots", "application/vnd.oasis.opendocument.spreadsheet-template");
            this.put("ott", "application/vnd.oasis.opendocument.text-template");
            this.put("oxt", "application/vnd.openofficeorg.extension");
            this.put("p", "text/x-pascal");
            this.put("p10", "application/pkcs10");
            this.put("p12", "application/x-pkcs12");
            this.put("p7b", "application/x-pkcs7-certificates");
            this.put("p7c", "application/x-pkcs7-mime");
            this.put("p7m", "application/x-pkcs7-mime");
            this.put("p7r", "application/x-pkcs7-certreqresp");
            this.put("p7s", "application/x-pkcs7-signature");
            this.put("p8", "application/pkcs8");
            this.put("par", "text/plain-bas");
            this.put("paw", "application/vnd.pawaafile");
            this.put("pbd", "application/vnd.powerbuilder6");
            this.put("pbm", "image/x-portable-bitmap");
            this.put("pcf", "application/x-font-pcf");
            this.put("pcl", "application/vnd.hp-pcl");
            this.put("pclxl", "application/vnd.hp-pclxl");
            this.put("pcurl", "application/vnd.curl.pcurl");
            this.put("pcx", "image/x-pcx");
            this.put("pdb", "application/vnd.palm");
            this.put("pdf", "application/pdf");
            this.put("pfa", "application/x-font-type1");
            this.put("pfr", "application/font-tdpfr");
            this.put("pfx", "application/x-pkcs12");
            this.put("pgm", "image/x-portable-graymap");
            this.put("pgn", "application/x-chess-pgn");
            this.put("pgp", "application/pgp-signature");
            this.put("pic", "image/x-pict");
            this.put("pjpeg", "image/pjpeg");
            this.put("pki", "application/pkixcmp");
            this.put("pkipath", "application/pkix-pkipath");
            this.put("pko", "application/ynd.ms-pkipko");
            this.put("plb", "application/vnd.3gpp.pic-bw-large");
            this.put("plc", "application/vnd.mobius.plc");
            this.put("plf", "application/vnd.pocketlearn");
            this.put("pls", "application/pls+xml");
            this.put("pma", "application/x-perfmon");
            this.put("pmc", "application/x-perfmon");
            this.put("pml", "application/x-perfmon");
            this.put("pmr", "application/x-perfmon");
            this.put("pmw", "application/x-perfmon");
            this.put("png", "image/png");
            this.put("pnm", "image/x-portable-anymap");
            this.put("portpkg", "application/vnd.macports.portpkg");
            this.put("pot,", "application/vnd.ms-powerpoint");
            this.put("potm", "application/vnd.ms-powerpoint.template.macroenabled.12");
            this.put("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
            this.put("ppam", "application/vnd.ms-powerpoint.addin.macroenabled.12");
            this.put("ppd", "application/vnd.cups-ppd");
            this.put("ppm", "image/x-portable-pixmap");
            this.put("pps", "application/vnd.ms-powerpoint");
            this.put("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12");
            this.put("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
            this.put("ppt", "application/vnd.ms-powerpoint");
            this.put("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12");
            this.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
            this.put("prc", "application/x-mobipocket-ebook");
            this.put("pre", "application/vnd.lotus-freelance");
            this.put("prf", "application/pics-rules");
            this.put("ps", "application/postscript");
            this.put("psb", "application/vnd.3gpp.pic-bw-small");
            this.put("psd", "image/vnd.adobe.photoshop");
            this.put("psf", "application/x-font-linux-psf");
            this.put("pskcxml", "application/pskc+xml");
            this.put("ptid", "application/vnd.pvi.ptid1");
            this.put("pub", "application/x-mspublisher");
            this.put("pvb", "application/vnd.3gpp.pic-bw-var");
            this.put("pwn", "application/vnd.3m.post-it-notes");
            this.put("pya", "audio/vnd.ms-playready.media.pya");
            this.put("pyv", "video/vnd.ms-playready.media.pyv");
            this.put("qam", "application/vnd.epson.quickanime");
            this.put("qbo", "application/vnd.intu.qbo");
            this.put("qfx", "application/vnd.intu.qfx");
            this.put("qps", "application/vnd.publishare-delta-tree");
            this.put("qt", "video/quicktime");
            this.put("qxd", "application/vnd.quark.quarkxpress");
            this.put("ra", "audio/x-pn-realaudio");
            this.put("ram", "audio/x-pn-realaudio");
            this.put("rar", "application/x-rar-compressed");
            this.put("ras", "image/x-cmu-raster");
            this.put("rcprofile", "application/vnd.ipunplugged.rcprofile");
            this.put("rdf", "application/rdf+xml");
            this.put("rdz", "application/vnd.data-vision.rdz");
            this.put("rep", "application/vnd.businessobjects");
            this.put("res", "application/x-dtbresource+xml");
            this.put("rgb", "image/x-rgb");
            this.put("rif", "application/reginfo+xml");
            this.put("rip", "audio/vnd.rip");
            this.put("rl", "application/resource-lists+xml");
            this.put("rlc", "image/vnd.fujixerox.edmics-rlc");
            this.put("rld", "application/resource-lists-diff+xml");
            this.put("rm", "application/vnd.rn-realmedia");
            this.put("rmi", "audio/mid");
            this.put("rmp", "audio/x-pn-realaudio-plugin");
            this.put("rms", "application/vnd.jcp.javame.midlet-rms");
            this.put("rnc", "application/relax-ng-compact-syntax");
            this.put("roff", "application/x-troff");
            this.put("rp9", "application/vnd.cloanto.rp9");
            this.put("rpss", "application/vnd.nokia.radio-presets");
            this.put("rpst", "application/vnd.nokia.radio-preset");
            this.put("rq", "application/sparql-query");
            this.put("rs", "application/rls-services+xml");
            this.put("rsd", "application/rsd+xml");
            this.put("rss", "application/rss+xml");
            this.put("rtf", "application/rtf");
            this.put("rtx", "text/richtext");
            this.put("s", "text/x-asm");
            this.put("saf", "application/vnd.yamaha.smaf-audio");
            this.put("sbml", "application/sbml+xml");
            this.put("sc", "application/vnd.ibm.secure-container");
            this.put("scd", "application/x-msschedule");
            this.put("scm", "application/vnd.lotus-screencam");
            this.put("scq", "application/scvp-cv-request");
            this.put("scs", "application/scvp-cv-response");
            this.put("sct", "text/scriptlet");
            this.put("scurl", "text/vnd.curl.scurl");
            this.put("sda", "application/vnd.stardivision.draw");
            this.put("sdc", "application/vnd.stardivision.calc");
            this.put("sdd", "application/vnd.stardivision.impress");
            this.put("sdkm", "application/vnd.solent.sdkm+xml");
            this.put("sdp", "application/sdp");
            this.put("sdw", "application/vnd.stardivision.writer");
            this.put("see", "application/vnd.seemail");
            this.put("seed", "application/vnd.fdsn.seed");
            this.put("sema", "application/vnd.sema");
            this.put("semd", "application/vnd.semd");
            this.put("semf", "application/vnd.semf");
            this.put("ser", "application/java-serialized-object");
            this.put("setpay", "application/set-payment-initiation");
            this.put("setreg", "application/set-registration-initiation");
            this.put("sfd-hdstx", "application/vnd.hydrostatix.sof-data");
            this.put("sfs", "application/vnd.spotfire.sfs");
            this.put("sgl", "application/vnd.stardivision.writer-global");
            this.put("sgml", "text/sgml");
            this.put("sh", "application/x-sh");
            this.put("shar", "application/x-shar");
            this.put("shf", "application/shf+xml");
            this.put("sis", "application/vnd.symbian.install");
            this.put("sit", "application/x-stuffit");
            this.put("sitx", "application/x-stuffitx");
            this.put("skp", "application/vnd.koan");
            this.put("sldm", "application/vnd.ms-powerpoint.slide.macroenabled.12");
            this.put("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
            this.put("slt", "application/vnd.epson.salt");
            this.put("sm", "application/vnd.stepmania.stepchart");
            this.put("smf", "application/vnd.stardivision.math");
            this.put("smi", "application/smil+xml");
            this.put("snd", "audio/basic");
            this.put("snf", "application/x-font-snf");
            this.put("spc", "application/x-pkcs7-certificates");
            this.put("spf", "application/vnd.yamaha.smaf-phrase");
            this.put("spl", "application/futuresplash");
            this.put("spl", "application/x-futuresplash");
            this.put("spot", "text/vnd.in3d.spot");
            this.put("spp", "application/scvp-vp-response");
            this.put("spq", "application/scvp-vp-request");
            this.put("src", "application/x-wais-source");
            this.put("sru", "application/sru+xml");
            this.put("srx", "application/sparql-results+xml");
            this.put("sse", "application/vnd.kodak-descriptor");
            this.put("ssf", "application/vnd.epson.ssf");
            this.put("ssml", "application/ssml+xml");
            this.put("sst", "application/vnd.ms-pkicertstore");
            this.put("st", "application/vnd.sailingtracker.track");
            this.put("stc", "application/vnd.sun.xml.calc.template");
            this.put("std", "application/vnd.sun.xml.draw.template");
            this.put("stf", "application/vnd.wt.stf");
            this.put("sti", "application/vnd.sun.xml.impress.template");
            this.put("stk", "application/hyperstudio");
            this.put("stl", "application/vnd.ms-pkistl");
            this.put("stl", "application/vnd.ms-pki.stl");
            this.put("stm", "text/html");
            this.put("str", "application/vnd.pg.format");
            this.put("stw", "application/vnd.sun.xml.writer.template");
            this.put("sub", "image/vnd.dvb.subtitle");
            this.put("sus", "application/vnd.sus-calendar");
            this.put("sv4cpio", "application/x-sv4cpio");
            this.put("sv4crc", "application/x-sv4crc");
            this.put("svc", "application/vnd.dvb.service");
            this.put("svd", "application/vnd.svd");
            this.put("svg", "image/svg+xml");
            this.put("swf", "application/x-shockwave-flash");
            this.put("swi", "application/vnd.aristanetworks.swi");
            this.put("sxc", "application/vnd.sun.xml.calc");
            this.put("sxd", "application/vnd.sun.xml.draw");
            this.put("sxg", "application/vnd.sun.xml.writer.global");
            this.put("sxi", "application/vnd.sun.xml.impress");
            this.put("sxm", "application/vnd.sun.xml.math");
            this.put("sxw", "application/vnd.sun.xml.writer");
            this.put("t", "text/troff");
            this.put("tao", "application/vnd.tao.intent-module-archive");
            this.put("tar", "application/x-tar");
            this.put("tcap", "application/vnd.3gpp2.tcap");
            this.put("tcl", "application/x-tcl");
            this.put("teacher", "application/vnd.smart.teacher");
            this.put("tei", "application/tei+xml");
            this.put("tex", "application/x-tex");
            this.put("texi", "application/x-texinfo");
            this.put("texinfo", "application/x-texinfo");
            this.put("tfi", "application/thraud+xml");
            this.put("tfm", "application/x-tex-tfm");
            this.put("tgz", "application/x-compressed");
            this.put("thmx", "application/vnd.ms-officetheme");
            this.put("tif", "image/tiff");
            this.put("tiff", "image/tiff");
            this.put("tmo", "application/vnd.tmobile-livetv");
            this.put("torrent", "application/x-bittorrent");
            this.put("tpl", "application/vnd.groove-tool-template");
            this.put("tpt", "application/vnd.trid.tpt");
            this.put("tr", "application/x-troff");
            this.put("tra", "application/vnd.trueapp");
            this.put("trm", "application/x-msterminal");
            this.put("tsd", "application/timestamped-data");
            this.put("tsv", "text/tab-separated-values");
            this.put("ttf", "application/x-font-ttf");
            this.put("ttl", "text/turtle");
            this.put("twd", "application/vnd.simtech-mindmapper");
            this.put("txd", "application/vnd.genomatix.tuxedo");
            this.put("txf", "application/vnd.mobius.txf");
            this.put("txt", "text/plain");
            this.put("ufd", "application/vnd.ufdl");
            this.put("uls", "text/iuls");
            this.put("umj", "application/vnd.umajin");
            this.put("unityweb", "application/vnd.unity");
            this.put("uoml", "application/vnd.uoml+xml");
            this.put("uri", "text/uri-list");
            this.put("ustar", "application/x-ustar");
            this.put("utz", "application/vnd.uiq.theme");
            this.put("uu", "text/x-uuencode");
            this.put("uva", "audio/vnd.dece.audio");
            this.put("uvh", "video/vnd.dece.hd");
            this.put("uvi", "image/vnd.dece.graphic");
            this.put("uvm", "video/vnd.dece.mobile");
            this.put("uvp", "video/vnd.dece.pd");
            this.put("uvs", "video/vnd.dece.sd");
            this.put("uvu", "video/vnd.uvvu.mp4");
            this.put("uvv", "video/vnd.dece.video");
            this.put("vcd", "application/x-cdlink");
            this.put("vcf", "text/x-vcard");
            this.put("vcg", "application/vnd.groove-vcard");
            this.put("vcs", "text/x-vcalendar");
            this.put("vcx", "application/vnd.vcx");
            this.put("vis", "application/vnd.visionary");
            this.put("viv", "video/vnd.vivo");
            this.put("vrml", "x-world/x-vrml");
            this.put("vsd", "application/vnd.visio");
            this.put("vsdx", "application/vnd.visio2013");
            this.put("vsf", "application/vnd.vsf");
            this.put("vtu", "model/vnd.vtu");
            this.put("vxml", "application/voicexml+xml");
            this.put("wad", "application/x-doom");
            this.put("wav", "audio/x-wav");
            this.put("wax", "audio/x-ms-wax");
            this.put("wbmp", "image/vnd.wap.wbmp");
            this.put("wbs", "application/vnd.criticaltools.wbs+xml");
            this.put("wbxml", "application/vnd.wap.wbxml");
            this.put("wcm", "application/vnd.ms-works");
            this.put("wdb", "application/vnd.ms-works");
            this.put("weba", "audio/webm");
            this.put("webm", "video/webm");
            this.put("webp", "image/webp");
            this.put("wg", "application/vnd.pmi.widget");
            this.put("wgt", "application/widget");
            this.put("wks", "application/vnd.ms-works");
            this.put("wm", "video/x-ms-wm");
            this.put("wma", "audio/x-ms-wma");
            this.put("wmd", "application/x-ms-wmd");
            this.put("wmf", "application/x-msmetafile");
            this.put("wml", "text/vnd.wap.wml");
            this.put("wmlc", "application/vnd.wap.wmlc");
            this.put("wmls", "text/vnd.wap.wmlscript");
            this.put("wmlsc", "application/vnd.wap.wmlscriptc");
            this.put("wmv", "video/x-ms-wmv");
            this.put("wmx", "video/x-ms-wmx");
            this.put("wmz", "application/x-ms-wmz");
            this.put("woff", "application/x-font-woff");
            this.put("wpd", "application/vnd.wordperfect");
            this.put("wpl", "application/vnd.ms-wpl");
            this.put("wps", "application/vnd.ms-works");
            this.put("wqd", "application/vnd.wqd");
            this.put("wri", "application/x-mswrite");
            this.put("wrl", "x-world/x-vrml");
            this.put("wrl", "model/vrml");
            this.put("wrz", "x-world/x-vrml");
            this.put("wsdl", "application/wsdl+xml");
            this.put("wspolicy", "application/wspolicy+xml");
            this.put("wtb", "application/vnd.webturbo");
            this.put("wvx", "video/x-ms-wvx");
            this.put("x3d", "application/vnd.hzn-3d-crossword");
            this.put("xaf", "x-world/x-vrml");
            this.put("xap", "application/x-silverlight-app");
            this.put("xar", "application/vnd.xara");
            this.put("xbap", "application/x-ms-xbap");
            this.put("xbd", "application/vnd.fujixerox.docuworks.binder");
            this.put("xbm", "image/x-xbitmap");
            this.put("xdf", "application/xcap-diff+xml");
            this.put("xdm", "application/vnd.syncml.dm+xml");
            this.put("xdp", "application/vnd.adobe.xdp+xml");
            this.put("xdssc", "application/dssc+xml");
            this.put("xdw", "application/vnd.fujixerox.docuworks");
            this.put("xenc", "application/xenc+xml");
            this.put("xer", "application/patch-ops-error+xml");
            this.put("xfdf", "application/vnd.adobe.xfdf");
            this.put("xfdl", "application/vnd.xfdl");
            this.put("xhtml", "application/xhtml+xml");
            this.put("xif", "image/vnd.xiff");
            this.put("xla", "application/vnd.ms-excel");
            this.put("xlam", "application/vnd.ms-excel.addin.macroenabled.12");
            this.put("xlc", "application/vnd.ms-excel");
            this.put("xlm", "application/vnd.ms-excel");
            this.put("xls", "application/vnd.ms-excel");
            this.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
            this.put("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12");
            this.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.put("xlt", "application/vnd.ms-excel");
            this.put("xltm", "application/vnd.ms-excel.template.macroenabled.12");
            this.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
            this.put("xlw", "application/vnd.ms-excel");
            this.put("xml", "application/xml");
            this.put("xo", "application/vnd.olpc-sugar");
            this.put("xof", "x-world/x-vrml");
            this.put("xop", "application/xop+xml");
            this.put("xpi", "application/x-xpinstall");
            this.put("xpm", "image/x-xpixmap");
            this.put("xpr", "application/vnd.is-xpr");
            this.put("xps", "application/vnd.ms-xpsdocument");
            this.put("xpw", "application/vnd.intercon.formnet");
            this.put("xslt", "application/xslt+xml");
            this.put("xsm", "application/vnd.syncml+xml");
            this.put("xspf", "application/xspf+xml");
            this.put("xul", "application/vnd.mozilla.xul+xml");
            this.put("xwd", "image/x-xwindowdump");
            this.put("xyz", "chemical/x-xyz");
            this.put("yaml", "text/yaml");
            this.put("yang", "application/yang");
            this.put("yin", "application/yin+xml");
            this.put("z", "application/x-compress");
            this.put("zaz", "application/vnd.zzazz.deck+xml");
            this.put("zip", "application/zip");
            this.put("zir", "application/vnd.zul");
            this.put("zmm", "application/vnd.handheld-entertainment+xml");
        }
    };

    private FileType() {
        throw new IllegalAccessError("Utility class");
    }

    private static String getFileHeadContent(InputStream inputStream) throws IOException {
        byte[] b = new byte[28];
        inputStream.read(b, 0, 28);
        return String.valueOf(Hex.encodeHex((byte[])b, (boolean)false));
    }

    private static String getFileHeadContent(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = FileType.getFileHeadContent(inputStream);
            return string;
        }
    }

    public static String getFileType(InputStream file) throws IOException {
        String fileHead = FileType.getFileHeadContent(file);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        for (Map.Entry<String, String> entry : mFileTypes.entrySet()) {
            if (!fileHead.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return "unknown";
    }

    public static String getFileType(File file) throws IOException {
        String fileHead = FileType.getFileHeadContent(file);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        for (Map.Entry<String, String> entry : mFileTypes.entrySet()) {
            if (!fileHead.startsWith(entry.getKey())) continue;
            if (("office2003".equals(entry.getValue()) || "officeX".equals(entry.getValue())) && FileType.isOfficeFileByExtName(file.getName())) {
                return StringUtils.lowerCase((String)FileType.getFileExtName(file.getName()));
            }
            return entry.getValue();
        }
        return "unknown";
    }

    public static String getFileType(String fileName) throws IOException {
        return FileType.getFileType(new File(fileName));
    }

    public static String truncateFileExtName(String fileName) {
        int firstIndex2;
        if (fileName == null || fileName.isEmpty()) {
            return "";
        }
        int firstIndex = fileName.lastIndexOf("/");
        if (firstIndex < (firstIndex2 = fileName.lastIndexOf("\\"))) {
            firstIndex = firstIndex2;
        }
        firstIndex = firstIndex < 0 ? 0 : firstIndex + 1;
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex < 0) {
            return fileName;
        }
        return fileName.substring(firstIndex, lastIndex);
    }

    public static String truncateFileExtNameWithPath(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return "";
        }
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex < 0) {
            return "";
        }
        return fileName.substring(0, lastIndex);
    }

    public static String getFileExtName(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return "";
        }
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex < 0) {
            return "";
        }
        return fileName.substring(lastIndex + 1, fileName.length());
    }

    public static boolean isOfficeFileByExtName(String fileName) {
        String suffix = StringUtils.lowerCase((String)FileType.getFileExtName(fileName));
        if (StringUtils.isBlank((CharSequence)suffix)) {
            return false;
        }
        return suffix.equalsIgnoreCase("doc") || suffix.equalsIgnoreCase("docx") || suffix.equalsIgnoreCase("ppt") || suffix.equalsIgnoreCase("pptx") || suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx") || suffix.equalsIgnoreCase("vsd") || suffix.equalsIgnoreCase("vsdx") || suffix.equalsIgnoreCase("pub") || suffix.equalsIgnoreCase("pubx");
    }

    public static boolean isOffice2003FileByExtName(String fileName) {
        String suffix = StringUtils.lowerCase((String)FileType.getFileExtName(fileName));
        if (StringUtils.isBlank((CharSequence)suffix)) {
            return false;
        }
        return suffix.equalsIgnoreCase("doc") || suffix.equalsIgnoreCase("ppt") || suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("vsd") || suffix.equalsIgnoreCase("pub");
    }

    public static boolean isOfficeFile(File file) {
        try {
            String fileHead = FileType.getFileHeadContent(file);
            if (fileHead.startsWith(OFFICE2003_FILE_HEAD)) {
                return true;
            }
            if (fileHead.startsWith(OFFICE_XML_FILE_HEAD)) {
                return true;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isOfficeFile(String fileName) {
        return FileType.isOfficeFile(new File(fileName));
    }

    public static boolean isOffice2003File(File file) {
        try {
            String fileHead = FileType.getFileHeadContent(file);
            if (fileHead.startsWith(OFFICE2003_FILE_HEAD)) {
                return true;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isOffice2003File(String fileName) {
        return FileType.isOffice2003File(new File(fileName));
    }

    public static String mapExtNameToMimeType(String extName) {
        String mimeType = extMimeTypeMap.get(StringUtils.lowerCase((String)extName));
        if (mimeType != null) {
            return mimeType;
        }
        return "application/octet-stream";
    }

    public static String getFileMimeType(String fileUrl) {
        return FileType.mapExtNameToMimeType(FileType.getFileExtName(fileUrl));
    }
}

