/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import java.io.Serializable;

public class TimeInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Long startTime;
    private final boolean isNano;

    public TimeInterval(boolean isNano) {
        this.isNano = isNano;
        this.startTime = null;
    }

    public TimeInterval() {
        this(false);
    }

    public long start() {
        this.startTime = this.getTime();
        return this.startTime;
    }

    public long intervalRestart() {
        long now = this.getTime();
        if (this.startTime == null) {
            this.startTime = now;
            return 0L;
        }
        long inter = now - this.startTime;
        this.startTime = now;
        return inter;
    }

    public long interval() {
        if (null == this.startTime) {
            return 0L;
        }
        return this.isNano ? (this.getTime() - this.startTime) / 1000000L : this.getTime() - this.startTime;
    }

    private long getTime() {
        return this.isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public long intervalMs() {
        return this.interval();
    }

    public long intervalSecond() {
        return this.interval() / 1000L;
    }

    public long intervalMinute() {
        return this.interval() / 60000L;
    }

    public long intervalHour() {
        return this.interval() / 3600000L;
    }

    public long intervalDay() {
        return this.interval() / 86400000L;
    }

    public long intervalWeek() {
        return this.interval() / 604800000L;
    }
}

