/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.json.JsonDifferent;
import com.centit.support.json.config.LobSerializer;
import com.centit.support.json.config.SqlDateDeserializer;
import com.centit.support.json.config.SqlTimestampDeserializer;
import com.centit.support.json.config.UtilDateDeserializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSONOpt {
    protected static final Logger logger = LoggerFactory.getLogger(JSONOpt.class);

    private JSONOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static void fastjsonGlobalConfig() {
        JSON.config((JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.AllowUnQuotedFieldNames});
        JSON.register(java.util.Date.class, (ObjectReader)UtilDateDeserializer.instance);
        JSON.register(Date.class, (ObjectReader)SqlDateDeserializer.instance);
        JSON.register(Timestamp.class, (ObjectReader)SqlTimestampDeserializer.instance);
        JSON.register(Timestamp.class, (ObjectWriter)JdbcSupport.createTimestampWriter(Timestamp.class, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        JSON.register(Blob.class, (ObjectWriter)LobSerializer.instance);
        JSON.register(Clob.class, (ObjectWriter)JdbcSupport.createClobWriter(Clob.class));
    }

    private static JsonDifferent mapDiff(String jsonPath, Map<String, Object> mapA, Map<String, Object> mapB, String ... arrayKeys) {
        JsonDifferent updateDiff;
        ArrayList<JsonDifferent> differents = new ArrayList<JsonDifferent>();
        for (Map.Entry<String, Object> ent : mapA.entrySet()) {
            Object objA = ent.getValue();
            Object objB = mapB.get(ent.getKey());
            JsonDifferent fieldDiff = JSONOpt.objectDiff(ent.getKey(), objA, objB, arrayKeys);
            if (fieldDiff == null) continue;
            differents.add(fieldDiff);
        }
        for (Map.Entry<String, Object> ent : mapB.entrySet()) {
            if (mapA.containsKey(ent.getKey())) continue;
            differents.add(new JsonDifferent(ent.getKey(), "+", null, ent.getValue()));
        }
        if (differents.isEmpty()) {
            return null;
        }
        Map<String, Object> objectId = JSONOpt.fetchObjectId(mapA, arrayKeys);
        if (objectId != null || differents.size() > 1) {
            updateDiff = new JsonDifferent(jsonPath, "*", null, null);
            updateDiff.setDiffChildren(differents);
            updateDiff.setObjectId(objectId);
            return updateDiff;
        }
        updateDiff = (JsonDifferent)differents.get(0);
        if (StringUtils.isNotBlank((CharSequence)jsonPath)) {
            updateDiff.setJsonPath(jsonPath + "." + updateDiff.getJsonPath());
        }
        return updateDiff;
    }

    private static Map<String, Object> fetchObjectId(Map<String, Object> data1, String[] fields) {
        if (data1 == null || fields == null) {
            return null;
        }
        HashMap<String, Object> objectId = new HashMap<String, Object>();
        for (String field : fields) {
            Object idA = ReflectionOpt.attainExpressionValue(data1, field);
            if (idA == null) continue;
            objectId.put(field, idA);
        }
        return objectId.isEmpty() ? null : objectId;
    }

    private static int compareTwoRow(Map<String, Object> data1, Map<String, Object> data2, String[] fields) {
        if (data1 == null && data2 == null || fields == null) {
            return 0;
        }
        if (data1 == null) {
            return -1;
        }
        if (data2 == null) {
            return 1;
        }
        for (String field : fields) {
            Object idB;
            Object idA = ReflectionOpt.attainExpressionValue(data1, field);
            int cr = GeneralAlgorithm.compareTwoObject(idA, idB = ReflectionOpt.attainExpressionValue(data2, field), true);
            if (cr == 0) continue;
            return cr;
        }
        return 0;
    }

    private static JsonDifferent listDiff(String jsonPath, List<Object> listA, List<Object> listB, String ... arrayKeys) {
        int minSize;
        ArrayList<JsonDifferent> different = new ArrayList<JsonDifferent>();
        int sizeA = listA.size();
        int sizeB = listB.size();
        if (sizeA == 0 && sizeB == 0) {
            return null;
        }
        if (sizeA == 0) {
            return new JsonDifferent(jsonPath, "+", null, listB);
        }
        if (sizeB == 0) {
            return new JsonDifferent(jsonPath, "-", listA, null);
        }
        int n = minSize = sizeA > sizeB ? sizeB : sizeA;
        if (listA.get(0) instanceof Map && listB.get(0) instanceof Map && arrayKeys != null && arrayKeys.length > 0) {
            listA.sort((o1, o2) -> JSONOpt.compareTwoRow((Map)o1, (Map)o2, arrayKeys));
            listB.sort((o1, o2) -> JSONOpt.compareTwoRow((Map)o1, (Map)o2, arrayKeys));
            int i = 0;
            int j = 0;
            while (i < sizeA && j < sizeB) {
                int c = JSONOpt.compareTwoRow((Map)listA.get(i), (Map)listB.get(j), arrayKeys);
                if (c < 0) {
                    different.add(new JsonDifferent("[" + i + "]", "-", listA.get(i), null));
                    ++i;
                    continue;
                }
                if (c > 0) {
                    different.add(new JsonDifferent("[" + j + "]", "+", null, listB.get(j)));
                    ++j;
                    continue;
                }
                JsonDifferent itemDiff = JSONOpt.objectDiff("[" + i + "]", listA.get(i), listB.get(j), arrayKeys);
                if (itemDiff != null) {
                    different.add(itemDiff);
                }
                ++i;
                ++j;
            }
            while (i < sizeA) {
                different.add(new JsonDifferent("[" + i + "]", "-", listA.get(i), null));
                ++i;
            }
            while (j < sizeB) {
                different.add(new JsonDifferent("[" + j + "]", "+", null, listB.get(j)));
                ++j;
            }
        } else if (listA.get(0) instanceof List && listB.get(0) instanceof List) {
            int i;
            for (i = 0; i < minSize; ++i) {
                JsonDifferent itemDiff = JSONOpt.objectDiff("[" + i + "]", listA.get(i), listB.get(i), arrayKeys);
                if (itemDiff == null) continue;
                different.add(itemDiff);
            }
            for (i = minSize; i < sizeA; ++i) {
                different.add(new JsonDifferent("[" + i + "]", "-", listA.get(i), null));
            }
            for (i = minSize; i < sizeB; ++i) {
                different.add(new JsonDifferent("[" + i + "]", "+", null, listB.get(i)));
            }
        } else {
            String sA;
            int i;
            HashSet<String> stringsA = new HashSet<String>(sizeA + 2);
            HashSet<String> stringsB = new HashSet<String>(sizeB + 2);
            for (i = 0; i < sizeA; ++i) {
                stringsA.add(StringBaseOpt.castObjectToString(listA.get(i)));
            }
            for (i = 0; i < sizeB; ++i) {
                stringsB.add(StringBaseOpt.castObjectToString(listB.get(i)));
            }
            for (i = 0; i < minSize; ++i) {
                String sB;
                sA = StringBaseOpt.castObjectToString(listA.get(i));
                if (!stringsB.contains(sA)) {
                    different.add(new JsonDifferent("[" + i + "]", "-", listA.get(i), null));
                }
                if (stringsA.contains(sB = StringBaseOpt.castObjectToString(listB.get(i)))) continue;
                different.add(new JsonDifferent("[" + i + "]", "+", null, listB.get(i)));
            }
            for (i = minSize; i < sizeA; ++i) {
                sA = StringBaseOpt.castObjectToString(listA.get(i));
                if (stringsB.contains(sA)) continue;
                different.add(new JsonDifferent("[" + i + "]", "-", listA.get(i), null));
            }
            for (i = minSize; i < sizeB; ++i) {
                String sB = StringBaseOpt.castObjectToString(listB.get(i));
                if (stringsA.contains(sB)) continue;
                different.add(new JsonDifferent("[" + i + "]", "+", null, listB.get(i)));
            }
        }
        if (different.isEmpty()) {
            return null;
        }
        if (different.size() == 1) {
            JsonDifferent updateDiff = (JsonDifferent)different.get(0);
            updateDiff.setJsonPath(jsonPath + updateDiff.getJsonPath());
            return updateDiff;
        }
        JsonDifferent updateDiff = new JsonDifferent(jsonPath, "*", null, null);
        updateDiff.setDiffChildren(different);
        return updateDiff;
    }

    public static JsonDifferent objectDiff(String jsonPath, Object objectA, Object objectB, String ... arrayKeys) {
        if (objectA instanceof Map && objectB instanceof Map) {
            return JSONOpt.mapDiff(jsonPath, (Map)objectA, (Map)objectB, arrayKeys);
        }
        if (objectA instanceof List && objectB instanceof List) {
            return JSONOpt.listDiff(jsonPath, (List)objectA, (List)objectB, arrayKeys);
        }
        if (GeneralAlgorithm.equals(objectA, objectB)) {
            return null;
        }
        if (objectA == null) {
            return new JsonDifferent(jsonPath, "+", null, objectB);
        }
        if (objectB == null) {
            return new JsonDifferent(jsonPath, "-", objectA, null);
        }
        String strA = StringBaseOpt.objectToString(objectA);
        String strB = StringBaseOpt.objectToString(objectB);
        String[] stringsA = strA.split("\\n");
        String[] stringsB = strB.split("\\n");
        if (stringsA.length > 1 && stringsB.length > 1) {
            JsonDifferent updateDiff = JSONOpt.listDiff(jsonPath, CollectionsOpt.arrayToList(stringsA), CollectionsOpt.arrayToList(stringsB), arrayKeys);
            if (updateDiff == null) {
                return null;
            }
            if (updateDiff.getDiffChildren() == null || updateDiff.getDiffChildren().isEmpty()) {
                updateDiff.setNewData("\u591a\u884c\u5b57\u7b26\u4e32\u5bf9\u6bd4\u6ca1\u6709\u5dee\u5f02\uff0c\u5e94\u8be5\u662f\u884c\u7684\u987a\u5e8f\u4e0d\u4e00\u81f4\uff01");
            }
            return updateDiff;
        }
        return new JsonDifferent(jsonPath, "*", objectA, objectB);
    }

    public static JsonDifferent diff(Object objectA, Object objectB, String ... arrayKeys) {
        return JSONOpt.objectDiff("", objectA, objectB, arrayKeys);
    }

    private static JSONKey praseJosnKey(String skey) {
        JSONKey key = new JSONKey();
        key.ind = -1;
        int nL = skey.indexOf(91);
        if (nL > 0) {
            key.skey = skey.substring(0, nL);
            int nR = skey.indexOf(93);
            key.ind = nR > nL + 1 ? Integer.parseInt(skey.substring(nL + 1, nR)) : 0;
        } else {
            key.skey = skey;
        }
        return key;
    }

    private static JSONPath findJsonObject(JSONObject objJson, int depth, String[] skeys) {
        JSONPath p = new JSONPath();
        int nLast = 0;
        JSONObject lastKeyJson = objJson;
        while (nLast < depth) {
            Object obj2;
            JSONArray jarray;
            JSONKey key = JSONOpt.praseJosnKey(skeys[nLast]);
            if (!lastKeyJson.containsKey(key.skey)) break;
            Object obj = lastKeyJson.get(key.skey);
            if (obj instanceof JSONObject) {
                if (key.ind >= 0) break;
                lastKeyJson = (JSONObject)obj;
                ++nLast;
                continue;
            }
            if (!(obj instanceof JSONArray) || key.ind < 0 || key.ind >= (jarray = (JSONArray)obj).size() || !((obj2 = jarray.get(key.ind)) instanceof JSONObject)) break;
            lastKeyJson = (JSONObject)obj2;
            ++nLast;
        }
        p.found = true;
        p.pathPos = nLast;
        p.objJson = lastKeyJson;
        return p;
    }

    private static JSONObject innerCreateJsonObject(String[] skeys, int beginPos, Object value) {
        int depth = skeys.length;
        if (depth == 0) {
            return null;
        }
        int nLast = beginPos;
        JSONKey key = JSONOpt.praseJosnKey(skeys[depth - 1]);
        JSONObject leafKey = new JSONObject();
        if (key.ind < 0) {
            leafKey.put((Object)key.skey, value);
        } else {
            JSONArray jarray = new JSONArray();
            for (int i = 0; i < key.ind; ++i) {
                jarray.add(i, null);
            }
            jarray.add(key.ind, value);
            leafKey.put((Object)key.skey, (Object)jarray);
        }
        depth -= 2;
        while (depth >= nLast) {
            key = JSONOpt.praseJosnKey(skeys[depth]);
            JSONObject tempKey = new JSONObject();
            if (key.ind < 0) {
                tempKey.put((Object)key.skey, (Object)leafKey);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, (Object)leafKey);
                tempKey.put((Object)key.skey, (Object)jarray);
            }
            leafKey = tempKey;
            --depth;
        }
        return leafKey;
    }

    public static void setAttribute(JSONObject objJson, String path, Object value) {
        String[] skeys = path.split("\\x2E");
        int depth = skeys.length;
        if (depth == 0) {
            return;
        }
        JSONPath jpath = JSONOpt.findJsonObject(objJson, depth - 1, skeys);
        Object jsonValue = value;
        if (jpath.pathPos < depth - 1) {
            jsonValue = JSONOpt.innerCreateJsonObject(skeys, jpath.pathPos + 1, value);
        }
        JSONKey key = JSONOpt.praseJosnKey(skeys[jpath.pathPos]);
        if (key.ind < 0) {
            jpath.objJson.put((Object)key.skey, jsonValue);
        } else if (jpath.objJson.containsKey(key.skey)) {
            Object leafJson = jpath.objJson.get(key.skey);
            if (leafJson instanceof JSONArray) {
                JSONArray jarray = (JSONArray)leafJson;
                if (jarray.size() < key.ind + 1) {
                    for (int i = jarray.size(); i < key.ind; ++i) {
                        jarray.add(i, null);
                    }
                    jarray.add(key.ind, jsonValue);
                } else if (jpath.pathPos == depth - 1 && jsonValue instanceof Map) {
                    Object obj = jarray.get(key.ind);
                    if (obj instanceof JSONObject) {
                        for (Map.Entry ent : ((Map)value).entrySet()) {
                            ((JSONObject)obj).put((Object)ent.getKey().toString(), ent.getValue());
                        }
                    } else {
                        jarray.set(key.ind, jsonValue);
                    }
                } else {
                    jarray.set(key.ind, jsonValue);
                }
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, jsonValue);
                jpath.objJson.put((Object)key.skey, (Object)jarray);
            }
        } else {
            JSONArray jarray = new JSONArray();
            for (int i = 0; i < key.ind; ++i) {
                jarray.add(i, null);
            }
            jarray.add(key.ind, jsonValue);
            jpath.objJson.put((Object)key.skey, (Object)jarray);
        }
    }

    public static void appendData(JSONObject objJson, String path, Object value) {
        String[] skeys = path.split("\\x2E");
        int depth = skeys.length;
        if (depth == 0) {
            return;
        }
        JSONPath jpath = JSONOpt.findJsonObject(objJson, depth - 1, skeys);
        Object jsonValue = value;
        if (jpath.pathPos < depth - 1) {
            jsonValue = JSONOpt.innerCreateJsonObject(skeys, jpath.pathPos + 1, value);
            JSONKey key = JSONOpt.praseJosnKey(skeys[jpath.pathPos]);
            if (key.ind < 0) {
                jpath.objJson.put((Object)key.skey, jsonValue);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, jsonValue);
                jpath.objJson.put((Object)key.skey, (Object)jarray);
            }
        } else {
            JSONKey key = JSONOpt.praseJosnKey(skeys[depth - 1]);
            if (jpath.objJson.containsKey(key.skey)) {
                jpath.objJson.put((Object)key.skey, value);
            } else if (key.ind < 0) {
                jpath.objJson.put((Object)key.skey, value);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, value);
                jpath.objJson.put((Object)key.skey, (Object)jarray);
            }
        }
    }

    public static void batchAppendData(JSONObject objJson, String path, Object[] values) {
        for (Object obj : values) {
            JSONOpt.appendData(objJson, path, obj);
        }
    }

    public static void batchAppendData(JSONObject objJson, String path, Collection<Object> values) {
        for (Object obj : values) {
            JSONOpt.appendData(objJson, path, obj);
        }
    }

    public static String objectToJSONString(Object obj) {
        return JSONOpt.objectToJSONString(obj, false, false);
    }

    public static String objectToJSONString(Object obj, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.objectToJSONString(obj, methodOnly, fieldOnly, false);
    }

    public static String objectToJSONString(Object obj, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        if (obj == null) {
            return null;
        }
        if (ReflectionOpt.isScalarType(obj.getClass())) {
            return obj.toString();
        }
        if (obj instanceof JSONObject || obj instanceof JSONArray) {
            return obj.toString();
        }
        if (ReflectionOpt.isArray(obj)) {
            return JSONOpt.arrayToJSONArray(obj, methodOnly, fieldOnly, includePrivateField).toString();
        }
        return JSONOpt.objectToJSONObject(obj, methodOnly, fieldOnly, includePrivateField).toString();
    }

    @Deprecated
    public static Map<String, Object> objectToMap(Object object) {
        return CollectionsOpt.objectToMap(object);
    }

    public static Object objectToJSON(Object obj) {
        return JSONOpt.objectToJSON(obj, false, false);
    }

    public static Object objectToJSON(Object obj, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        if (obj instanceof JSONObject || obj instanceof JSONArray) {
            return obj;
        }
        if (ReflectionOpt.isArray(obj)) {
            return JSONOpt.arrayToJSONArray(obj, methodOnly, fieldOnly, includePrivateField);
        }
        return JSONOpt.objectToJSONObject(obj, methodOnly, fieldOnly, includePrivateField);
    }

    public static Object objectToJSON(Object obj, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.objectToJSON(obj, methodOnly, fieldOnly, false);
    }

    public static JSONObject objectToJSONObject(Object obj) {
        return JSONOpt.objectToJSONObject(obj, false, false, false);
    }

    private static Object makeJSONValue(Object value, boolean methodOnly, boolean fieldOnly) {
        if (value == null) {
            return null;
        }
        if (ReflectionOpt.isScalarType(value.getClass())) {
            return value;
        }
        return JSONOpt.objectToJSON(value, methodOnly, fieldOnly);
    }

    public static JSONObject objectToJSONObject(Object obj, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        JSONObject jObj = new JSONObject();
        if (ReflectionOpt.isScalarType(obj.getClass())) {
            jObj.put((Object)"value", (Object)obj.toString());
            return jObj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry ent : map.entrySet()) {
                jObj.put((Object)ent.getKey().toString(), JSONOpt.makeJSONValue(ent.getValue(), methodOnly, fieldOnly));
            }
            return jObj;
        }
        ArrayList<String> methodNames = new ArrayList<String>();
        List<Method> getMethods = ReflectionOpt.getAllGetterMethod(obj.getClass());
        if (!fieldOnly && getMethods != null) {
            for (Method m : getMethods) {
                String fieldName = ReflectionOpt.methodNameToField(m.getName());
                methodNames.add(fieldName);
                Object value = null;
                try {
                    value = m.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                jObj.put((Object)fieldName, JSONOpt.makeJSONValue(value, methodOnly, fieldOnly));
            }
        }
        Field[] fls = ReflectionOpt.getFields(obj);
        if (!methodOnly && fls != null) {
            for (Field fl : fls) {
                if (methodNames.contains(fl.getName()) || !includePrivateField && !Modifier.isPublic(fl.getModifiers())) continue;
                Object value = ReflectionOpt.forceGetFieldValue(obj, fl);
                jObj.put((Object)fl.getName(), JSONOpt.makeJSONValue(value, methodOnly, fieldOnly));
            }
        }
        if (!(fls != null && fls.length >= 1 || getMethods != null && !getMethods.isEmpty())) {
            jObj.put((Object)"value", (Object)obj.toString());
        }
        return jObj;
    }

    public static JSONObject objectToJSONObject(Object obj, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.objectToJSONObject(obj, methodOnly, fieldOnly, false);
    }

    public static JSONArray arrayToJSONArray(Object obj) {
        return JSONOpt.arrayToJSONArray(obj, false, false, false);
    }

    public static JSONArray arrayToJSONArray(Object objArray, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        JSONArray jArray;
        block10: {
            char[] objList;
            block15: {
                double[] objList2;
                block14: {
                    float[] objList3;
                    block13: {
                        long[] objList4;
                        block12: {
                            int[] objList5;
                            block11: {
                                block9: {
                                    Object[] objList6;
                                    if (objArray == null) {
                                        return null;
                                    }
                                    if (objArray instanceof JSONArray) {
                                        return (JSONArray)objArray;
                                    }
                                    jArray = new JSONArray();
                                    if (!(objArray instanceof Object[])) break block9;
                                    for (Object obj : objList6 = (Object[])objArray) {
                                        jArray.add(JSONOpt.makeJSONValue(obj, methodOnly, fieldOnly));
                                    }
                                    break block10;
                                }
                                if (!(objArray instanceof Collection)) break block11;
                                Collection objList7 = (Collection)objArray;
                                for (Object obj : objList7) {
                                    jArray.add(JSONOpt.makeJSONValue(obj, methodOnly, fieldOnly));
                                }
                                break block10;
                            }
                            if (!int[].class.equals(objArray.getClass())) break block12;
                            for (int obj : objList5 = (int[])objArray) {
                                jArray.add((Object)obj);
                            }
                            break block10;
                        }
                        if (!long[].class.equals(objArray.getClass())) break block13;
                        for (long obj : objList4 = (long[])objArray) {
                            jArray.add((Object)obj);
                        }
                        break block10;
                    }
                    if (!float[].class.equals(objArray.getClass())) break block14;
                    for (float obj : objList3 = (float[])objArray) {
                        jArray.add((Object)Float.valueOf(obj));
                    }
                    break block10;
                }
                if (!double[].class.equals(objArray.getClass())) break block15;
                for (double obj : objList2 = (double[])objArray) {
                    jArray.add((Object)obj);
                }
                break block10;
            }
            if (!char[].class.equals(objArray.getClass())) break block10;
            for (char obj : objList = (char[])objArray) {
                jArray.add((Object)Character.valueOf(obj));
            }
        }
        return jArray;
    }

    public static JSONArray arrayToJSONArray(Object objArray, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.arrayToJSONArray(objArray, methodOnly, fieldOnly, false);
    }

    public static Object parseJsonString(String jsonStr) {
        if (StringUtils.isNotBlank((CharSequence)jsonStr) && (jsonStr.startsWith("{") || jsonStr.startsWith("["))) {
            return JSON.parse((String)jsonStr);
        }
        return jsonStr;
    }

    static class JSONKey {
        String skey;
        int ind;

        JSONKey() {
        }
    }

    static class JSONPath {
        JSONObject objJson;
        String path;
        boolean found;
        int pathPos;

        JSONPath() {
        }
    }
}

