/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import java.io.Serializable;
import java.util.Date;

public class DateTimeSpan
extends Number
implements Serializable,
Comparable<Number> {
    public static final long DAY_MILLISECONDS = 86400000L;
    public static final long HOUR_MILLISECONDS = 3600000L;
    public static final long MINUTE_MILLISECONDS = 60000L;
    public static final long SECOND_MILLISECONDS = 1000L;
    private static final long serialVersionUID = 1L;
    private long timeSpan;

    public DateTimeSpan() {
        this.timeSpan = 0L;
    }

    @Override
    public int intValue() {
        return Long.valueOf(this.timeSpan).intValue();
    }

    @Override
    public long longValue() {
        return this.timeSpan;
    }

    @Override
    public float floatValue() {
        return this.timeSpan;
    }

    @Override
    public double doubleValue() {
        return this.timeSpan;
    }

    public DateTimeSpan(Date beginDate, Date endDate) {
        this.fromDatetimeSpan(beginDate, endDate);
    }

    public DateTimeSpan(String sTimeSpan) {
        this.fromString(sTimeSpan);
    }

    public DateTimeSpan(long lMillisecond) {
        this.fromNumberAsMillisecond(lMillisecond);
    }

    public DateTimeSpan(String sign, long days, long hours, long minutes, long second, long millisecond) {
        this.timeSpan = days * 86400000L + hours * 3600000L + minutes * 60000L + second * 1000L + millisecond;
        if ("-".equals(sign)) {
            this.timeSpan = 0L - this.timeSpan;
        }
    }

    public DateTimeSpan(long days, long hours, long minutes, long second, long millisecond) {
        this("", days, hours, minutes, second, millisecond);
    }

    public DateTimeSpan(String sign, long days, long hours, long minutes) {
        this(sign, days, hours, minutes, 0L, 0L);
    }

    public DateTimeSpan(long days, long hours, long minutes) {
        this("", days, hours, minutes, 0L, 0L);
    }

    public static DateTimeSpan calcDateTimeSpan(Date beginDate, Date endDate) {
        DateTimeSpan workTimeSpan = new DateTimeSpan();
        workTimeSpan.setTimeSpan(endDate.getTime() - beginDate.getTime());
        return workTimeSpan;
    }

    public static DateTimeSpan calcDateTimeSpanAsAbs(Date beginDate, Date endDate) {
        DateTimeSpan workTimeSpan = new DateTimeSpan();
        if (endDate.getTime() > beginDate.getTime()) {
            workTimeSpan.setTimeSpan(endDate.getTime() - beginDate.getTime());
        } else {
            workTimeSpan.setTimeSpan(beginDate.getTime() - endDate.getTime());
        }
        return workTimeSpan;
    }

    public long getTimeSpan() {
        return this.timeSpan;
    }

    public void setTimeSpan(long timeSpan) {
        this.timeSpan = timeSpan;
    }

    public DateTimeSpan fromDatetimeSpan(Date beginDate, Date endDate) {
        this.setTimeSpan(endDate.getTime() - beginDate.getTime());
        return this;
    }

    public DateTimeSpan fromDatetimeSpanAsAbs(Date beginDate, Date endDate) {
        if (beginDate.getTime() > endDate.getTime()) {
            this.setTimeSpan(beginDate.getTime() - endDate.getTime());
        } else {
            this.setTimeSpan(beginDate.getTime() - endDate.getTime());
        }
        return this;
    }

    public void fromString(String sTimeSpan) {
        int sp;
        int sign = 1;
        long nDays = 0L;
        long nHours = 0L;
        long nMinutes = 0L;
        long nSecond = 0L;
        long nMillisecond = 0L;
        if (sTimeSpan == null || "".equals(sTimeSpan)) {
            return;
        }
        char[] sc = sTimeSpan.toCharArray();
        int sl = sTimeSpan.length();
        for (sp = 0; sp < sl && sc[sp] == ' '; ++sp) {
        }
        if (sc[sp] == '-') {
            ++sp;
            sign = -1;
        }
        while (sp < sl) {
            while (sp < sl && !Character.isDigit(sc[sp])) {
                ++sp;
            }
            if (sp >= sl) break;
            int nb = sp;
            while (sp < sl && Character.isDigit(sc[sp])) {
                ++sp;
            }
            String digits = sTimeSpan.substring(nb, sp);
            while (sp < sl && !Character.isLetter(sc[sp]) && !Character.isDigit(sc[sp])) {
                ++sp;
            }
            if (sp >= sl) {
                if (nDays != 0L) break;
                nDays = Long.parseLong(digits);
                break;
            }
            if (Character.isDigit(sc[sp])) continue;
            switch (sc[sp]) {
                case 'D': 
                case 'd': {
                    nDays = Long.parseLong(digits);
                    break;
                }
                case 'H': 
                case 'h': {
                    nHours = Long.parseLong(digits);
                    break;
                }
                case 'M': 
                case 'm': {
                    nMinutes = Long.parseLong(digits);
                    break;
                }
                case 'S': {
                    nSecond = Long.parseLong(digits);
                    break;
                }
                case 's': {
                    nMillisecond = Long.parseLong(digits);
                    break;
                }
            }
        }
        this.timeSpan = (long)sign * (nDays * 86400000L + nHours * 3600000L + nMinutes * 60000L + nSecond * 1000L + nMillisecond);
    }

    public String getTimeSpanDesc() {
        return this.getSignString() + (String)(this.getDays() != 0L ? this.getDays() + "\u5929" : "") + (String)(this.getHours() != 0L ? this.getHours() + "\u5c0f\u65f6" : "") + (String)(this.getMinutes() != 0L ? this.getMinutes() + "\u5206" : "");
    }

    public String getTimeSpanDescAsSecond() {
        return this.getSignString() + (String)(this.getDays() != 0L ? this.getDays() + "\u5929" : "") + (String)(this.getHours() != 0L ? this.getHours() + "\u5c0f\u65f6" : "") + (String)(this.getMinutes() != 0L ? this.getMinutes() + "\u5206" : "") + (String)(this.getSeconds() != 0L ? this.getSeconds() + "\u79d2" : "");
    }

    public String getTimeSpanDescAsMillisecond() {
        return this.getSignString() + (String)(this.getDays() != 0L ? this.getDays() + "\u5929" : "") + (String)(this.getHours() != 0L ? this.getHours() + "\u5c0f\u65f6" : "") + (String)(this.getMinutes() != 0L ? this.getMinutes() + "\u5206" : "") + (String)(this.getSeconds() != 0L ? this.getSeconds() + "\u79d2" : "") + (String)(this.getMilliseconds() != 0L ? this.getMilliseconds() + "\u6beb\u79d2" : "");
    }

    public String toString() {
        return this.toStringAsMinute();
    }

    public String toStringAsMinute() {
        return this.getSignString() + (String)(this.getDays() != 0L ? this.getDays() + "D" : "") + (String)(this.getHours() != 0L ? this.getHours() + "H" : "") + (String)(this.getMinutes() != 0L ? this.getMinutes() + "M" : "");
    }

    public String toStringAsSecond() {
        return this.getSignString() + (String)(this.getDays() != 0L ? this.getDays() + "D" : "") + (String)(this.getHours() != 0L ? this.getHours() + "H" : "") + (String)(this.getMinutes() != 0L ? this.getMinutes() + "M" : "") + (String)(this.getMinutes() != 0L ? this.getMinutes() + "S" : "");
    }

    public String toStringAsMillisecond() {
        return this.getSignString() + (String)(this.getDays() != 0L ? this.getDays() + "D" : "") + (String)(this.getHours() != 0L ? this.getHours() + "H" : "") + (String)(this.getMinutes() != 0L ? this.getMinutes() + "M" : "") + (String)(this.getSeconds() != 0L ? this.getSeconds() + "S" : "") + (String)(this.getMilliseconds() != 0L ? this.getMilliseconds() + "s" : "");
    }

    private long toAbsNumberAsMillisecond() {
        return this.timeSpan > 0L ? this.timeSpan : 0L - this.timeSpan;
    }

    public long toNumberAsMillisecond() {
        return this.timeSpan;
    }

    public long toNumberAsMinute() {
        return this.getSign() * (this.toAbsNumberAsMillisecond() / 60000L);
    }

    public long toNumberAsSecond() {
        return this.getSign() * (this.toAbsNumberAsMillisecond() / 1000L);
    }

    public void fromNumberAsMinute(long lSpan) {
        this.fromNumberAsMillisecond(lSpan * 60000L);
    }

    public void fromNumberAsHour(long lSpan) {
        this.fromNumberAsMillisecond(lSpan * 3600000L);
    }

    public void fromNumberAsSecond(long lSpan) {
        this.fromNumberAsMillisecond(lSpan * 1000L);
    }

    public void fromNumberAsMillisecond(long lSpan) {
        this.timeSpan = lSpan;
    }

    public long getSign() {
        return this.timeSpan > 0L ? 1L : -1L;
    }

    public String getSignString() {
        return this.timeSpan > 0L ? "" : "-";
    }

    public DateTimeSpan changeSign() {
        this.timeSpan = 0L - this.timeSpan;
        return this;
    }

    public DateTimeSpan addDays(long ndays) {
        this.timeSpan += ndays * 86400000L;
        return this;
    }

    public DateTimeSpan addHours(long nHours) {
        this.timeSpan += nHours * 3600000L;
        return this;
    }

    public DateTimeSpan addMinutes(long nMinutes) {
        this.timeSpan += nMinutes * 60000L;
        return this;
    }

    public DateTimeSpan addSeconds(long nSeconds) {
        this.timeSpan += nSeconds * 1000L;
        return this;
    }

    public DateTimeSpan addMilliseconds(long nMilliseconds) {
        this.timeSpan += nMilliseconds;
        return this;
    }

    public DateTimeSpan addDateTimeSpan(DateTimeSpan timeSpan) {
        this.timeSpan += timeSpan.timeSpan;
        return this;
    }

    public DateTimeSpan subtractDateTimeSpan(DateTimeSpan timeSpan) {
        this.timeSpan -= timeSpan.timeSpan;
        return this;
    }

    public long getDays() {
        return this.timeSpan > 0L ? this.timeSpan / 86400000L : (0L - this.timeSpan) / 86400000L;
    }

    private long getRemainderMilliseconds() {
        return this.timeSpan > 0L ? this.timeSpan % 86400000L : (0L - this.timeSpan) % 86400000L;
    }

    public long getHours() {
        return this.getRemainderMilliseconds() / 3600000L;
    }

    public long getMinutes() {
        return this.getRemainderMilliseconds() % 3600000L / 60000L;
    }

    public long getSeconds() {
        return this.getRemainderMilliseconds() % 60000L / 1000L;
    }

    public long getMilliseconds() {
        return this.getRemainderMilliseconds() % 1000L;
    }

    public boolean isPositiveTimeSpan() {
        return this.timeSpan > 0L;
    }

    @Override
    public int compareTo(Number o) {
        return Long.compare(this.timeSpan, o.longValue());
    }
}

