/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import com.centit.support.security.GMBaseUtil;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class SM3Util
extends GMBaseUtil {
    public static byte[] hash(byte[] srcData) {
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    public static boolean verify(byte[] srcData, byte[] sm3Hash) {
        byte[] newHash = SM3Util.hash(srcData);
        return Arrays.equals(newHash, sm3Hash);
    }

    public static byte[] hmac(byte[] key, byte[] srcData) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(srcData, 0, srcData.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    public static boolean hmacVerify(byte[] key, byte[] srcData, byte[] sm3Hash) {
        byte[] newHash = SM3Util.hmac(key, srcData);
        return Arrays.equals(newHash, sm3Hash);
    }
}

