/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.network.UrlOptUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class Pretreatment {
    private Pretreatment() {
        throw new IllegalAccessError("Utility class");
    }

    private static String innerMapTemplateString(String template, VariableTranslate varTrans, String nullValue, boolean canOmitDollar, boolean asFormula, boolean asUrl) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return nullValue;
        }
        Lexer varTemplate = new Lexer();
        varTemplate.setFormula(template);
        StringBuilder mapString = new StringBuilder();
        int nlen = template.length();
        int bp = 0;
        int prePos = 0;
        while (true) {
            int ep;
            String aword = varTemplate.getARawWord();
            while (true) {
                if ("\\".equals(aword)) {
                    ep = varTemplate.getCurrPos();
                    mapString.append(template, bp, ep - 1);
                    mapString.append(template.charAt(ep));
                    varTemplate.setPosition(ep + 1);
                    bp = varTemplate.getCurrPos();
                } else if ("$".equals(aword) ? "{".equals(aword = varTemplate.getARawWord()) || StringUtils.isBlank((CharSequence)aword) : canOmitDollar && "{".equals(aword) || StringUtils.isBlank((CharSequence)aword)) break;
                prePos = varTemplate.getCurrPos();
                aword = varTemplate.getARawWord();
            }
            if (!"{".equals(aword)) break;
            ep = varTemplate.getCurrPos();
            if (prePos > bp) {
                mapString.append(template, bp, prePos);
            }
            varTemplate.seekToRightBrace();
            bp = varTemplate.getCurrPos();
            if (bp - 1 <= ep) continue;
            String valueName = template.substring(ep, bp - 1);
            if (asFormula) {
                if (asUrl) {
                    mapString.append(UrlOptUtils.objectToUrlString(GeneralAlgorithm.nvl(VariableFormula.calculate(valueName, varTrans), nullValue)));
                    continue;
                }
                mapString.append(StringBaseOpt.castObjectToString(VariableFormula.calculate(valueName, varTrans), nullValue));
                continue;
            }
            if (asUrl) {
                mapString.append(UrlOptUtils.objectToUrlString(GeneralAlgorithm.nvl(varTrans.getVarValue(valueName), nullValue)));
                continue;
            }
            mapString.append(StringBaseOpt.castObjectToString(varTrans.getVarValue(valueName), nullValue));
        }
        if (bp < nlen) {
            mapString.append(template.substring(bp));
        }
        return mapString.toString();
    }

    public static String mapTemplateString(String template, Object object, String nullValue, boolean canOmitDollar) {
        if (object instanceof VariableTranslate) {
            return Pretreatment.innerMapTemplateString(template, (VariableTranslate)object, nullValue, canOmitDollar, false, false);
        }
        return Pretreatment.innerMapTemplateString(template, new ObjectTranslate(object), nullValue, canOmitDollar, false, false);
    }

    public static String mapTemplateString(String template, Object object, String nullValue) {
        return Pretreatment.mapTemplateString(template, object, nullValue, true);
    }

    public static String mapTemplateString(String template, Object object, boolean canOmitDollar) {
        return Pretreatment.mapTemplateString(template, object, "", canOmitDollar);
    }

    public static String mapTemplateString(String template, Object object) {
        return Pretreatment.mapTemplateString(template, object, "", true);
    }

    public static String mapTemplateStringAsFormula(String template, Object object, String nullValue, boolean canOmitDollar) {
        if (object instanceof VariableTranslate) {
            return Pretreatment.innerMapTemplateString(template, (VariableTranslate)object, nullValue, canOmitDollar, true, false);
        }
        return Pretreatment.innerMapTemplateString(template, new ObjectTranslate(object), nullValue, canOmitDollar, true, false);
    }

    public static String mapTemplateStringAsFormula(String template, Object object, String nullValue) {
        return Pretreatment.mapTemplateStringAsFormula(template, object, nullValue, true);
    }

    public static String mapTemplateStringAsFormula(String template, Object object, boolean canOmitDollar) {
        return Pretreatment.mapTemplateStringAsFormula(template, object, "", canOmitDollar);
    }

    public static String mapTemplateStringAsFormula(String template, Object object) {
        return Pretreatment.mapTemplateStringAsFormula(template, object, "", true);
    }

    public static String mapUrlTemplateAsFormula(String template, Object object) {
        if (object instanceof VariableTranslate) {
            return Pretreatment.innerMapTemplateString(template, (VariableTranslate)object, "", true, true, true);
        }
        return Pretreatment.innerMapTemplateString(template, new ObjectTranslate(object), "", true, true, true);
    }

    public static String mapUrlTemplate(String template, Object object) {
        if (object instanceof VariableTranslate) {
            return Pretreatment.innerMapTemplateString(template, (VariableTranslate)object, "", true, false, true);
        }
        return Pretreatment.innerMapTemplateString(template, new ObjectTranslate(object), "", true, false, true);
    }
}

