/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.common.CachedObject;
import java.util.Date;
import java.util.function.Supplier;

public class AsyncCachedObject<T>
extends CachedObject<T> {
    public AsyncCachedObject(Supplier<T> refresher) {
        super(refresher);
    }

    public AsyncCachedObject(Supplier<T> refresher, long freshPeriod) {
        super(refresher, freshPeriod);
    }

    public void asyncRefreshData() {
        this.evicted = false;
        this.refreshTime = new Date(System.currentTimeMillis() - this.freshPeriod * 1000L + (this.freshPeriod / 2L > 5L ? 5L : this.freshPeriod / 2L) * 1000L);
        Thread t = new Thread(this::refreshData);
        t.start();
    }

    public T ensureGetCachedTarget() {
        if (this.target == null) {
            this.refreshData();
        } else if (this.isTargetOutOfDate(this.freshPeriod)) {
            this.asyncRefreshData();
        }
        return (T)this.target;
    }

    @Override
    public T getCachedTarget() {
        if (this.target == null || this.isTargetOutOfDate(this.freshPeriod)) {
            this.asyncRefreshData();
        }
        return (T)this.target;
    }
}

