/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Lexer {
    public static final int LANG_TYPE_DEFAULT = 0;
    public static final int LANG_TYPE_JAVA = 1;
    public static final int LANG_TYPE_SQL = 2;
    private String curWord;
    private boolean isBack;
    private String formulaSen;
    private boolean canAcceptOpt;
    private int startPos;
    private int languageType;
    private boolean colonInLable;

    public Lexer() {
        this.languageType = 1;
        this.colonInLable = true;
        this.setFormula(null);
    }

    public Lexer(String sFormula) {
        this.languageType = 1;
        this.colonInLable = true;
        this.setFormula(sFormula);
    }

    public Lexer(int langType) {
        this.languageType = langType;
        this.colonInLable = this.languageType != 2;
        this.setFormula(null);
    }

    public Lexer(String sFormula, int langType) {
        this.languageType = langType;
        this.colonInLable = this.languageType != 2;
        this.setFormula(sFormula);
    }

    public void setColonInLable(boolean colonInLable) {
        this.colonInLable = colonInLable;
    }

    public static boolean isConstValue(CharSequence seq) {
        if (seq == null || seq.length() == 0) {
            return true;
        }
        int strLen = seq.length();
        char b = seq.charAt(0);
        if (b == '.' || b == '+' || b == '-' || b >= '0' && b <= '9') {
            return true;
        }
        char e = seq.charAt(strLen - 1);
        return strLen > 1 && b == e && (b == '\'' || b == '\"');
    }

    public static Object toConstValue(String seq) {
        if (seq == null || seq.isEmpty()) {
            return null;
        }
        int strLen = seq.length();
        char b = seq.charAt(0);
        if (b == '.' || b == '+' || b == '-' || b >= '0' && b <= '9') {
            if (seq.indexOf(46) >= 0) {
                return NumberBaseOpt.castObjectToDouble(seq);
            }
            return NumberBaseOpt.castObjectToLong(seq);
        }
        char e = seq.charAt(strLen - 1);
        if (strLen > 1 && b == e && (b == '\'' || b == '\"')) {
            return seq.substring(1, strLen - 1);
        }
        return null;
    }

    public static boolean isLabel(CharSequence seq) {
        if (seq == null || seq.length() == 0) {
            return false;
        }
        int strLen = seq.length();
        char c = seq.charAt(0);
        if (!(c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < strLen; ++i) {
            c = seq.charAt(i);
            if (c == '_' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static List<String> splitByWord(String sourceString, String splitWord) {
        int curPos;
        ArrayList<String> res = new ArrayList<String>();
        Lexer varMorp = new Lexer(sourceString, 0);
        int prePos = curPos = varMorp.getCurrPos();
        String aWord = varMorp.getARawWord();
        while (StringUtils.isNotBlank((CharSequence)aWord)) {
            if ("(".equals(aWord)) {
                varMorp.seekToRightBracket();
                curPos = varMorp.getCurrPos();
                aWord = varMorp.getARawWord();
            }
            if ("{".equals(aWord)) {
                varMorp.seekToRightBrace();
                curPos = varMorp.getCurrPos();
                aWord = varMorp.getARawWord();
            }
            if ("[".equals(aWord)) {
                varMorp.seekToRightSquareBracket();
                curPos = varMorp.getCurrPos();
                aWord = varMorp.getARawWord();
            }
            if (StringUtils.equals((CharSequence)aWord, (CharSequence)splitWord)) {
                res.add(sourceString.substring(prePos, curPos));
                prePos = varMorp.getCurrPos();
            }
            curPos = varMorp.getCurrPos();
            aWord = varMorp.getARawWord();
        }
        curPos = varMorp.getCurrPos();
        res.add(sourceString.substring(prePos, curPos));
        return res;
    }

    public static String getFirstWord(String str, int langType) {
        return new Lexer(str, langType).getAWord();
    }

    public static String getFirstWord(String str) {
        return new Lexer(str).getAWord();
    }

    public static boolean isSingleWord(String str) {
        Lexer lexer = new Lexer(str);
        String firstWord = lexer.getAWord();
        if (StringUtils.isBlank((CharSequence)firstWord)) {
            return false;
        }
        return StringUtils.isBlank((CharSequence)lexer.getAWord());
    }

    public void writeBackAWord(String preWord) {
        this.curWord = preWord;
        this.isBack = true;
    }

    public void setFormula(String sFormula) {
        this.formulaSen = sFormula;
        this.isBack = false;
        this.curWord = "";
        this.startPos = 0;
        this.canAcceptOpt = false;
    }

    public boolean isCanAcceptOpt() {
        return this.canAcceptOpt;
    }

    public void setCanAcceptOpt(boolean canAcceptOpt) {
        this.canAcceptOpt = canAcceptOpt;
    }

    public int getCurrPos() {
        return this.startPos;
    }

    public String getARawWord() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) == ' ' || this.formulaSen.charAt(this.startPos) == '\t' || this.formulaSen.charAt(this.startPos) == '\n' || this.formulaSen.charAt(this.startPos) == '\r')) {
            ++this.startPos;
        }
        if (this.startPos >= sl) {
            return "";
        }
        int bp = this.startPos;
        if (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || !this.canAcceptOpt && (this.formulaSen.charAt(this.startPos) == '-' || this.formulaSen.charAt(this.startPos) == '+')) {
            ++this.startPos;
            int nPoints = 0;
            while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || this.formulaSen.charAt(this.startPos) == '.') && (this.formulaSen.charAt(this.startPos) != '.' || ++nPoints <= 1)) {
                ++this.startPos;
            }
            this.canAcceptOpt = true;
        } else if (this.formulaSen.charAt(this.startPos) >= 'a' && this.formulaSen.charAt(this.startPos) <= 'z' || this.formulaSen.charAt(this.startPos) >= 'A' && this.formulaSen.charAt(this.startPos) <= 'Z' || this.formulaSen.charAt(this.startPos) == '_' || StringRegularOpt.isChineseEscapeSymbol(this.formulaSen.charAt(this.startPos))) {
            ++this.startPos;
            while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || this.formulaSen.charAt(this.startPos) >= 'a' && this.formulaSen.charAt(this.startPos) <= 'z' || this.formulaSen.charAt(this.startPos) >= 'A' && this.formulaSen.charAt(this.startPos) <= 'Z' || this.formulaSen.charAt(this.startPos) == '_' || this.formulaSen.charAt(this.startPos) == '.' || this.colonInLable && this.formulaSen.charAt(this.startPos) == ':' || StringRegularOpt.isChineseEscapeSymbol(this.formulaSen.charAt(this.startPos)))) {
                ++this.startPos;
            }
            this.canAcceptOpt = true;
        } else {
            this.canAcceptOpt = false;
            switch (this.formulaSen.charAt(this.startPos)) {
                case '+': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '+') break;
                    ++this.startPos;
                    break;
                }
                case '-': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '-') break;
                    ++this.startPos;
                    break;
                }
                case '*': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '*' && this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '/') break;
                    ++this.startPos;
                    break;
                }
                case '/': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '/' && this.formulaSen.charAt(this.startPos) != '*') break;
                    ++this.startPos;
                    break;
                }
                case '<': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '>' && this.formulaSen.charAt(this.startPos) != '<') break;
                    ++this.startPos;
                    break;
                }
                case '>': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '>') break;
                    ++this.startPos;
                    break;
                }
                case ':': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=') break;
                    ++this.startPos;
                    break;
                }
                case '!': 
                case '=': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=') break;
                    ++this.startPos;
                    break;
                }
                case '|': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '|') break;
                    ++this.startPos;
                    break;
                }
                case '&': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '&') break;
                    ++this.startPos;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.canAcceptOpt = true;
                    ++this.startPos;
                    break;
                }
                case '.': {
                    ++this.startPos;
                    while (this.startPos < sl && this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9') {
                        ++this.startPos;
                    }
                    break;
                }
                case ')': {
                    this.canAcceptOpt = true;
                    ++this.startPos;
                    break;
                }
                default: {
                    ++this.startPos;
                }
            }
        }
        return this.formulaSen.substring(bp, this.startPos);
    }

    public String getAString() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) == ' ' || this.formulaSen.charAt(this.startPos) == '\t' || this.formulaSen.charAt(this.startPos) == '\n' || this.formulaSen.charAt(this.startPos) == '\r')) {
            ++this.startPos;
        }
        if (this.startPos >= sl) {
            return "";
        }
        int bp = this.startPos;
        if (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || this.formulaSen.charAt(this.startPos) >= 'a' && this.formulaSen.charAt(this.startPos) <= 'z' || this.formulaSen.charAt(this.startPos) >= 'A' && this.formulaSen.charAt(this.startPos) <= 'Z' || this.formulaSen.charAt(this.startPos) == '_' || this.formulaSen.charAt(this.startPos) == '-' || this.formulaSen.charAt(this.startPos) == '.') {
            ++this.startPos;
            while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || this.formulaSen.charAt(this.startPos) >= 'a' && this.formulaSen.charAt(this.startPos) <= 'z' || this.formulaSen.charAt(this.startPos) >= 'A' && this.formulaSen.charAt(this.startPos) <= 'Z' || this.formulaSen.charAt(this.startPos) == '_' || this.formulaSen.charAt(this.startPos) == '-' || this.formulaSen.charAt(this.startPos) == '.')) {
                ++this.startPos;
            }
        } else {
            ++this.startPos;
        }
        return this.formulaSen.substring(bp, this.startPos);
    }

    public String getARegularWord() {
        String s = this.getARawWord();
        int sl = this.formulaSen.length();
        if ("\"".equals(s)) {
            int bp = this.startPos - 1;
            while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '\"') {
                if (this.languageType == 1 && this.formulaSen.charAt(this.startPos) == '\\') {
                    ++this.startPos;
                }
                ++this.startPos;
            }
            if (this.startPos >= sl) {
                return null;
            }
            ++this.startPos;
            this.canAcceptOpt = true;
            s = this.formulaSen.substring(bp, this.startPos);
        } else if ("'".equals(s)) {
            int bp = this.startPos - 1;
            while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '\'') {
                if (this.languageType == 1 && this.formulaSen.charAt(this.startPos) == '\\') {
                    ++this.startPos;
                }
                ++this.startPos;
            }
            if (this.startPos >= sl) {
                return null;
            }
            ++this.startPos;
            this.canAcceptOpt = true;
            s = this.formulaSen.substring(bp, this.startPos);
        } else if ("`".equals(s)) {
            int bp = this.startPos - 1;
            while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '`') {
                ++this.startPos;
            }
            if (this.startPos >= sl) {
                return null;
            }
            ++this.startPos;
            this.canAcceptOpt = true;
            s = this.formulaSen.substring(bp, this.startPos);
        }
        return s;
    }

    public String getAWord() {
        if (this.isBack) {
            this.isBack = false;
            return this.curWord;
        }
        while (true) {
            this.curWord = this.getARegularWord();
            if (this.curWord == null || this.curWord.isEmpty()) break;
            if (this.languageType == 1 && "//".equals(this.curWord) || this.languageType == 2 && "--".equals(this.curWord)) {
                this.seekToLineEnd();
                continue;
            }
            if (this.languageType == 0 || !"/*".equals(this.curWord)) break;
            this.seekToAnnotateEnd();
        }
        return this.curWord;
    }

    public String getAWord(boolean bAcceptOpt) {
        this.canAcceptOpt = bAcceptOpt;
        return this.getAWord();
    }

    public String getARawWord(boolean bAcceptOpt) {
        this.canAcceptOpt = bAcceptOpt;
        return this.getARawWord();
    }

    public void seekToLineEnd() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '\n') {
            ++this.startPos;
        }
    }

    public void seekToAnnotateEnd() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl - 1 && (this.formulaSen.charAt(this.startPos) != '*' || this.formulaSen.charAt(this.startPos + 1) != '/')) {
            ++this.startPos;
        }
        this.startPos = this.startPos < sl - 1 && this.formulaSen.charAt(this.startPos) == '*' && this.formulaSen.charAt(this.startPos + 1) == '/' ? (this.startPos += 2) : sl;
    }

    public boolean seekToRightBracket() {
        int nBracket = 1;
        do {
            String sWord;
            if ((sWord = this.getAWord(false)) == null || sWord.isEmpty()) {
                return false;
            }
            if (sWord.equals("(")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals(")")) continue;
            --nBracket;
        } while (nBracket != 0);
        return true;
    }

    public boolean seekToRightSquareBracket() {
        int nBracket = 1;
        do {
            String sWord;
            if ((sWord = this.getAWord(false)) == null || sWord.isEmpty()) {
                return false;
            }
            if (sWord.equals("[")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals("]")) continue;
            --nBracket;
        } while (nBracket != 0);
        return true;
    }

    public boolean seekToRightBrace() {
        int nBracket = 1;
        do {
            String sWord;
            if ((sWord = this.getAWord(false)) == null || sWord.isEmpty()) {
                return false;
            }
            if (sWord.equals("{")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals("}")) continue;
            --nBracket;
        } while (nBracket != 0);
        return true;
    }

    public void skipAOperand() {
        String sWord;
        int nBracket = 0;
        do {
            if ((sWord = this.getAWord()) == null || sWord.isEmpty()) {
                return;
            }
            if (sWord.equals("(")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals(")") || --nBracket >= 0) continue;
            this.writeBackAWord(")");
            return;
        } while (!sWord.equals(",") || nBracket != 0);
        this.writeBackAWord(",");
    }

    public String getStringUntil(String szBreak) {
        int ep;
        String sWord;
        int bp = this.startPos;
        do {
            ep = this.startPos;
        } while ((sWord = this.getAWord(false)) != null && !sWord.isEmpty() && !sWord.equals(szBreak));
        return this.formulaSen.substring(bp, ep);
    }

    public void resetToBegin() {
        this.isBack = false;
        this.curWord = "";
        this.startPos = 0;
        this.canAcceptOpt = false;
    }

    public boolean setPosition(int newPos) {
        if (this.formulaSen == null || this.formulaSen.length() <= newPos) {
            return false;
        }
        this.isBack = false;
        this.curWord = "";
        this.startPos = newPos;
        this.canAcceptOpt = false;
        return true;
    }

    public boolean seekTo(char cSplit) {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != cSplit) {
            ++this.startPos;
        }
        if (this.startPos < sl) {
            ++this.startPos;
            return true;
        }
        return false;
    }

    public boolean seekTo(String aword, boolean skipAnnotate) {
        do {
            String string = this.curWord = skipAnnotate ? this.getAWord() : this.getARegularWord();
            if (this.curWord != null && !this.curWord.isEmpty()) continue;
            return false;
        } while (!this.curWord.equals(aword));
        return true;
    }

    public String getBuffer(int bp, int ep) {
        if (ep - bp < 1) {
            return null;
        }
        return this.formulaSen.substring(bp, ep);
    }

    public int findWord(String aword, boolean caseSensitives, boolean skipAnnotate) {
        String cWord;
        String string = cWord = skipAnnotate ? this.getAWord() : this.getARegularWord();
        while (!StringBaseOpt.isNvl(cWord)) {
            if (cWord.equals(aword) || !caseSensitives && cWord.equalsIgnoreCase(aword)) {
                return this.getCurrPos() - cWord.length();
            }
            cWord = skipAnnotate ? this.getAWord() : this.getARegularWord();
        }
        return -1;
    }

    public int getNoteType() {
        return this.languageType;
    }

    public void setNoteType(int noteType) {
        this.languageType = noteType;
    }
}

