/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.ByteBaseOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.compiler.EmbedFuncUtils;
import com.centit.support.compiler.FunctionInfo;
import com.centit.support.compiler.Lexer;
import com.centit.support.image.CaptchaImageUtil;
import com.centit.support.json.JSONOpt;
import com.centit.support.network.UrlOptUtils;
import com.centit.support.security.HmacSha1Encoder;
import com.centit.support.security.Md5Encoder;
import com.centit.support.security.SM3Util;
import com.centit.support.security.Sha1Encoder;
import com.centit.support.xml.XMLObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public abstract class EmbedFunc {
    public static final int functionsSum = 80;
    protected static final FunctionInfo[] functionsList = new FunctionInfo[]{new FunctionInfo("getat", -1, 148, 0), new FunctionInfo("byte", 2, 101, 1), new FunctionInfo("capital", 1, 102, 2), new FunctionInfo("if", 2, 108, 0), new FunctionInfo("nvl", 1, 174, 0), new FunctionInfo("case", 2, 116, 0), new FunctionInfo("match", 2, 111, 1), new FunctionInfo("regexmatch", 2, 159, 1), new FunctionInfo("regexmatchvalue", 2, 160, 0), new FunctionInfo("max", -1, 103, 0), new FunctionInfo("min", -1, 104, 0), new FunctionInfo("ave", -1, 100, 1), new FunctionInfo("count", -1, 112, 1), new FunctionInfo("countnotnull", -1, 145, 1), new FunctionInfo("countnull", -1, 144, 1), new FunctionInfo("sum", -1, 105, 1), new FunctionInfo("stddev", -1, 133, 1), new FunctionInfo("distinct", -1, 171, 0), new FunctionInfo("round", -1, 107, 1), new FunctionInfo("floor", -1, 165, 1), new FunctionInfo("ceil", -1, 166, 1), new FunctionInfo("strlen", -1, 156, 1), new FunctionInfo("concat", -1, 106, 2), new FunctionInfo("strcat", -1, 106, 2), new FunctionInfo("isempty", 1, 146, 1), new FunctionInfo("isnotempty", 1, 147, 1), new FunctionInfo("log", 1, 117, 1), new FunctionInfo("ln", 1, 113, 1), new FunctionInfo("sin", 1, 118, 1), new FunctionInfo("cos", 1, 119, 1), new FunctionInfo("tan", 1, 120, 1), new FunctionInfo("ctan", 1, 121, 1), new FunctionInfo("exp", 1, 114, 1), new FunctionInfo("sqrt", 1, 115, 1), new FunctionInfo("upcase", 1, 142, 2), new FunctionInfo("lowcase", 1, 143, 2), new FunctionInfo("substr", 2, 110, 2), new FunctionInfo("lpad", 1, 150, 2), new FunctionInfo("rpad", 1, 151, 2), new FunctionInfo("find", 2, 122, 1), new FunctionInfo("frequence", 2, 123, 1), new FunctionInfo("split", 1, 167, 2), new FunctionInfo("replace", -1, 175, 2), new FunctionInfo("int", 1, 124, 1), new FunctionInfo("integer", 1, 124, 1), new FunctionInfo("frac", 1, 125, 1), new FunctionInfo("today", -1, 149, 3), new FunctionInfo("currentDate", -1, 132, 3), new FunctionInfo("currentDatetime", -1, 149, 3), new FunctionInfo("currentTimestamp", -1, 155, 3), new FunctionInfo("day", -1, 126, 2), new FunctionInfo("month", -1, 127, 2), new FunctionInfo("year", -1, 128, 2), new FunctionInfo("week", -1, 161, 2), new FunctionInfo("weekday", -1, 162, 2), new FunctionInfo("formatdate", 1, 163, 2), new FunctionInfo("dateinfo", -1, 164, 2), new FunctionInfo("dayspan", -1, 129, 1), new FunctionInfo("datespan", -1, 157, 1), new FunctionInfo("adddate", 2, 158, 0), new FunctionInfo("adddays", 2, 137, 0), new FunctionInfo("addmonths", 2, 138, 0), new FunctionInfo("addyears", 2, 139, 0), new FunctionInfo("truncdate", -1, 140, 0), new FunctionInfo("lastofmonth", -1, 141, 0), new FunctionInfo("toDate", 1, 152, 3), new FunctionInfo("toString", 1, 153, 2), new FunctionInfo("toJsonString", 1, 178, 2), new FunctionInfo("toUrlString", 1, 181, 2), new FunctionInfo("toObject", 1, 170, 0), new FunctionInfo("toNumber", 1, 154, 1), new FunctionInfo("toByteArray", 1, 176, 0), new FunctionInfo("attr", 2, 168, 0), new FunctionInfo("setAttr", 3, 169, 0), new FunctionInfo("getpy", 1, 135, 2), new FunctionInfo("random", -1, 172, 0), new FunctionInfo("hash", 1, 173, 2), new FunctionInfo("eval", -1, 177, 0), new FunctionInfo("encode", 1, 179, 2), new FunctionInfo("decode", 1, 180, 0)};
    private static final double COMPARE_MIN_DOUBLE = 1.0E-7;

    private EmbedFunc() {
        throw new IllegalAccessError("Utility class");
    }

    public static int getFuncNo(String sFuncName) {
        for (int i = 0; i < 80; ++i) {
            if (!sFuncName.equalsIgnoreCase(EmbedFunc.functionsList[i].sName)) continue;
            return i;
        }
        return -1;
    }

    private static LeftRightPair<Integer, List<Object>> flatOperands(List<Object> slOperand) {
        int nCount = 0;
        ArrayList<Object> ret = new ArrayList<Object>();
        if (slOperand != null && !slOperand.isEmpty()) {
            for (Object obj : slOperand) {
                if (obj instanceof Object[]) {
                    Object[] objs;
                    for (Object obj1 : objs = (Object[])obj) {
                        ret.add(obj1);
                        ++nCount;
                    }
                    continue;
                }
                if (obj instanceof Collection) {
                    ret.addAll((Collection)obj);
                    nCount += ((Collection)obj).size();
                    continue;
                }
                ret.add(obj);
                ++nCount;
            }
        }
        return new LeftRightPair<Integer, List<Object>>(nCount, ret);
    }

    private static LeftRightPair<Date, Object> fetchDateOpt(int nOpSum, List<Object> slOperand) {
        Date dt = null;
        Object ti = null;
        if (nOpSum == 1) {
            dt = DatetimeOpt.currentUtilDate();
            if (NumberBaseOpt.isNumber(slOperand.get(0))) {
                ti = slOperand.get(0);
            }
        } else if (nOpSum > 1) {
            dt = DatetimeOpt.castObjectToDate(slOperand.get(0));
            if (NumberBaseOpt.isNumber(slOperand.get(1))) {
                ti = slOperand.get(1);
            }
        }
        return new LeftRightPair<Date, Object>(dt, ti);
    }

    public static Object runFuncWithObject(List<Object> slOperand, int funcID) {
        int nOpSum = slOperand == null ? 0 : slOperand.size();
        double dbtemp = 0.0;
        switch (funcID) {
            case 100: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                nOpSum = 0;
                for (int i = 0; i < opt.getLeft(); ++i) {
                    Double db = NumberBaseOpt.castObjectToDouble(opt.getRight().get(i));
                    if (db == null) continue;
                    dbtemp += db.doubleValue();
                    ++nOpSum;
                }
                if (nOpSum > 0) {
                    return dbtemp / (double)nOpSum;
                }
                return null;
            }
            case 171: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                if (opt.getLeft() < 2) {
                    return opt.getRight();
                }
                ArrayList<Object> retObjs = new ArrayList<Object>();
                for (Object obj : opt.getRight()) {
                    if (obj == null || retObjs.contains(obj)) continue;
                    retObjs.add(obj);
                }
                return retObjs;
            }
            case 148: {
                Integer nbit;
                if (nOpSum < 2) {
                    return null;
                }
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                Object objTemp = slOperand.get(0);
                if (NumberBaseOpt.isNumber(objTemp) && (nbit = NumberBaseOpt.castObjectToInteger(objTemp)) != null) {
                    if (nbit < 0) {
                        nbit = opt.getLeft() - 1 + nbit;
                    }
                    if (nbit >= 0 && nbit < opt.getLeft() - 1) {
                        return opt.getRight().get(nbit + 1);
                    }
                }
                return null;
            }
            case 101: {
                if (nOpSum < 2 || !NumberBaseOpt.isNumber(slOperand.get(1))) {
                    return null;
                }
                Object objTemp = slOperand.get(0);
                int nbit = NumberBaseOpt.castObjectToInteger(slOperand.get(1));
                if (NumberBaseOpt.isNumber(objTemp)) {
                    return String.valueOf(NumberBaseOpt.getNumByte(StringBaseOpt.objectToString(objTemp), nbit));
                }
                if (objTemp != null) {
                    String tempstr = StringBaseOpt.objectToString(objTemp);
                    int sl = tempstr.length();
                    if (nbit >= 0 && nbit < sl) {
                        return String.valueOf(tempstr.charAt(nbit));
                    }
                }
                return null;
            }
            case 111: {
                if (nOpSum < 2) {
                    return false;
                }
                int wildcardType = 2;
                if (nOpSum > 2 && ((wildcardType = NumberBaseOpt.castObjectToInteger(slOperand.get(2), 2).intValue()) < 0 || wildcardType > 2)) {
                    wildcardType = 2;
                }
                return StringRegularOpt.isMatch(StringBaseOpt.objectToString(slOperand.get(0)), StringBaseOpt.objectToString(slOperand.get(1)), wildcardType);
            }
            case 159: {
                if (nOpSum < 2) {
                    return false;
                }
                return Pattern.compile(StringBaseOpt.objectToString(slOperand.get(0))).matcher(StringBaseOpt.objectToString(slOperand.get(1))).find();
            }
            case 160: {
                if (nOpSum < 2) {
                    return false;
                }
                String sValues = StringBaseOpt.objectToString(slOperand.get(1));
                Pattern p = Pattern.compile(StringBaseOpt.objectToString(slOperand.get(0)));
                Matcher m = p.matcher(sValues);
                ArrayList<String> matchValues = new ArrayList<String>();
                while (m.find()) {
                    matchValues.add(sValues.substring(m.start(), m.end()));
                }
                if (matchValues.isEmpty()) {
                    return null;
                }
                if (matchValues.size() == 1) {
                    return matchValues.get(0);
                }
                return matchValues;
            }
            case 102: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return StringUtils.upperCase((String)StringBaseOpt.objectToString(slOperand.get(0)));
                }
                if (nOpSum == 1) {
                    return NumberBaseOpt.capitalization(StringBaseOpt.objectToString(slOperand.get(0)));
                }
                String ct = StringBaseOpt.castObjectToString(slOperand.get(1), "N");
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)ct, (CharSequence[])new CharSequence[]{"r", "rmb", "yuan"})) {
                    return EmbedFuncUtils.instance.capitalRMB(slOperand.get(0));
                }
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)ct, (CharSequence[])new CharSequence[]{"yjf", "yuanjiaofen"})) {
                    return EmbedFuncUtils.instance.capitalRmbYJF(slOperand.get(0));
                }
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)ct, (CharSequence[])new CharSequence[]{"s", "simple"})) {
                    return NumberBaseOpt.capitalization(StringBaseOpt.objectToString(slOperand.get(0)), true);
                }
                return NumberBaseOpt.capitalization(StringBaseOpt.objectToString(slOperand.get(0)));
            }
            case 103: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                return GeneralAlgorithm.maxObject((Collection<Object>)opt.getRight());
            }
            case 104: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                return GeneralAlgorithm.minObject((Collection<Object>)opt.getRight());
            }
            case 112: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                return opt.getLeft();
            }
            case 145: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                int nc = 0;
                for (Object obj : opt.getRight()) {
                    String s;
                    if (obj == null || !StringUtils.isNotBlank((CharSequence)(s = StringBaseOpt.objectToString(obj))) || "''".equals(s) || "\"\"".equals(s)) continue;
                    ++nc;
                }
                return nc;
            }
            case 144: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                int nc = 0;
                for (Object obj : opt.getRight()) {
                    if (obj == null) {
                        ++nc;
                        continue;
                    }
                    String s = StringBaseOpt.objectToString(obj);
                    if (!StringUtils.isBlank((CharSequence)s) && !"''".equals(s) && !"\"\"".equals(s)) continue;
                    ++nc;
                }
                return nc;
            }
            case 105: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                return GeneralAlgorithm.sumObjects((Collection<Object>)opt.getRight());
            }
            case 133: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                if (opt.getLeft() < 2) {
                    return 0;
                }
                int numberSum = 0;
                for (int i = 0; i < opt.getLeft(); ++i) {
                    if (!NumberBaseOpt.isNumber(opt.getRight().get(i))) continue;
                    ++numberSum;
                    dbtemp += NumberBaseOpt.castObjectToDouble(opt.getRight().get(i), 0.0).doubleValue();
                }
                if (numberSum < 2) {
                    return 0;
                }
                double dbAvg = dbtemp / (double)numberSum;
                dbtemp = 0.0;
                for (int i = 0; i < opt.getLeft(); ++i) {
                    if (!NumberBaseOpt.isNumber(opt.getRight().get(i))) continue;
                    double dtp = NumberBaseOpt.castObjectToDouble(opt.getRight().get(i), 0.0) - dbAvg;
                    dbtemp += dtp * dtp;
                }
                return Math.sqrt(dbtemp / (double)(numberSum - 1));
            }
            case 106: {
                if (nOpSum < 1) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nOpSum; ++i) {
                    sb.append(StringBaseOpt.castObjectToString(slOperand.get(i), ""));
                }
                return sb.toString();
            }
            case 156: {
                if (nOpSum < 1) {
                    return null;
                }
                String checkValue = StringBaseOpt.castObjectToString(slOperand.get(0), "");
                return checkValue.length();
            }
            case 110: {
                if (nOpSum < 1) {
                    return null;
                }
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                if (slOperand.get(0) == null) {
                    return null;
                }
                int nStart = 0;
                if (NumberBaseOpt.isNumber(slOperand.get(1))) {
                    nStart = NumberBaseOpt.castObjectToInteger(slOperand.get(1));
                }
                String tempStr = StringBaseOpt.objectToString(slOperand.get(0));
                int nLength = nOpSum > 2 && NumberBaseOpt.isNumber(slOperand.get(2)) ? NumberBaseOpt.castObjectToInteger(slOperand.get(2)) : tempStr.length() - nStart;
                if (nLength <= 0) {
                    nLength = 1;
                }
                return tempStr.substring(nStart, nStart + nLength);
            }
            case 150: {
                if (nOpSum < 1) {
                    return null;
                }
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                int nLength = NumberBaseOpt.castObjectToInteger(slOperand.get(1), 0);
                if (nOpSum > 2) {
                    String padChar = StringBaseOpt.castObjectToString(slOperand.get(2));
                    return StringUtils.leftPad((String)StringBaseOpt.castObjectToString(slOperand.get(0)), (int)nLength, (String)padChar);
                }
                return StringUtils.leftPad((String)StringBaseOpt.castObjectToString(slOperand.get(0)), (int)nLength);
            }
            case 151: {
                if (nOpSum < 1) {
                    return null;
                }
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                int nLength = NumberBaseOpt.castObjectToInteger(slOperand.get(1), 0);
                if (nOpSum > 2) {
                    String padChar = StringBaseOpt.castObjectToString(slOperand.get(2));
                    return StringUtils.rightPad((String)StringBaseOpt.castObjectToString(slOperand.get(0)), (int)nLength, (String)padChar);
                }
                return StringUtils.rightPad((String)StringBaseOpt.castObjectToString(slOperand.get(0)), (int)nLength);
            }
            case 122: {
                if (nOpSum < 2) {
                    return -1;
                }
                int nStart = 0;
                Object obj = slOperand.get(0);
                if (obj instanceof Collection) {
                    if (obj instanceof List) {
                        List list = (List)obj;
                        return list.indexOf(slOperand.get(1));
                    }
                    return ((Collection)obj).contains(slOperand.get(1)) ? 1 : -1;
                }
                String tempStr = StringBaseOpt.objectToString(obj);
                String findType = null;
                if (nOpSum > 2) {
                    if (NumberBaseOpt.isNumber(slOperand.get(2))) {
                        nStart = NumberBaseOpt.castObjectToInteger(slOperand.get(2));
                    } else {
                        findType = StringBaseOpt.castObjectToString(slOperand.get(2));
                    }
                }
                if (nOpSum > 3) {
                    if (NumberBaseOpt.isNumber(slOperand.get(3))) {
                        nStart = NumberBaseOpt.castObjectToInteger(slOperand.get(3));
                    } else {
                        findType = StringBaseOpt.castObjectToString(slOperand.get(3));
                    }
                }
                if (nStart < 0) {
                    nStart = 0;
                }
                if (StringUtils.indexOfIgnoreCase(findType, (CharSequence)"W") >= 0) {
                    Lexer lexer = nStart > 0 ? new Lexer(tempStr.substring(nStart)) : new Lexer(tempStr);
                    int nPos = lexer.findWord(StringBaseOpt.objectToString(slOperand.get(1)), StringUtils.indexOfIgnoreCase((CharSequence)findType, (CharSequence)"C") >= 0, false);
                    return nPos >= 0 ? nPos + nStart : nPos;
                }
                if (StringUtils.indexOfIgnoreCase((CharSequence)findType, (CharSequence)"C") >= 0) {
                    return tempStr.indexOf(StringBaseOpt.objectToString(slOperand.get(1)), nStart);
                }
                return StringUtils.indexOfIgnoreCase((CharSequence)tempStr, (CharSequence)StringBaseOpt.objectToString(slOperand.get(1)), (int)nStart);
            }
            case 142: {
                if (nOpSum < 1) {
                    return null;
                }
                return StringUtils.upperCase((String)StringBaseOpt.objectToString(slOperand.get(0)));
            }
            case 143: {
                if (nOpSum < 1) {
                    return null;
                }
                return StringUtils.lowerCase((String)StringBaseOpt.objectToString(slOperand.get(0)));
            }
            case 123: {
                if (nOpSum < 2) {
                    return -1;
                }
                if (slOperand.get(0) == null || slOperand.get(1) == null) {
                    return 0;
                }
                String tempStr = StringBaseOpt.objectToString(slOperand.get(0));
                String str = StringBaseOpt.objectToString(slOperand.get(1));
                int nSt = 0;
                int sl = str.length();
                int nC = 0;
                if (sl == 0) {
                    return 0;
                }
                nSt = tempStr.indexOf(str, nSt);
                while (nSt >= 0) {
                    ++nC;
                    nSt += sl;
                    nSt = tempStr.indexOf(str, nSt);
                }
                return nC;
            }
            case 167: {
                String splitStr;
                if (nOpSum < 1) {
                    return null;
                }
                String str = StringBaseOpt.castObjectToString(slOperand.get(0));
                if (StringUtils.isBlank((CharSequence)str)) {
                    return null;
                }
                String string = splitStr = nOpSum > 1 ? StringBaseOpt.castObjectToString(slOperand.get(1), ",") : ",";
                if (StringUtils.equalsAny((CharSequence)splitStr, (CharSequence[])new CharSequence[]{".", "*", "?", "$", "+", "|", "\\"})) {
                    splitStr = String.format("\\%s", splitStr);
                }
                return str.split(splitStr);
            }
            case 175: {
                if (nOpSum == 0) {
                    return null;
                }
                if (nOpSum == 1) {
                    return slOperand.get(0);
                }
                if (nOpSum == 2) {
                    if (slOperand.get(1) instanceof Map) {
                        String resStr = StringBaseOpt.castObjectToString(slOperand.get(0));
                        for (Map.Entry ent : ((Map)slOperand.get(1)).entrySet()) {
                            resStr = StringUtils.replace((String)resStr, (String)StringBaseOpt.castObjectToString(ent.getKey()), (String)StringBaseOpt.castObjectToString(ent.getValue()));
                        }
                        return resStr;
                    }
                    return slOperand.get(0);
                }
                String resStr = StringBaseOpt.castObjectToString(slOperand.get(0));
                for (int i = 1; i < nOpSum - 1; i += 2) {
                    resStr = StringUtils.replace((String)resStr, (String)StringBaseOpt.castObjectToString(slOperand.get(i)), (String)StringBaseOpt.castObjectToString(slOperand.get(i + 1)));
                }
                return resStr;
            }
            case 124: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return slOperand.get(0);
                }
                return NumberBaseOpt.castObjectToInteger(slOperand.get(0));
            }
            case 107: {
                int pos;
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return slOperand.get(0);
                }
                Double tempDouble = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                int n = pos = nOpSum > 1 ? NumberBaseOpt.castObjectToInteger(slOperand.get(1), 0) : 0;
                if (pos != 0) {
                    return NumberBaseOpt.round(tempDouble, pos);
                }
                return Math.round(tempDouble);
            }
            case 165: {
                int pos;
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return slOperand.get(0);
                }
                Double tempDouble = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                int n = pos = nOpSum > 1 ? NumberBaseOpt.castObjectToInteger(slOperand.get(1), 0) : 0;
                if (pos != 0) {
                    return NumberBaseOpt.floor(tempDouble, pos);
                }
                return Double.valueOf(Math.floor(tempDouble)).longValue();
            }
            case 166: {
                int pos;
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return slOperand.get(0);
                }
                Double tempDouble = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                int n = pos = nOpSum > 1 ? NumberBaseOpt.castObjectToInteger(slOperand.get(1), 0) : 0;
                if (pos != 0) {
                    return NumberBaseOpt.ceil(tempDouble, pos);
                }
                return Double.valueOf(Math.ceil(tempDouble)).longValue();
            }
            case 146: {
                if (nOpSum < 1) {
                    return true;
                }
                for (int i = 0; i < nOpSum; ++i) {
                    if (GeneralAlgorithm.isEmpty(slOperand.get(i))) continue;
                    return false;
                }
                return true;
            }
            case 147: {
                if (nOpSum < 1) {
                    return false;
                }
                for (int i = 0; i < nOpSum; ++i) {
                    if (GeneralAlgorithm.isEmpty(slOperand.get(i))) continue;
                    return true;
                }
                return false;
            }
            case 113: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                return Math.log(af);
            }
            case 117: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                return Math.log10(af);
            }
            case 118: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                return Math.sin(af);
            }
            case 119: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                return Math.cos(af);
            }
            case 120: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                return Math.tan(af);
            }
            case 121: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                return Math.atan(af);
            }
            case 125: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return null;
                }
                Double af = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                return new BigDecimal(af.toString()).subtract(new BigDecimal(af.intValue())).doubleValue();
            }
            case 114: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                return Math.exp(af);
            }
            case 115: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber(slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                return Math.sqrt(af);
            }
            case 108: {
                if (nOpSum < 1) {
                    return null;
                }
                return EmbedFuncUtils.instance.ifElse(slOperand.toArray());
            }
            case 174: {
                if (nOpSum < 1) {
                    return null;
                }
                if (nOpSum == 1 || slOperand.get(0) != null) {
                    return slOperand.get(0);
                }
                return slOperand.get(1);
            }
            case 116: {
                if (nOpSum < 2) {
                    return null;
                }
                String tempStr = StringBaseOpt.objectToString(slOperand.get(0));
                int MatchType = 0;
                if ("true".equalsIgnoreCase(tempStr)) {
                    MatchType = 1;
                } else if (NumberBaseOpt.isNumber(slOperand.get(0))) {
                    dbtemp = NumberBaseOpt.castObjectToDouble(slOperand.get(0));
                    MatchType = 2;
                }
                int i = 1;
                while (i + 1 < nOpSum) {
                    if (MatchType == 1 ? BooleanBaseOpt.castObjectToBoolean(slOperand.get(i), false) != false : (MatchType == 2 ? NumberBaseOpt.isNumber(slOperand.get(i)) && Math.abs(dbtemp - NumberBaseOpt.castObjectToDouble(slOperand.get(i))) < 1.0E-7 : StringUtils.equals((CharSequence)tempStr, (CharSequence)StringBaseOpt.objectToString(slOperand.get(i))))) {
                        return slOperand.get(i + 1);
                    }
                    i += 2;
                }
                if (nOpSum % 2 == 0) {
                    return slOperand.get(nOpSum - 1);
                }
                return null;
            }
            case 132: {
                return DatetimeOpt.truncateToDay(DatetimeOpt.currentUtilDate());
            }
            case 149: {
                return DatetimeOpt.currentUtilDate();
            }
            case 155: {
                return DatetimeOpt.currentSqlTimeStamp();
            }
            case 126: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate(slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getDay(dt);
            }
            case 127: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate(slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getMonth(dt);
            }
            case 128: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate(slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getYear(dt);
            }
            case 161: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate(slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getWeekOfYear(dt);
            }
            case 162: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate(slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getDayOfWeek(dt);
            }
            case 163: {
                if (nOpSum < 1) {
                    return null;
                }
                return EmbedFuncUtils.instance.formatDate(slOperand.toArray());
            }
            case 164: {
                Date dt;
                if (nOpSum < 1) {
                    return null;
                }
                int field = NumberBaseOpt.castObjectToInteger(slOperand.get(0), 0);
                Date date = dt = nOpSum > 1 ? DatetimeOpt.castObjectToDate(slOperand.get(1)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(dt);
                return cal.get(field);
            }
            case 129: {
                if (nOpSum < 2) {
                    return null;
                }
                Date dt = DatetimeOpt.castObjectToDate(slOperand.get(0));
                Date dt2 = DatetimeOpt.castObjectToDate(slOperand.get(1));
                if (dt == null || dt2 == null) {
                    return null;
                }
                return DatetimeOpt.calcSpanDays(dt, dt2);
            }
            case 157: {
                if (nOpSum < 2) {
                    return null;
                }
                Date dt = DatetimeOpt.castObjectToDate(slOperand.get(0));
                Date dt2 = DatetimeOpt.castObjectToDate(slOperand.get(1));
                if (dt == null || dt2 == null) {
                    return null;
                }
                return DatetimeOpt.calcDateSpan(dt, dt2);
            }
            case 158: {
                LeftRightPair<Date, Object> dateOpt = EmbedFunc.fetchDateOpt(nOpSum, slOperand);
                if (dateOpt.getLeft() == null || dateOpt.getRight() == null) {
                    return null;
                }
                return DatetimeOpt.addDays(dateOpt.getLeft(), NumberBaseOpt.castObjectToFloat(dateOpt.getRight()).floatValue());
            }
            case 137: {
                LeftRightPair<Date, Object> dateOpt = EmbedFunc.fetchDateOpt(nOpSum, slOperand);
                if (dateOpt.getLeft() == null || dateOpt.getRight() == null) {
                    return null;
                }
                if (dateOpt.getRight() instanceof Integer || dateOpt.getRight() instanceof Long) {
                    return DatetimeOpt.addDays(dateOpt.getLeft(), NumberBaseOpt.castObjectToInteger(dateOpt.getRight()));
                }
                return DatetimeOpt.addDays(dateOpt.getLeft(), NumberBaseOpt.castObjectToFloat(dateOpt.getRight()).floatValue());
            }
            case 138: {
                LeftRightPair<Date, Object> dateOpt = EmbedFunc.fetchDateOpt(nOpSum, slOperand);
                if (dateOpt.getLeft() == null || dateOpt.getRight() == null) {
                    return null;
                }
                return DatetimeOpt.addMonths(dateOpt.getLeft(), NumberBaseOpt.castObjectToInteger(dateOpt.getRight()));
            }
            case 139: {
                LeftRightPair<Date, Object> dateOpt = EmbedFunc.fetchDateOpt(nOpSum, slOperand);
                if (dateOpt.getLeft() == null || dateOpt.getRight() == null) {
                    return null;
                }
                return DatetimeOpt.addYears(dateOpt.getLeft(), NumberBaseOpt.castObjectToInteger(dateOpt.getRight()));
            }
            case 140: {
                Date dt = null;
                Object ti = null;
                if (nOpSum == 1) {
                    dt = DatetimeOpt.currentUtilDate();
                    ti = slOperand.get(0);
                } else if (nOpSum > 1) {
                    dt = DatetimeOpt.castObjectToDate(slOperand.get(0));
                    if (dt == null) {
                        dt = DatetimeOpt.currentUtilDate();
                    }
                    ti = slOperand.get(1);
                }
                String tempStr = StringBaseOpt.objectToString(ti);
                if ("M".equalsIgnoreCase(tempStr)) {
                    return DatetimeOpt.truncateToMonth(dt);
                }
                if ("Y".equalsIgnoreCase(tempStr)) {
                    return DatetimeOpt.truncateToYear(dt);
                }
                if ("W".equalsIgnoreCase(tempStr)) {
                    return DatetimeOpt.truncateToWeek(dt);
                }
                return DatetimeOpt.truncateToDay(dt);
            }
            case 141: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate(slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.seekEndOfMonth(dt);
            }
            case 152: {
                Object dt;
                Object object = dt = nOpSum > 0 ? slOperand.get(0) : null;
                if (dt == null) {
                    return DatetimeOpt.currentUtilDate();
                }
                if (nOpSum > 1) {
                    return DatetimeOpt.convertStringToDate(StringBaseOpt.castObjectToString(dt), StringBaseOpt.castObjectToString(slOperand.get(1)));
                }
                return DatetimeOpt.castObjectToDate(dt);
            }
            case 153: {
                if (nOpSum < 1) {
                    return null;
                }
                for (int i = 0; i < nOpSum; ++i) {
                    String sValue = StringBaseOpt.castObjectToString(slOperand.get(i));
                    if (!StringUtils.isNotBlank((CharSequence)sValue)) continue;
                    return sValue;
                }
                return null;
            }
            case 178: {
                if (nOpSum < 1) {
                    return null;
                }
                if (slOperand.get(0) instanceof String) {
                    return slOperand.get(0);
                }
                return JSON.toJSONString((Object)slOperand.get(0));
            }
            case 181: {
                if (nOpSum < 1) {
                    return null;
                }
                return UrlOptUtils.objectToUrlString(slOperand.get(0));
            }
            case 176: {
                if (nOpSum < 1) {
                    return null;
                }
                return ByteBaseOpt.castObjectToBytes(slOperand.get(0));
            }
            case 170: {
                if (nOpSum < 1 || slOperand.get(0) == null) {
                    return null;
                }
                if (slOperand.get(0) instanceof String) {
                    String objType = "json";
                    if (nOpSum > 1) {
                        objType = StringBaseOpt.castObjectToString(slOperand.get(1));
                    }
                    if ("xml".equalsIgnoreCase(objType)) {
                        return XMLObject.xmlStringToObject((String)slOperand.get(0));
                    }
                    return JSON.parse((String)((String)slOperand.get(0)));
                }
                return slOperand.get(0);
            }
            case 154: {
                if (nOpSum < 1) {
                    return null;
                }
                Number num = NumberBaseOpt.castObjectToNumber(slOperand.get(0));
                if (num == null && nOpSum > 1) {
                    return slOperand.get(1);
                }
                return num;
            }
            case 135: {
                if (nOpSum < 1) {
                    return null;
                }
                String pinYinType = "0";
                if (nOpSum > 1) {
                    pinYinType = StringBaseOpt.castObjectToString(slOperand.get(1));
                }
                if ("1".equals(pinYinType)) {
                    return StringBaseOpt.getPinYin(StringBaseOpt.objectToString(slOperand.get(0)));
                }
                return StringBaseOpt.getFirstLetter(StringBaseOpt.objectToString(slOperand.get(0)));
            }
            case 168: {
                if (nOpSum < 2) {
                    return null;
                }
                return ReflectionOpt.attainExpressionValue(slOperand.get(0), StringBaseOpt.castObjectToString(slOperand.get(1)));
            }
            case 169: {
                if (nOpSum < 1) {
                    return null;
                }
                if (nOpSum < 3) {
                    return slOperand.get(0);
                }
                Object object = JSON.toJSON((Object)slOperand.get(0));
                if (object instanceof JSONObject) {
                    JSONObject json = (JSONObject)object;
                    JSONOpt.setAttribute(json, StringBaseOpt.castObjectToString(slOperand.get(1)), slOperand.get(2));
                    return json;
                }
                return slOperand.get(0);
            }
            case 172: {
                int nMax;
                if (nOpSum < 1) {
                    return Math.random();
                }
                if (nOpSum < 2) {
                    Random rand = new Random();
                    int nInd = NumberBaseOpt.castObjectToInteger(slOperand.get(0), 10000);
                    return rand.nextInt(nInd);
                }
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)StringBaseOpt.castObjectToString(slOperand.get(0)), (CharSequence[])new CharSequence[]{"str", "string"})) {
                    if (StringUtils.equalsAnyIgnoreCase((CharSequence)StringBaseOpt.castObjectToString(slOperand.get(1)), (CharSequence[])new CharSequence[]{"uuid", "uuid32"})) {
                        return UuidOpt.getUuidAsString32();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)StringBaseOpt.castObjectToString(slOperand.get(1)), (CharSequence)"uuid22")) {
                        return UuidOpt.getUuidAsString22();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)StringBaseOpt.castObjectToString(slOperand.get(1)), (CharSequence)"uuid36")) {
                        return UuidOpt.getUuidAsString36();
                    }
                    int nInd = NumberBaseOpt.castObjectToInteger(slOperand.get(1), 20);
                    return CaptchaImageUtil.getRandomString(nInd);
                }
                int nMin = NumberBaseOpt.castObjectToInteger(slOperand.get(0), 1);
                if (nMin > (nMax = NumberBaseOpt.castObjectToInteger(slOperand.get(1), 10000).intValue())) {
                    int a = nMin;
                    nMin = nMax;
                    nMax = a;
                }
                if (nMin == nMax) {
                    ++nMax;
                }
                Random rand = new Random();
                return rand.nextInt(nMax - nMin) + nMin;
            }
            case 173: {
                byte[] hashData;
                String ec;
                if (nOpSum < 1) {
                    return null;
                }
                String hashType = "MD5";
                String encodeType = "HEX";
                String secretKey = "";
                if (nOpSum > 1) {
                    String ht = StringBaseOpt.castObjectToString(slOperand.get(1));
                    if (StringUtils.equalsAnyIgnoreCase((CharSequence)ht, (CharSequence[])new CharSequence[]{"sha", "sha1", "sha-1"})) {
                        hashType = "SHA";
                    } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)ht, (CharSequence[])new CharSequence[]{"hmac-sha1", "macsha", "hmacsha", "hmacsha1"})) {
                        hashType = "HMAC-SHA";
                    } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)ht, (CharSequence[])new CharSequence[]{"sm", "sm3"})) {
                        hashType = "SM3";
                    } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)ht, (CharSequence[])new CharSequence[]{"hmac-sm3", "sm3-hmac"})) {
                        hashType = "HMAC-SM3";
                    }
                }
                if (nOpSum == 3) {
                    if (StringUtils.equalsAnyIgnoreCase((CharSequence)hashType, (CharSequence[])new CharSequence[]{"SHA", "MD5", "SM3"})) {
                        ec = StringBaseOpt.castObjectToString(slOperand.get(2));
                        if (StringUtils.equalsAnyIgnoreCase((CharSequence)ec, (CharSequence[])new CharSequence[]{"base64urlsafe", "urlsafe"})) {
                            encodeType = "BASE64URL";
                        } else if (StringUtils.equalsIgnoreCase((CharSequence)ec, (CharSequence)"base64")) {
                            encodeType = "BASE64";
                        }
                    } else {
                        secretKey = StringBaseOpt.castObjectToString(slOperand.get(2));
                    }
                }
                if (nOpSum == 4) {
                    ec = StringBaseOpt.castObjectToString(slOperand.get(3));
                    if (StringUtils.equalsAnyIgnoreCase((CharSequence)ec, (CharSequence[])new CharSequence[]{"base64urlsafe", "urlsafe"})) {
                        encodeType = "BASE64URL";
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)ec, (CharSequence)"base64")) {
                        encodeType = "BASE64";
                    }
                }
                switch (hashType) {
                    case "SM3": {
                        hashData = SM3Util.hash(ByteBaseOpt.castObjectToBytes(slOperand.get(0)));
                        break;
                    }
                    case "SHA": {
                        hashData = Sha1Encoder.rawEncode(ByteBaseOpt.castObjectToBytes(slOperand.get(0)));
                        break;
                    }
                    case "HMAC-SM3": {
                        hashData = SM3Util.hmac(ByteBaseOpt.castObjectToBytes(slOperand.get(0)), ByteBaseOpt.castObjectToBytes(secretKey));
                        break;
                    }
                    case "HMAC-SHA": {
                        hashData = HmacSha1Encoder.rawEncode(ByteBaseOpt.castObjectToBytes(slOperand.get(0)), secretKey);
                        break;
                    }
                    default: {
                        hashData = Md5Encoder.rawEncode(ByteBaseOpt.castObjectToBytes(slOperand.get(0)));
                    }
                }
                switch (encodeType) {
                    case "BASE64URL": {
                        return Base64.encodeBase64URLSafeString((byte[])hashData);
                    }
                    case "BASE64": {
                        return Base64.encodeBase64String((byte[])hashData);
                    }
                }
                return String.valueOf(Hex.encodeHex((byte[])hashData));
            }
            case 179: {
                byte[] data;
                if (nOpSum < 1) {
                    return null;
                }
                String encodeType = "HEX";
                if (nOpSum > 1) {
                    String ec = StringBaseOpt.castObjectToString(slOperand.get(1));
                    if (StringUtils.equalsAnyIgnoreCase((CharSequence)ec, (CharSequence[])new CharSequence[]{"base64urlsafe", "urlsafe"})) {
                        encodeType = "BASE64URL";
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)ec, (CharSequence)"base64")) {
                        encodeType = "BASE64";
                    }
                }
                if ((data = ByteBaseOpt.castObjectToBytes(slOperand.get(0))) == null || data.length == 0) {
                    return null;
                }
                switch (encodeType) {
                    case "BASE64URL": {
                        return Base64.encodeBase64URLSafeString((byte[])data);
                    }
                    case "BASE64": {
                        return Base64.encodeBase64String((byte[])data);
                    }
                }
                return String.valueOf(Hex.encodeHex((byte[])data));
            }
            case 180: {
                String ec;
                if (nOpSum < 1) {
                    return null;
                }
                String encodeType = "HEX";
                if (nOpSum > 1 && StringUtils.equalsAnyIgnoreCase((CharSequence)(ec = StringBaseOpt.castObjectToString(slOperand.get(1))), (CharSequence[])new CharSequence[]{"base64urlsafe", "urlsafe", "base64"})) {
                    encodeType = "BASE64";
                }
                switch (encodeType) {
                    case "BASE64": {
                        return Base64.decodeBase64((byte[])ByteBaseOpt.castObjectToBytes(slOperand.get(0)));
                    }
                }
                try {
                    return Hex.decodeHex((String)StringBaseOpt.castObjectToString(slOperand.get(0)));
                }
                catch (DecoderException e) {
                    return "";
                }
            }
        }
        return null;
    }
}

