/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class ObjectException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_EXCEPTION = 601;
    public static final int NULL_EXCEPTION = 602;
    public static final int BLANK_EXCEPTION = 603;
    public static final int DATA_NOT_FOUND_EXCEPTION = 604;
    public static final int EMPTY_RESULT_EXCEPTION = 605;
    public static final int FORMAT_DATE_EXCEPTION = 606;
    public static final int FORMAT_NUMBER_EXCEPTION = 607;
    public static final int FORMULA_GRAMMAR_ERROE = 608;
    public static final int LOGICAL_RULE_ERROE = 609;
    public static final int DATA_NOT_INTEGRATED = 610;
    public static final int DATA_VALIDATE_ERROR = 611;
    public static final int SYSTEM_CONFIG_ERROR = 612;
    public static final int FUNCTION_NOT_SUPPORT = 613;
    public static final int PARAMETER_NOT_CORRECT = 614;
    public static final int RUN_FUNC_NOT_CORRECT = 615;
    public static final int SYSTEM_CALL_NOT_CORRECT = 615;
    public static final int DATABASE_OPERATE_EXCEPTION = 620;
    public static final int DATABASE_OUT_SYNC_EXCEPTION = 621;
    public static final int DATABASE_SQL_EXCEPTION = 622;
    public static final int DATABASE_IO_EXCEPTION = 623;
    public static final int NOSUCHFIELD_EXCEPTION = 624;
    public static final int INSTANTIATION_EXCEPTION = 625;
    public static final int ILLEGALACCESS_EXCEPTION = 626;
    public static final int ORM_METADATA_EXCEPTION = 627;
    public static final int FILE_OPERATE_EXCEPTION = 628;
    protected int exceptionCode;
    private Object objectData;

    public ObjectException(int exceptionCode, String message) {
        super(message);
        this.exceptionCode = exceptionCode;
    }

    public ObjectException(int exceptionCode, Throwable exception) {
        super(exception);
        this.exceptionCode = exceptionCode;
    }

    public ObjectException(int exceptionCode, String message, Throwable exception) {
        super(message, exception);
        this.exceptionCode = exceptionCode;
    }

    public ObjectException(Object obj, int exceptionCode, String message, Throwable exception) {
        super(message, exception);
        this.exceptionCode = exceptionCode;
        this.objectData = obj;
    }

    public ObjectException(Throwable exception) {
        super(exception);
        this.exceptionCode = 601;
    }

    public ObjectException(SQLException exception) {
        this(622, (Throwable)exception);
    }

    public ObjectException(String sql, SQLException e) {
        this(622, sql + " raise " + e.getMessage(), e.getCause());
    }

    public ObjectException(String message) {
        super(message);
        this.exceptionCode = 601;
    }

    public ObjectException(Object obj, int exceptionCode, String message) {
        super(message);
        this.exceptionCode = exceptionCode;
        this.objectData = obj;
    }

    public ObjectException(Object obj, int exceptionCode, Throwable exception) {
        super(exception);
        this.exceptionCode = exceptionCode;
        this.objectData = obj;
    }

    public ObjectException(Object obj, String message) {
        super(message);
        this.exceptionCode = 601;
        this.objectData = obj;
    }

    public ObjectException(Object obj, Throwable exception) {
        super(exception);
        this.exceptionCode = 601;
        this.objectData = obj;
    }

    public static String extortExceptionOriginMessage(Throwable ex) {
        String originErrMessage = ex.getMessage();
        return StringUtils.isBlank((CharSequence)originErrMessage) ? "\u672a\u77e5\u9519\u8bef(" + ex.getClass().getName() + ")\u3002" : originErrMessage;
    }

    public static String extortExceptionTraceMessage(Throwable ex, int maxStacks) {
        StringBuilder errorMsg = new StringBuilder(2048);
        StackTraceElement[] traces = ex.getStackTrace();
        if (traces != null) {
            int len = traces.length > maxStacks ? maxStacks : traces.length;
            for (int i = 0; i < len; ++i) {
                errorMsg.append(traces[i].toString()).append("\r\n");
            }
        }
        return errorMsg.toString();
    }

    public static String extortExceptionMessage(Throwable ex, int maxStacks) {
        return ObjectException.extortExceptionOriginMessage(ex) + "\r\n" + ObjectException.extortExceptionTraceMessage(ex, maxStacks);
    }

    public static String extortExceptionTraceMessage(Throwable ex) {
        return ObjectException.extortExceptionTraceMessage(ex, 15);
    }

    public static String extortExceptionMessage(Throwable ex) {
        return ObjectException.extortExceptionMessage(ex, 15);
    }

    public int getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(int exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public Object getObjectData() {
        return this.objectData;
    }

    public void setObjectData(Object objectData) {
        this.objectData = objectData;
    }

    public String toJSONString() {
        JSONObject object = new JSONObject();
        object.put((Object)"code", (Object)this.exceptionCode);
        object.put((Object)"message", (Object)this.getMessage());
        object.put((Object)"data", this.objectData);
        return object.toJSONString(new JSONWriter.Feature[0]);
    }
}

