/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;

public class Mathematics {
    private static <T> void swap(List<T> list, int i, int j) {
        T temp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, temp);
    }

    private static <T> void reverse(List<T> list, int i, int j) {
        while (i < j) {
            Mathematics.swap(list, i++, j--);
        }
    }

    public static <T> boolean nextPermutation(List<T> list, Comparator<? super T> comparable) {
        int i;
        for (i = list.size() - 1; i > 0 && comparable.compare(list.get(i - 1), list.get(i)) >= 0; --i) {
        }
        if (i == 0) {
            return false;
        }
        int j = list.size() - 1;
        while (comparable.compare(list.get(j), list.get(i - 1)) <= 0) {
            --j;
        }
        Mathematics.swap(list, i - 1, j);
        Mathematics.reverse(list, i, list.size() - 1);
        return true;
    }

    public static <T> boolean prevPermutation(List<T> list, Comparator<? super T> comparable) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        int __last = list.size();
        int __i = __last - 1;
        do {
            int __ip1 = __i--;
            if (comparable.compare(list.get(__i), list.get(__ip1)) < 0) continue;
            int __j = __last;
            while (comparable.compare(list.get(__i), list.get(--__j)) <= 0) {
            }
            Mathematics.swap(list, __i, __j);
            Mathematics.reverse(list, __ip1, __last - 1);
            return true;
        } while (__i != 0);
        Mathematics.reverse(list, 0, __last - 1);
        return false;
    }

    public static <T> void permutation(List<T> listSouce, Comparator<? super T> comparable, Consumer<List<T>> consumer) {
        int len = listSouce.size();
        if (len < 2) {
            consumer.accept(listSouce);
            return;
        }
        listSouce.sort(comparable);
        ArrayList<Integer> comPos = new ArrayList<Integer>(len);
        ArrayList<Boolean> usedItem = new ArrayList<Boolean>(len);
        ArrayList<T> comRes = new ArrayList<T>(len);
        for (int i = 0; i < len; ++i) {
            comPos.add(-1);
            usedItem.add(false);
            comRes.add(null);
        }
        comPos.set(0, 0);
        int sortIndex = 0;
        usedItem.set(0, true);
        block1: while (sortIndex >= 0) {
            int i;
            comRes.set(sortIndex, listSouce.get((Integer)comPos.get(sortIndex)));
            if (sortIndex == len - 2) {
                for (i = 0; i < len; ++i) {
                    if (((Boolean)usedItem.get(i)).booleanValue()) continue;
                    comRes.set(sortIndex + 1, listSouce.get(i));
                    break;
                }
                consumer.accept(comRes);
                while (sortIndex >= 0) {
                    int prePos = (Integer)comPos.get(sortIndex);
                    usedItem.set(prePos, false);
                    while ((Integer)comPos.get(sortIndex) + 1 < len && (((Boolean)usedItem.get((Integer)comPos.get(sortIndex) + 1)).booleanValue() || comparable.compare(listSouce.get(prePos), listSouce.get((Integer)comPos.get(sortIndex) + 1)) == 0)) {
                        comPos.set(sortIndex, (Integer)comPos.get(sortIndex) + 1);
                    }
                    comPos.set(sortIndex, (Integer)comPos.get(sortIndex) + 1);
                    if ((Integer)comPos.get(sortIndex) < len) {
                        usedItem.set((Integer)comPos.get(sortIndex), true);
                        comRes.set(sortIndex, listSouce.get((Integer)comPos.get(sortIndex)));
                        continue block1;
                    }
                    --sortIndex;
                }
                continue;
            }
            for (i = 0; i < len; ++i) {
                if (((Boolean)usedItem.get(i)).booleanValue()) continue;
                comPos.set(sortIndex + 1, i);
                usedItem.set(i, true);
                break;
            }
            ++sortIndex;
        }
    }

    public static <T> void combination(List<T> listSouce, int selected, Comparator<? super T> comparable, Consumer<List<T>> consumer) {
        int len = listSouce.size();
        if (len < selected || selected < 1) {
            return;
        }
        if (len == selected) {
            consumer.accept(listSouce);
            return;
        }
        listSouce.sort(comparable);
        ArrayList<Integer> selectPos = new ArrayList<Integer>(selected);
        ArrayList<T> comRes = new ArrayList<T>(selected);
        for (int i = 0; i < selected; ++i) {
            selectPos.add(i);
            comRes.add(listSouce.get(i));
        }
        int sortIndex = selected - 1;
        while (sortIndex >= 0) {
            if (sortIndex == selected - 1) {
                consumer.accept(comRes);
            }
            while ((Integer)selectPos.get(sortIndex) + 1 < len && comparable.compare(listSouce.get((Integer)selectPos.get(sortIndex)), listSouce.get((Integer)selectPos.get(sortIndex) + 1)) == 0) {
                selectPos.set(sortIndex, (Integer)selectPos.get(sortIndex) + 1);
            }
            selectPos.set(sortIndex, (Integer)selectPos.get(sortIndex) + 1);
            if ((Integer)selectPos.get(sortIndex) <= len - selected + sortIndex) {
                comRes.set(sortIndex, listSouce.get((Integer)selectPos.get(sortIndex)));
                int startPos = (Integer)selectPos.get(sortIndex) + 1;
                for (int i = sortIndex + 1; i < selected; ++i) {
                    selectPos.set(i, startPos);
                    comRes.set(i, listSouce.get(startPos));
                    ++startPos;
                }
                sortIndex = selected - 1;
                continue;
            }
            --sortIndex;
        }
    }

    public static <T> void permutationAndCombination(List<T> listSouce, int selected, Comparator<? super T> comparable, Consumer<List<T>> consumer) {
        Mathematics.combination(listSouce, selected, comparable, oneCom -> Mathematics.permutation(oneCom, comparable, consumer));
    }
}

