/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatetimeOpt {
    private static Logger log = LoggerFactory.getLogger(DatetimeOpt.class);
    public static final String defaultDatePattern = "yyyy-MM-dd";
    public static final String timePattern = "HH:mm";
    public static final String timeWithSecondPattern = "HH:mm:ss";
    public static final String datetimePattern = "yyyy-MM-dd HH:mm:ss";
    public static final String timestampPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String gmtDatePattern = "zone:en:GMT yyyy-MM-dd HH:mm:ss";

    private DatetimeOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static String currentDate() {
        return DatetimeOpt.convertDateToString(new java.util.Date(System.currentTimeMillis()), defaultDatePattern);
    }

    public static String currentTime() {
        return DatetimeOpt.convertDateToString(new java.util.Date(System.currentTimeMillis()), timePattern);
    }

    public static String currentTimeWithSecond() {
        return DatetimeOpt.convertDateToString(new java.util.Date(System.currentTimeMillis()), timeWithSecondPattern);
    }

    public static String currentDatetime() {
        return DatetimeOpt.convertDateToString(new java.util.Date(System.currentTimeMillis()), datetimePattern);
    }

    public static java.util.Date createUtilDate(int year, int month, int date, int hourOfDay, int minute, int second, int milliSecond) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(year, month - 1, date, hourOfDay, minute, second);
        cal.set(14, milliSecond);
        return cal.getTime();
    }

    public static java.util.Date createUtilDate(int year, int month, int date, int hourOfDay, int minute, int second) {
        return DatetimeOpt.createUtilDate(year, month, date, hourOfDay, minute, second, 0);
    }

    public static java.util.Date createUtilDate(int year, int month, int date, int hourOfDay, int minute) {
        return DatetimeOpt.createUtilDate(year, month, date, hourOfDay, minute, 0, 0);
    }

    public static java.util.Date createUtilDate(int year, int month, int date) {
        return DatetimeOpt.createUtilDate(year, month, date, 0, 0, 0, 0);
    }

    public static java.util.Date convertToUtilDate(Date date) {
        return date;
    }

    public static Date convertToSqlDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        return new Date(date.getTime());
    }

    public static Date castObjectToSqlDate(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date instanceof java.util.Date) {
            return new Date(((java.util.Date)date).getTime());
        }
        java.util.Date dt = DatetimeOpt.castObjectToDate(date);
        if (dt == null) {
            return null;
        }
        return new Date(dt.getTime());
    }

    public static Timestamp convertToSqlTimestamp(java.util.Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            return (Timestamp)date;
        }
        return new Timestamp(date.getTime());
    }

    public static Timestamp castObjectToSqlTimestamp(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            return (Timestamp)date;
        }
        if (date instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)date).getTime());
        }
        java.util.Date dt = DatetimeOpt.castObjectToDate(date);
        if (dt == null) {
            return null;
        }
        return new Timestamp(dt.getTime());
    }

    public static Date currentSqlDate() {
        return new Date(System.currentTimeMillis());
    }

    public static java.util.Date currentUtilDate() {
        return new java.util.Date(System.currentTimeMillis());
    }

    public static Timestamp currentSqlTimeStamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Calendar currentCalendarDate() {
        java.util.Date today = DatetimeOpt.currentUtilDate();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(today);
        return cal;
    }

    public static String getDatePattern() {
        return defaultDatePattern;
    }

    public static String getDateTimePattern() {
        return datetimePattern;
    }

    public static Locale fetchLangLocal(String lang) {
        Locale[] locales;
        for (Locale locale : locales = Locale.getAvailableLocales()) {
            if (!StringUtils.equals((CharSequence)locale.getCountry(), (CharSequence)lang)) continue;
            return locale;
        }
        for (Locale locale : locales) {
            if (!StringUtils.equals((CharSequence)locale.getLanguage(), (CharSequence)lang)) continue;
            return locale;
        }
        return Locale.SIMPLIFIED_CHINESE;
    }

    public static TimeZone fetchTimeZone(String zone) {
        if (zone.length() == 3) {
            switch (zone) {
                case "-11": {
                    return TimeZone.getTimeZone("Pacific/Midway");
                }
                case "-10": {
                    return TimeZone.getTimeZone("Pacific/Honolulu");
                }
                case "-09": {
                    return TimeZone.getTimeZone("America/Anchorage");
                }
                case "-08": {
                    return TimeZone.getTimeZone("America/Los_Angeles");
                }
                case "-07": {
                    return TimeZone.getTimeZone("America/Denver");
                }
                case "-06": {
                    return TimeZone.getTimeZone("America/Chicago");
                }
                case "-05": {
                    return TimeZone.getTimeZone("America/New_York");
                }
                case "-04": {
                    return TimeZone.getTimeZone("America/Barbados");
                }
                case "-03": {
                    return TimeZone.getTimeZone("America/Montevideo");
                }
                case "-02": {
                    return TimeZone.getTimeZone("Atlantic/South_Georgia");
                }
                case "-01": {
                    return TimeZone.getTimeZone("Atlantic/Azores");
                }
                case "+00": {
                    return TimeZone.getTimeZone("Europe/London");
                }
                case "+01": {
                    return TimeZone.getTimeZone("Europe/Amsterdam");
                }
                case "+02": {
                    return TimeZone.getTimeZone("Europe/Athens");
                }
                case "+03": {
                    return TimeZone.getTimeZone("Europe/Moscow");
                }
                case "+04": {
                    return TimeZone.getTimeZone("Asia/Yerevan");
                }
                case "+05": {
                    return TimeZone.getTimeZone("Asia/Karachi");
                }
                case "+06": {
                    return TimeZone.getTimeZone("Asia/Rangoon");
                }
                case "+07": {
                    return TimeZone.getTimeZone("Asia/Bangkok");
                }
                case "CST": 
                case "+08": {
                    return TimeZone.getTimeZone("Asia/Shanghai");
                }
                case "+09": {
                    return TimeZone.getTimeZone("Asia/Tokyo");
                }
                case "+10": {
                    return TimeZone.getTimeZone("Australia/Sydney");
                }
                case "+11": {
                    return TimeZone.getTimeZone("Asia/Magadan");
                }
                case "+12": {
                    return TimeZone.getTimeZone("Pacific/Auckland");
                }
            }
        }
        return TimeZone.getTimeZone(zone);
    }

    public static java.util.Date convertStringToDate(String strDate, String sMask) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)sMask)) {
            return DatetimeOpt.smartPraseDate(strDate);
        }
        try {
            SimpleDateFormat df;
            if (sMask.startsWith("lang")) {
                Locale local = DatetimeOpt.fetchLangLocal(sMask.substring(5, 7));
                df = new SimpleDateFormat(sMask.substring(7).trim(), local);
            } else if (sMask.startsWith("zone")) {
                Locale local = DatetimeOpt.fetchLangLocal(sMask.substring(5, 7));
                String zone = sMask.substring(8, 11);
                df = new SimpleDateFormat(sMask.substring(11).trim(), local);
                if ("END".equals(zone) || StringUtils.isNotBlank((CharSequence)strDate)) {
                    int lastInd = strDate.lastIndexOf(32);
                    zone = strDate.substring(lastInd + 1);
                    strDate = strDate.substring(0, lastInd);
                }
                df.setTimeZone(DatetimeOpt.fetchTimeZone(zone));
            } else {
                df = new SimpleDateFormat(sMask);
            }
            return df.parse(strDate);
        }
        catch (ParseException pe) {
            log.error("converting '" + strDate + "' to date with mask '" + sMask + "'" + pe.getMessage());
            return null;
        }
    }

    private static java.util.Date convertStringToDate(String strDate, String sMask, String timeZone) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(sMask);
            if (StringUtils.isNotBlank((CharSequence)timeZone)) {
                df.setTimeZone(DatetimeOpt.fetchTimeZone(timeZone));
            }
            return df.parse(strDate);
        }
        catch (ParseException pe) {
            log.error("converting '" + strDate + "' to date with mask '" + sMask + "'" + pe.getMessage());
            return null;
        }
    }

    public static String convertDateToString(java.util.Date aDate, String aMask) {
        SimpleDateFormat df;
        Locale local;
        if (aDate == null) {
            return null;
        }
        String sMask = aMask == null || "".equals(aMask) ? defaultDatePattern : aMask;
        boolean isGmt = false;
        if (sMask.startsWith("lang")) {
            local = DatetimeOpt.fetchLangLocal(sMask.substring(5, 7));
            df = new SimpleDateFormat(sMask.substring(7).trim(), local);
        } else if (sMask.startsWith("zone")) {
            local = DatetimeOpt.fetchLangLocal(sMask.substring(5, 7));
            String zone = sMask.substring(8, 11);
            if ("GMT".equals(zone)) {
                if (sMask.contains("zzz")) {
                    sMask = sMask.replace("zzz", "").trim();
                }
                df = new SimpleDateFormat(sMask.substring(11).trim(), local);
                isGmt = true;
            } else {
                df = new SimpleDateFormat(sMask.substring(11).trim(), local);
                df.setTimeZone(DatetimeOpt.fetchTimeZone(zone));
            }
        } else {
            df = new SimpleDateFormat(sMask);
        }
        String sDate = df.format(aDate);
        if (isGmt) {
            int offset = TimeZone.getDefault().getRawOffset() / 3600000;
            sDate = sDate + " GMT" + (offset >= 0 ? "+" + offset : Integer.valueOf(offset));
        }
        return sDate;
    }

    public static String convertTimeToString(java.util.Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, timePattern);
    }

    public static String convertTimeWithSecondToString(java.util.Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, timeWithSecondPattern);
    }

    public static String convertDateToString(java.util.Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, defaultDatePattern);
    }

    public static String convertDateToSmartString(java.util.Date aDate) {
        return DatetimeOpt.convertDateToSmartString(aDate, false);
    }

    public static String convertDateToSmartString(java.util.Date aDate, boolean withSecond) {
        long compareDay;
        if (aDate == null) {
            return null;
        }
        java.util.Date currentDay = DatetimeOpt.currentUtilDate();
        long today = currentDay.getTime() / 86400000L;
        if (today == (compareDay = aDate.getTime() / 86400000L)) {
            return "\u4eca\u5929 " + DatetimeOpt.convertDateToString(aDate, withSecond ? timeWithSecondPattern : timePattern);
        }
        if (today == compareDay + 1L) {
            return "\u6628\u5929 " + DatetimeOpt.convertDateToString(aDate, withSecond ? timeWithSecondPattern : timePattern);
        }
        if (today == compareDay + 2L) {
            return "\u524d\u5929 " + DatetimeOpt.convertDateToString(aDate, withSecond ? timeWithSecondPattern : timePattern);
        }
        if (today + 1L == compareDay) {
            return "\u660e\u5929 " + DatetimeOpt.convertDateToString(aDate, withSecond ? timeWithSecondPattern : timePattern);
        }
        if (today + 2L == compareDay) {
            return "\u540e\u5929 " + DatetimeOpt.convertDateToString(aDate, withSecond ? timeWithSecondPattern : timePattern);
        }
        if (DatetimeOpt.getYear(aDate) == DatetimeOpt.getYear(currentDay)) {
            return DatetimeOpt.convertDateToString(aDate, withSecond ? "MM-dd HH:mm:ss" : "MM-dd HH:mm");
        }
        return DatetimeOpt.convertDateToString(aDate, withSecond ? datetimePattern : "yyyy-MM-dd HH:mm");
    }

    public static String convertDateToGMTString(java.util.Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, gmtDatePattern);
    }

    public static String convertDatetimeToString(java.util.Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, datetimePattern);
    }

    public static String convertTimestampToString(java.util.Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, timestampPattern);
    }

    public static String getNowDateTime4String() {
        return DatetimeOpt.convertDateToString(DatetimeOpt.currentUtilDate(), DatetimeOpt.getDateTimePattern());
    }

    public static java.util.Date convertStringToDate(String strDate) {
        return DatetimeOpt.convertStringToDate(strDate, DatetimeOpt.getDatePattern());
    }

    public static int getDayOfWeek(int y, int m, int d) {
        int y0 = y - (14 - m) / 12;
        int x = y0 + y0 / 4 - y0 / 100 + y0 / 400;
        int m0 = m + 12 * ((14 - m) / 12) - 2;
        return (d + x + 31 * m0 / 12) % 7;
    }

    public static int getDayOfWeek(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(7) - 1;
    }

    public static String getDayOfWeekCN(java.util.Date date) {
        String[] weeklist = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", ""};
        return weeklist[DatetimeOpt.getDayOfWeek(date)];
    }

    public static int getSecond(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(13);
    }

    public static int getMilliSecond(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(14);
    }

    public static int getMinute(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(12);
    }

    public static int getHour(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getWeekOfYear(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(3);
    }

    public static int getWeekOfMonth(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(4);
    }

    public static int getDay(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getDayOfYear(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(6);
    }

    public static int getMonth(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getYear(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    private static void resetToZeroPoint(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static java.util.Date truncateToSecond(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date truncateToDay(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        DatetimeOpt.resetToZeroPoint(cal);
        return cal.getTime();
    }

    public static java.util.Date truncateToMonth(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, 1);
        DatetimeOpt.resetToZeroPoint(cal);
        return cal.getTime();
    }

    public static java.util.Date truncateToYear(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        DatetimeOpt.resetToZeroPoint(cal);
        return cal.getTime();
    }

    public static java.util.Date seekEndOfYear(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, 11);
        cal.set(5, 31);
        DatetimeOpt.resetToZeroPoint(cal);
        return cal.getTime();
    }

    public static java.util.Date truncateToWeek(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        DatetimeOpt.resetToZeroPoint(cal);
        int weekDay = cal.get(7);
        if (weekDay > 2) {
            cal.setTimeInMillis(cal.getTimeInMillis() - Double.valueOf((double)(weekDay - 2) * 8.64E7).longValue());
        } else if (weekDay == 1) {
            cal.setTimeInMillis(cal.getTimeInMillis() - Double.valueOf(5.184E8).longValue());
        }
        return cal.getTime();
    }

    public static java.util.Date seekEndOfWeek(java.util.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        DatetimeOpt.resetToZeroPoint(cal);
        int weekDay = cal.get(7);
        if (weekDay > 1) {
            cal.setTimeInMillis(cal.getTimeInMillis() + Double.valueOf((double)(8 - weekDay) * 8.64E7).longValue());
        }
        return cal.getTime();
    }

    public static java.util.Date seekEndOfMonth(java.util.Date date) {
        return DatetimeOpt.addDays(DatetimeOpt.truncateToMonth(DatetimeOpt.addMonths(date, 1)), -1);
    }

    public static java.util.Date addSeconds(java.util.Date date, int nSeconds) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(13, nSeconds);
        return cal.getTime();
    }

    public static java.util.Date addMinutes(java.util.Date date, int nMinutes) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(12, nMinutes);
        return cal.getTime();
    }

    public static java.util.Date addHours(java.util.Date date, int nHours) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(10, nHours);
        return cal.getTime();
    }

    public static java.util.Date addDays(java.util.Date date, int nDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(5, nDays);
        return cal.getTime();
    }

    public static java.util.Date addDays(java.util.Date date, float nDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(date.getTime() + Double.valueOf((double)nDays * 8.64E7).longValue());
        return cal.getTime();
    }

    public static java.util.Date addMonths(java.util.Date date, int nMonths) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(2, nMonths);
        return cal.getTime();
    }

    public static java.util.Date addYears(java.util.Date date, int nYears) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(1, nYears);
        return cal.getTime();
    }

    public static int calcSpanDays(java.util.Date beginDate, java.util.Date endDate) {
        java.util.Date bD = beginDate.getTime() > endDate.getTime() ? DatetimeOpt.truncateToDay(endDate) : DatetimeOpt.truncateToDay(beginDate);
        java.util.Date eD = beginDate.getTime() > endDate.getTime() ? beginDate : endDate;
        return (int)((eD.getTime() - bD.getTime()) / 86400000L + 1L);
    }

    public static double calcDateSpan(java.util.Date beginDate, java.util.Date endDate) {
        return (double)(beginDate.getTime() - endDate.getTime()) / 8.64E7;
    }

    public static java.util.Date calcWeek1stDay(int nYear, int nWeekNo) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 1);
        cal.set(1, nYear);
        cal.set(3, nWeekNo);
        return cal.getTime();
    }

    public static java.util.Date calcWeekLastDay(int nYear, int nWeekNo) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 7);
        cal.set(1, nYear);
        cal.set(3, nWeekNo);
        return cal.getTime();
    }

    public static int calcWeekendDays(java.util.Date beginDate, java.util.Date endDate) {
        int nWeekDay = DatetimeOpt.getDayOfWeek(beginDate);
        int m = DatetimeOpt.calcSpanDays(beginDate, endDate);
        int weekEnds = (m + nWeekDay) / 7;
        int nWeekDay2 = (m + nWeekDay) % 7;
        int days = weekEnds * 2 - (nWeekDay == 0 ? 0 : 1) + (nWeekDay2 > 0 ? 1 : 0);
        return days;
    }

    public static int calcWeekDays(java.util.Date beginDate, java.util.Date endDate, int weekDay) {
        int nWeekDay = DatetimeOpt.getDayOfWeek(beginDate);
        int m = DatetimeOpt.calcSpanDays(beginDate, endDate);
        return m / 7 + (weekDay >= nWeekDay && nWeekDay + m % 7 > weekDay || weekDay + 7 >= nWeekDay && nWeekDay + m % 7 > weekDay + 7 ? 1 : 0);
    }

    public static boolean equalOnSecond(java.util.Date oneDate, java.util.Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 1000L == otherDate.getTime() / 1000L;
    }

    public static boolean equalOnMinute(java.util.Date oneDate, java.util.Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 60000L == otherDate.getTime() / 60000L;
    }

    public static boolean equalOnHour(java.util.Date oneDate, java.util.Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 3600000L == otherDate.getTime() / 3600000L;
    }

    public static boolean equalOnDay(java.util.Date oneDate, java.util.Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 86400000L == otherDate.getTime() / 86400000L;
    }

    public static int compareTwoDate(java.util.Date oneDate, java.util.Date otherDate) {
        if (oneDate == null && otherDate == null) {
            return 0;
        }
        if (oneDate == null) {
            return -1;
        }
        if (otherDate == null) {
            return 1;
        }
        return oneDate.compareTo(otherDate);
    }

    public static java.util.Date smartPraseDate(String sDate) {
        if (StringUtils.isBlank((CharSequence)sDate)) {
            return null;
        }
        if (sDate.length() > 8 && sDate.length() < 14 && Pattern.matches("\\d+", sDate)) {
            return new java.util.Date(Long.parseLong(sDate));
        }
        String sTD = StringRegularOpt.trimDateString(sDate);
        String timeZone = null;
        int sl = sDate.length();
        int tzb = sDate.indexOf("GMT");
        if (tzb > 0) {
            timeZone = sDate.substring(tzb);
        } else {
            char c;
            for (tzb = sl - 1; tzb > 0 && ((c = sDate.charAt(tzb)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '/'); --tzb) {
            }
            if (sl - tzb > 3) {
                timeZone = sDate.substring(tzb + 1);
            }
        }
        sl = sTD.length();
        switch (sl) {
            case 5: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM", timeZone);
            }
            case 7: {
                return DatetimeOpt.convertStringToDate(sTD, "yyyy-MM", timeZone);
            }
            case 8: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM-dd", timeZone);
            }
            case 10: {
                if (sTD.indexOf(45) == 2) {
                    return DatetimeOpt.convertStringToDate(sTD, "MM-dd-yyyy", timeZone);
                }
                return DatetimeOpt.convertStringToDate(sTD, defaultDatePattern, timeZone);
            }
            case 11: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM-dd HH", timeZone);
            }
            case 13: {
                return DatetimeOpt.convertStringToDate(sTD, "yyyy-MM-dd HH", timeZone);
            }
            case 14: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM-dd HH:mm", timeZone);
            }
            case 16: {
                return DatetimeOpt.convertStringToDate(sTD, "yyyy-MM-dd HH:mm", timeZone);
            }
            case 17: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM-dd HH:mm:ss", timeZone);
            }
            case 19: {
                return DatetimeOpt.convertStringToDate(sTD, datetimePattern, timeZone);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                java.util.Date date = DatetimeOpt.convertStringToDate(sTD, timestampPattern, timeZone);
                if (date != null && sDate.charAt(10) == 'T') {
                    date.setTime(date.getTime() + (long)TimeZone.getDefault().getRawOffset());
                }
                return date;
            }
        }
        return null;
    }

    public static final java.util.Date castObjectToDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof java.util.Date) {
            return (java.util.Date)obj;
        }
        if (obj instanceof Number) {
            return new java.util.Date(((Number)obj).longValue());
        }
        if (obj instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)obj;
            return java.util.Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (obj instanceof LocalDate) {
            LocalDate ldt = (LocalDate)obj;
            return java.util.Date.from(ldt.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        }
        return DatetimeOpt.smartPraseDate(StringBaseOpt.objectToString(obj));
    }
}

