/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import com.centit.support.xml.XMLObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SoapWsdlParser {
    protected static final Logger logger = LoggerFactory.getLogger(SoapWsdlParser.class);

    public static Element findTypeElement(Element rootElement, String typeName) {
        Element portTypes = rootElement.element("types");
        if (portTypes == null) {
            return null;
        }
        List schemas = portTypes.elements("schema");
        for (Element schema : schemas) {
            for (Element typeElm : schema.elements("element")) {
                if (!typeElm.attribute("name").getValue().equals(typeName)) continue;
                return typeElm;
            }
        }
        return null;
    }

    public static Map<String, String> mapElementType(Element operationElem) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        Element element = operationElem.element("complexType");
        if (element == null) {
            return stringMap;
        }
        if ((element = element.element("sequence")) == null) {
            return stringMap;
        }
        for (Element elem : element.elements("element")) {
            String name = elem.attribute("name").getValue();
            String type = elem.attribute("type").getValue();
            stringMap.put(name, type);
        }
        return stringMap;
    }

    public static String getSoapNameSpace(Element rootElement) {
        Attribute attr = rootElement.attribute("targetNamespace");
        if (attr != null) {
            return attr.getValue();
        }
        return "missing!";
    }

    public static List<String> getSoapActionList(Element rootElement) {
        ArrayList<String> methods = new ArrayList<String>();
        List portTypes = rootElement.elements("portType");
        for (Element portType : portTypes) {
            for (Element operation : portType.elements("operation")) {
                Attribute nameAttr = operation.attribute("name");
                if (nameAttr == null) continue;
                methods.add(nameAttr.getValue());
            }
        }
        return methods;
    }

    public static Element findOperationElement(Element rootElement, String typeName) {
        List portTypes = rootElement.elements("portType");
        for (Element portType : portTypes) {
            for (Element operation : portType.elements("operation")) {
                Attribute nameAttr = operation.attribute("name");
                if (nameAttr == null || !typeName.equals(nameAttr.getValue())) continue;
                return operation;
            }
        }
        return null;
    }

    public static Element findElementByName(Element rootElement, String element, String nameValue) {
        List messages = rootElement.elements(element);
        for (Element message : messages) {
            Attribute nameAttr = message.attribute("name");
            if (nameAttr == null || !nameValue.equals(nameAttr.getValue())) continue;
            return message;
        }
        return null;
    }

    public static String getSoapActionInputName(Element rootElement, String actionName) {
        String msgName;
        Element operationElem = SoapWsdlParser.findOperationElement(rootElement, actionName);
        if (operationElem == null) {
            return actionName;
        }
        Element inputElm = operationElem.element("input");
        if (inputElm == null) {
            return actionName;
        }
        Attribute msgAttr = inputElm.attribute("message");
        if (msgAttr != null && !StringUtils.isBlank((CharSequence)(msgName = msgAttr.getValue()))) {
            int p = msgName.indexOf(":");
            if (p >= 0) {
                msgName = msgName.substring(p + 1);
            }
            return msgName;
        }
        Attribute nameAttr = inputElm.attribute("name");
        if (nameAttr != null) {
            return nameAttr.getValue();
        }
        return actionName;
    }

    public static Map<String, String> getSoapActionParams(Element rootElement, String actionName) {
        Element typeElem;
        String inputName;
        HashMap<String, String> params = new HashMap<String, String>();
        String typeName = inputName = SoapWsdlParser.getSoapActionInputName(rootElement, actionName);
        Element msgElm = SoapWsdlParser.findElementByName(rootElement, "message", inputName);
        if (msgElm != null) {
            String partName;
            Attribute partAttr;
            Element partElm = SoapWsdlParser.findElementByName(msgElm, "part", "parameters");
            if (partElm == null) {
                partElm = msgElm.element("part");
            }
            if (partElm != null && (partAttr = partElm.attribute("element")) != null && StringUtils.isNotBlank((CharSequence)(partName = partAttr.getValue()))) {
                int p = partName.indexOf(":");
                typeName = p >= 0 ? partName.substring(p + 1) : partName;
            }
        }
        if ((typeElem = SoapWsdlParser.findTypeElement(rootElement, typeName)) == null) {
            return params;
        }
        return SoapWsdlParser.mapElementType(typeElem);
    }

    public static String buildSoapXml(String soapNameSpace, String inputName, Object requestBody) {
        String xmlBoday = XMLObject.objectToXMLString("act:" + inputName, requestBody, false, false);
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        sb.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" ").append("xmlns:act=\"").append(soapNameSpace).append("\" >").append("<soapenv:Header/> ").append("<soapenv:Body>").append(xmlBoday).append("</soapenv:Body>").append("</soapenv:Envelope>");
        return sb.toString();
    }
}

