/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import com.centit.support.common.ObjectException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public abstract class HardWareUtils {
    public static LinkedHashSet<InetAddress> localAddressList(Function<InetAddress, Boolean> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new ObjectException(e);
        }
        if (networkInterfaces == null) {
            throw new ObjectException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressFilter && !addressFilter.apply(inetAddress).booleanValue()) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = HardWareUtils.localAddressList(address -> false == address.isLoopbackAddress() && address instanceof Inet4Address);
        if (localAddressList != null && !localAddressList.isEmpty()) {
            InetAddress address2 = null;
            for (InetAddress inetAddress : localAddressList) {
                if (!inetAddress.isSiteLocalAddress()) {
                    return inetAddress;
                }
                if (null != address2) continue;
                address2 = inetAddress;
            }
            if (null != address2) {
                return address2;
            }
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static byte[] getHardwareAddress(InetAddress inetAddress) {
        if (null == inetAddress) {
            return null;
        }
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (null != networkInterface) {
                return networkInterface.getHardwareAddress();
            }
        }
        catch (SocketException e) {
            throw new ObjectException(e);
        }
        return null;
    }

    public static int getPid() throws ObjectException {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (StringUtils.isBlank((CharSequence)processName)) {
            throw new ObjectException("Process name is blank!");
        }
        int atIndex = processName.indexOf(64);
        if (atIndex > 0) {
            return Integer.parseInt(processName.substring(0, atIndex));
        }
        return processName.hashCode();
    }
}

