/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.algorithm.ByteBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.network.HardWareUtils;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.binary.Base64;

public class Snowflake
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static long DEFAULT_TWEPOCH = 1288834974657L;
    public static long DEFAULT_TIME_OFFSET = 2000L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long twepoch = DEFAULT_TWEPOCH;
    private final long workerId;
    private final long dataCenterId;
    private final boolean useSystemClock;
    private final long timeOffset;
    private final long randomSequenceLimit;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public static long makeWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        try {
            mpid.append(HardWareUtils.getPid());
        }
        catch (ObjectException objectException) {
            // empty catch block
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public static long makeDataCenterId(long maxDatacenterId) {
        if (maxDatacenterId == Long.MAX_VALUE) {
            --maxDatacenterId;
        }
        long id = 1L;
        byte[] mac = null;
        try {
            mac = HardWareUtils.getHardwareAddress(HardWareUtils.getLocalhost());
        }
        catch (ObjectException objectException) {
            // empty catch block
        }
        if (null != mac) {
            id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
            id %= maxDatacenterId + 1L;
        }
        return id;
    }

    public Snowflake() {
        this.dataCenterId = Snowflake.makeDataCenterId(31L);
        this.workerId = Snowflake.makeWorkerId(this.dataCenterId, 31L);
        this.useSystemClock = false;
        this.timeOffset = DEFAULT_TIME_OFFSET;
        this.randomSequenceLimit = 0L;
    }

    public Snowflake(long workerId, long dataCenterId) {
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.useSystemClock = false;
        this.timeOffset = DEFAULT_TIME_OFFSET;
        this.randomSequenceLimit = 0L;
    }

    public long getWorkerId(long id) {
        return id >> 12 & 0x1FL;
    }

    public long getDataCenterId(long id) {
        return id >> 17 & 0x1FL;
    }

    public long getGenerateDateTime(long id) {
        return (id >> 22 & 0x1FFFFFFFFFFL) + this.twepoch;
    }

    public synchronized long nextId() {
        long timestamp = this.genTime();
        if (timestamp < this.lastTimestamp) {
            if (this.lastTimestamp - timestamp < this.timeOffset) {
                timestamp = this.lastTimestamp;
            } else {
                throw new ObjectException("Clock moved backwards. Refusing to generate id for " + (this.lastTimestamp - timestamp) + "ms");
            }
        }
        if (timestamp == this.lastTimestamp) {
            long sequence = this.sequence + 1L & 0xFFFL;
            if (sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
            this.sequence = sequence;
        } else {
            this.sequence = this.randomSequenceLimit > 1L ? ThreadLocalRandom.current().nextLong(this.randomSequenceLimit) : 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    public String nextIdStr() {
        return Long.toString(this.nextId());
    }

    public String nextIdHex() {
        return Long.toHexString(this.nextId());
    }

    public String nextIdBase64() {
        byte[] uidBytes = new byte[8];
        ByteBaseOpt.writeInt64(uidBytes, this.nextId(), 0);
        return new String(Base64.encodeBase64URLSafe((byte[])uidBytes));
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.genTime();
        while (timestamp == lastTimestamp) {
            timestamp = this.genTime();
        }
        if (timestamp < lastTimestamp) {
            throw new ObjectException("Clock moved backwards. Refusing to generate id for " + (lastTimestamp - timestamp) + "ms");
        }
        return timestamp;
    }

    private long genTime() {
        return System.currentTimeMillis();
    }
}

