/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Md5Encoder {
    protected static final Logger logger = LoggerFactory.getLogger(Md5Encoder.class);

    private Md5Encoder() {
        throw new IllegalAccessError("Utility class");
    }

    public static byte[] rawEncode(byte[] data) {
        try {
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            MD5.update(data, 0, data.length);
            return MD5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encode(byte[] data) {
        byte[] md5Code = Md5Encoder.rawEncode(data);
        if (md5Code != null) {
            return new String(Hex.encodeHex((byte[])md5Code));
        }
        return null;
    }

    public static String encode(String data) {
        try {
            return Md5Encoder.encode(data.getBytes("utf8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encodeBase64(byte[] data, boolean urlSafe) {
        byte[] md5Code = Md5Encoder.rawEncode(data);
        if (md5Code != null) {
            return new String(urlSafe ? Base64.encodeBase64URLSafe((byte[])md5Code) : Base64.encodeBase64((byte[])md5Code), 0, 22);
        }
        return null;
    }

    public static String encodeBase64(byte[] data) {
        return Md5Encoder.encodeBase64(data, false);
    }

    public static String encodeBase64(String data, boolean urlSafe) {
        try {
            return Md5Encoder.encodeBase64(data.getBytes("utf8"), urlSafe);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encodeBase64(String data) {
        return Md5Encoder.encodeBase64(data, false);
    }

    public static String encodePasswordAsSpringSecurity(String data, String salt) {
        return Md5Encoder.encode(data + "{" + salt + "}");
    }

    public static String encodePasswordAsJasigCas(String data, String salt, int iterations) {
        try {
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            byte[] saltBytes = salt.getBytes("utf8");
            MD5.update(saltBytes, 0, saltBytes.length);
            byte[] hashedBytes = MD5.digest(data.getBytes("utf8"));
            for (int i = 0; i < iterations - 1; ++i) {
                hashedBytes = MD5.digest(hashedBytes);
            }
            return new String(Hex.encodeHex((byte[])hashedBytes));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encodePassword(String data, String salt) {
        return Md5Encoder.encodePasswordAsSpringSecurity(data, salt);
    }

    public static String encodePasswordWithDoubleMd5(String data, String salt) {
        return Md5Encoder.encodePasswordAsSpringSecurity(Md5Encoder.encode(data), salt);
    }
}

