/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.extend;

import java.io.File;
import java.io.FileReader;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSRuntimeContext {
    protected static final Logger logger = LoggerFactory.getLogger(JSRuntimeContext.class);
    private ScriptEngine scriptEngine;

    public JSRuntimeContext() {
        ScriptEngineManager sem = new ScriptEngineManager();
        this.scriptEngine = sem.getEngineByName("js");
    }

    public JSRuntimeContext compileScript(String js) {
        try {
            this.scriptEngine.eval(js);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return this;
    }

    public JSRuntimeContext compileScriptFile(String jsFileName) {
        try {
            FileReader reader = new FileReader(new File(jsFileName));
            this.scriptEngine.eval(reader);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return this;
    }

    public Object callJsFunc(String funcName, Object ... args) throws ScriptException, NoSuchMethodException {
        Invocable invocable = (Invocable)((Object)this.scriptEngine);
        return invocable.invokeFunction(funcName, args);
    }

    public Object getJsObject(String objName) {
        return this.scriptEngine.get(objName);
    }

    public Object getJsObjectProperty(String objName, String propertyName) throws ScriptException {
        return this.scriptEngine.eval(objName + "." + propertyName);
    }

    public Object callJsObjectMethod(Object jsObject, String methodName, Object ... args) throws ScriptException, NoSuchMethodException {
        Invocable invocable = (Invocable)((Object)this.scriptEngine);
        return invocable.invokeMethod(jsObject, methodName, args);
    }
}

