/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import java.util.ArrayList;
import java.util.List;

public class TreeNode<T> {
    private T value;
    private TreeNode<T> praent;
    private List<TreeNode<T>> children;

    public TreeNode() {
        this.children = null;
        this.praent = null;
    }

    public TreeNode(T value) {
        this.value = value;
        this.children = null;
        this.praent = null;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode<T>> children) {
        this.children = children;
    }

    public TreeNode<T> addChild(T child) {
        TreeNode<T> treeNode = new TreeNode<T>(child);
        this.addChild(treeNode);
        return treeNode;
    }

    public void addChild(TreeNode<T> child) {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode<T>>();
        }
        child.praent = this;
        this.children.add(child);
    }

    public TreeNode<T> getPraent() {
        return this.praent;
    }

    public void setPraent(TreeNode<T> praent) {
        this.praent = praent;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.size() == 0;
    }

    public boolean isRoot() {
        return this.praent == null;
    }

    public JSONObject toJSONObject(String childrenPropertyName) {
        JSONObject jo;
        if (ReflectionOpt.isScalarType(this.getValue().getClass())) {
            jo = new JSONObject();
            jo.put("value", (Object)StringBaseOpt.objectToString(this.getValue()));
        } else {
            jo = (JSONObject)JSON.toJSON(this.getValue());
        }
        if (this.children != null && this.children.size() > 0) {
            JSONArray ja = new JSONArray();
            for (TreeNode<T> c : this.children) {
                ja.add((Object)c.toJSONObject(childrenPropertyName));
            }
            jo.put(childrenPropertyName, (Object)ja);
        }
        return jo;
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject("children");
    }

    public String toString() {
        return this.toJSONObject("children").toJSONString();
    }

    public int getPathCount() {
        int result = 0;
        for (TreeNode<T> path = this; path != null; path = path.getPraent()) {
            ++result;
        }
        return result;
    }

    public TreeNode<T>[] getTreeNodePath() {
        int i = this.getPathCount();
        TreeNode[] result = new TreeNode[i--];
        for (TreeNode<T> path = this; path != null; path = path.getPraent()) {
            result[i--] = path;
        }
        return result;
    }

    public TreeNode<T> getRootTreeNode() {
        for (TreeNode<T> path = this; path != null; path = path.getPraent()) {
            if (!path.isRoot()) continue;
            return path;
        }
        return this;
    }

    public T[] getPath() {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        for (TreeNode<T> path = this; path != null; path = path.getPraent()) {
            result[i--] = path.getValue();
        }
        return result;
    }

    public T getRootValue() {
        T rootValue = this.getValue();
        for (TreeNode<T> path = this.getPraent(); path != null; path = path.getPraent()) {
            rootValue = path.getValue();
        }
        return rootValue;
    }

    public static JSONArray toJSONArray(List<? extends TreeNode<? extends Object>> forest, String childrenPropertyName) {
        JSONArray ja = new JSONArray();
        for (TreeNode<? extends Object> treeNode : forest) {
            ja.add((Object)treeNode.toJSONObject(childrenPropertyName));
        }
        return ja;
    }

    public static JSONArray toJSONArray(List<? extends TreeNode<? extends Object>> forest) {
        return TreeNode.toJSONArray(forest, "children");
    }
}

