/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.common.JavaBeanField;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JavaBeanMetaData {
    private Class<?> javaType;
    private Map<String, JavaBeanField> fileds;

    private JavaBeanMetaData() {
    }

    private JavaBeanMetaData(Class<?> javaType) {
        this.javaType = javaType;
        this.fileds = new HashMap<String, JavaBeanField>(30);
    }

    public static JavaBeanMetaData createBeanMetaDataFromType(Class<?> javaType, int getType) {
        List<Method> setters;
        JavaBeanField javaField;
        String fieldName;
        List<Method> getters;
        Field[] objFields;
        JavaBeanMetaData metaData = new JavaBeanMetaData(javaType);
        for (Field field : objFields = javaType.getDeclaredFields()) {
            metaData.getFileds().put(field.getName(), new JavaBeanField(field));
        }
        if ((getType == 1 || getType == 3) && (getters = ReflectionOpt.getAllGetterMethod(javaType)) != null) {
            for (Method md : getters) {
                fieldName = ReflectionOpt.mapGetter2Field(md);
                javaField = metaData.getFiled(fieldName);
                if (javaField == null) {
                    javaField = new JavaBeanField();
                    javaField.setGetFieldValueFunc(md);
                    javaField.setFieldType(md.getReturnType());
                    metaData.getFileds().put(fieldName, javaField);
                    continue;
                }
                if (!javaField.isAssignableFrom(md.getReturnType())) continue;
                javaField.setGetFieldValueFunc(md);
            }
        }
        if ((getType == 2 || getType == 3) && (setters = ReflectionOpt.getAllSetterMethod(javaType)) != null) {
            for (Method md : setters) {
                fieldName = StringUtils.uncapitalize((String)md.getName().substring(3));
                javaField = metaData.getFiled(fieldName);
                if (javaField == null) {
                    javaField = new JavaBeanField();
                    javaField.setSetFieldValueFunc(md);
                    javaField.setFieldType(md.getParameterTypes()[0]);
                    metaData.getFileds().put(fieldName, javaField);
                    continue;
                }
                if (!javaField.isAssignableFrom(md.getParameterTypes()[0])) continue;
                javaField.setSetFieldValueFunc(md);
            }
        }
        return metaData;
    }

    public static JavaBeanMetaData createBeanMetaDataFromType(Class<?> javaType) {
        return JavaBeanMetaData.createBeanMetaDataFromType(javaType, 3);
    }

    public Object createBeanObject() throws IllegalAccessException, InstantiationException {
        return this.javaType.newInstance();
    }

    public Object createBeanObjectFromMap(Map<String, Object> properties) throws IllegalAccessException, InstantiationException {
        Object object = this.javaType.newInstance();
        for (Map.Entry<String, Object> pro : properties.entrySet()) {
            this.setObjectFieldValue(object, pro.getKey(), pro.getValue());
        }
        return object;
    }

    public void setObjectFieldValue(Object object, String fieldName, Object newValue) {
        JavaBeanField field = this.getFiled(fieldName);
        if (field == null) {
            return;
        }
        field.setObjectFieldValue(object, newValue);
    }

    public Object getObjectFieldValue(Object object, String fieldName) {
        JavaBeanField field = this.getFiled(fieldName);
        if (field == null) {
            return null;
        }
        return field.getObjectFieldValue(object);
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Map<String, JavaBeanField> getFileds() {
        return this.fileds;
    }

    public JavaBeanField getFiled(String fieldName) {
        return this.fileds.get(fieldName);
    }
}

