/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.centit.support.file.FileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExcelTypeEnum {
    HSSF,
    XSSF,
    NOTEXCEL;

    protected static final Logger logger;

    public static ExcelTypeEnum checkFileExcelType(byte[] headerBytes) throws IOException {
        String fileHead = String.valueOf(Hex.encodeHex((byte[])headerBytes, (boolean)false));
        if (fileHead.startsWith("D0CF11E0")) {
            return HSSF;
        }
        if (fileHead.startsWith("504B0304")) {
            return XSSF;
        }
        return NOTEXCEL;
    }

    public static ExcelTypeEnum checkFileExcelType(InputStream inputStream) throws IOException {
        byte[] b = new byte[28];
        inputStream.read(b, 0, 28);
        return ExcelTypeEnum.checkFileExcelType(b);
    }

    public static ExcelTypeEnum checkFileExcelType(String filePath) {
        ExcelTypeEnum excelTypeEnum;
        String suffix = FileType.getFileExtName((String)filePath);
        if ("xls".equalsIgnoreCase(suffix)) {
            return HSSF;
        }
        if ("xlsx".equalsIgnoreCase(suffix)) {
            return XSSF;
        }
        FileInputStream inputStream = new FileInputStream(new File(filePath));
        try {
            excelTypeEnum = ExcelTypeEnum.checkFileExcelType(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return NOTEXCEL;
            }
        }
        ((InputStream)inputStream).close();
        return excelTypeEnum;
    }

    static {
        logger = LoggerFactory.getLogger(ExcelTypeEnum.class);
    }
}

